/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import util.Common;
import util.struct.DFormat;
import util.struct.DImage;
import util.struct.DPalette;
import util.struct.DPath;
import util.struct.formats.Nitro3D;
import util.struct.graphics.CImage;
import util.struct.graphics.CPalette;

public class Nitro3DNsbtx
extends DImage {
    public Nitro3DNsbtx(DPath path) {
        super(path);
    }

    public void open() {
        Nitro3D blocks = new Nitro3D(this.getPath());
        Nitro3DNsbtx.readTEX0(this, blocks.getBlockData("TEX0"));
    }

    public static void readTEX0(DFormat fileFormat, byte[] data) {
        int padding1 = Common.getInt(data, 8, 4);
        int textureDataSize = Common.getInt(data, 12, 2);
        int textureInfoOffset = Common.getInt(data, 14, 2);
        int padding2 = Common.getInt(data, 16, 4);
        int textureDataOffset = Common.getInt(data, 20, 4);
        int padding3 = Common.getInt(data, 24, 4);
        int compDataSize = Common.getInt(data, 28, 2);
        int compInfoOffset = Common.getInt(data, 30, 2);
        int padding4 = Common.getInt(data, 32, 4);
        int compDataOffset = Common.getInt(data, 36, 4);
        int compExDataOffset = Common.getInt(data, 40, 4);
        int padding5 = Common.getInt(data, 44, 4);
        int paletteDataSize = Common.getInt(data, 48, 4) << 3;
        int paletteInfoOffset = Common.getInt(data, 52, 4);
        int paletteDataOffset = Common.getInt(data, 56, 4);
        Common.msg("Texture Data Size: " + Common.getHex(textureDataSize, 2));
        Common.msg("Texture Info Offset: " + Common.getHex(textureInfoOffset, 2));
        Common.msg("Texture Data Offset: " + Common.getHex(textureDataOffset, 2));
        Common.msg("Compressed Texture Data Size: " + Common.getHex(compDataSize, 2));
        Common.msg("Compressed Texture Info Offset: " + Common.getHex(compInfoOffset, 2));
        Common.msg("Compressed Texture Data Offset: " + Common.getHex(compDataOffset, 2));
        Common.msg("Compressed Texture Info Data Offset: " + Common.getHex(compExDataOffset, 2));
        Common.msg("Palette Data Size: " + Common.getHex(paletteDataSize, 2));
        Common.msg("Palette Info Offset: " + Common.getHex(paletteInfoOffset, 2));
        Common.msg("Palette Data Offset: " + Common.getHex(paletteDataOffset, 2));
        if (padding1 != 0) {
            Common.error("Padding1 != 0: " + padding1);
        }
        if (padding2 != 0) {
            Common.error("Padding2 != 0: " + padding2);
        }
        if (padding3 != 0) {
            Common.error("Padding3 != 0: " + padding3);
        }
        if (padding4 != 0) {
            Common.error("Padding4 != 0: " + padding4);
        }
        if (padding5 != 0) {
            Common.error("Padding5 != 0: " + padding5);
        }
        Common.line();
        Common.msg("Texture Section");
        Common.line();
        CImage.CImageFormat[] formats = new CImage.CImageFormat[]{null, CImage.getFormat(30), CImage.getFormat(2), CImage.getFormat(4), CImage.getFormat(8), CImage.getFormat(32), CImage.getFormat(31), CImage.getFormat(16)};
        ArrayList<Nitro3D.ObjectInfo> textureInfo = Nitro3D.getInfo(data, textureInfoOffset);
        DImage imageFormat = new DImage(new DPath(fileFormat.getPath()));
        if (fileFormat instanceof DImage) {
            imageFormat = (DImage)fileFormat;
        }
        for (int i = 0; i < textureInfo.size(); ++i) {
            Nitro3D.ObjectInfo t = textureInfo.get(i);
            int offset = Common.getInt(t.getData(), 0, 2) << 3;
            int params = Common.getInt(t.getData(), 2, 2);
            int var4 = Common.getInt(t.getData(), 4, 1);
            int var5 = Common.getInt(t.getData(), 5, 1);
            int var6 = Common.getInt(t.getData(), 6, 1);
            int var7 = Common.getInt(t.getData(), 7, 1);
            int var0 = params & 0xF;
            int width = 8 << (params >> 4 & 7);
            int height = 8 << (params >> 7 & 7);
            int format = params >> 10 & 7;
            int palette = params >> 13 & 7;
            byte[] imageData = null;
            int dataSize = width * height * formats[format].getDepth() / 8;
            if (format == 5) {
                imageData = new byte[dataSize + dataSize / 2];
                byte[] compData = Common.getBytes(data, compDataOffset + offset, dataSize);
                byte[] compInfo = Common.getBytes(data, compExDataOffset + offset / 2, dataSize / 2);
                System.arraycopy(compData, 0, imageData, 0, compData.length);
                System.arraycopy(compInfo, 0, imageData, compData.length, compInfo.length);
            } else {
                imageData = Common.getBytes(data, textureDataOffset + offset, dataSize);
            }
            Common.msg("-> #" + Common.padNum(i, 2) + " | Offset: " + Common.getHex(offset, 2) + " | Var0: " + var0 + " | " + Common.padNum(width, 3) + "x" + Common.padNum(height, 3) + " | Format: " + formats[format] + " | Palette: " + palette + " | Unknown: " + Common.padNum(var4, 3) + " | " + Common.padNum(var5, 3) + " | " + Common.padNum(var6, 3) + " | " + Common.padNum(var7, 3) + " | Name: " + t.getName());
            CImage image = new CImage(imageData, formats[format].getId());
            image.setName(t.getName());
            image.setSize(width, height);
            imageFormat.add(image);
        }
        ArrayList<Nitro3D.ObjectInfo> paletteInfo = Nitro3D.getInfo(data, paletteInfoOffset);
        DPalette paletteBank = new DPalette(new DPath(fileFormat.getPath()));
        int poffset = 0;
        for (int i = 0; i < paletteInfo.size(); ++i) {
            int j;
            CPalette clone = null;
            Nitro3D.ObjectInfo p = paletteInfo.get(i);
            int offset = Common.getInt(p.getData(), 0, 2) << 3;
            int unknown = Common.getInt(p.getData(), 2, 2);
            int colorCount = paletteDataSize - offset;
            for (j = i + 1; j < paletteInfo.size(); ++j) {
                int noffset = Common.getInt(paletteInfo.get(j).getData(), 0, 2) << 3;
                if (noffset <= offset) continue;
                colorCount = noffset - offset;
                break;
            }
            if (offset < poffset) {
                for (j = 0; j < i; ++j) {
                    int coffset = Common.getInt(paletteInfo.get(j).getData(), 0, 2) << 3;
                    if (coffset != offset) continue;
                    clone = paletteBank.get(j);
                    colorCount = clone.getColorCount();
                    break;
                }
            }
            poffset = offset;
            String msg = "-> #" + Common.padNum(i, 2) + " | Unknown: " + Common.getHex(p.getUnknown(), 4) + " | Offset: " + Common.getHex(offset, 4) + " | Var2: " + Common.getHex(unknown, 2) + " | Colors: " + Common.padNum(colorCount, 3) + " | Name: " + p.getName();
            CPalette palette = null;
            if (clone == null) {
                Common.msg(msg);
                byte[] colors = Common.getBytes(data, paletteDataOffset + offset, colorCount);
                palette = new CPalette(p.getName(), colors, CPalette.BGR555);
            } else {
                Common.error(msg + " | Clone of " + clone.getName());
                palette = new CPalette(clone);
                palette.setName(p.getName());
            }
            paletteBank.add(palette);
        }
        fileFormat.addInternal(paletteBank);
        if (!(fileFormat instanceof DImage)) {
            Common.msg("Add Internal Texture");
            fileFormat.addInternal(imageFormat);
        }
    }
}

