/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import util.Common;
import util.struct.DModel;
import util.struct.DPath;
import util.struct.formats.Nitro3D;
import util.struct.formats.Nitro3DNsbtx;
import util.struct.models.CModel;

public class Nitro3DNsbmd
extends DModel {
    public Nitro3DNsbmd(DPath path) {
        super(path);
    }

    public void open() {
        Nitro3D blocks = new Nitro3D(this.getPath());
        this.readMDL0(blocks.getBlockData("MDL0"));
        Nitro3DNsbtx.readTEX0(this, blocks.getBlockData("TEX0"));
    }

    public void readMDL0(byte[] data) {
        ArrayList<Nitro3D.ObjectInfo> modelInfo = Nitro3D.getInfo(data, 8);
        for (int i = 0; i < modelInfo.size(); ++i) {
            Nitro3D.ObjectInfo m = modelInfo.get(i);
            int offset = Common.getInt(m.getData());
            int blockSize = Common.getInt(data, offset, 4);
            int boneOffset = Common.getInt(data, offset + 4, 4);
            int matOffset = Common.getInt(data, offset + 8, 4);
            int polyStart = Common.getInt(data, offset + 12, 4);
            int polyEnd = Common.getInt(data, offset + 16, 4);
            int unknown = Common.getInt(data, offset + 20, 1);
            int unknown2 = Common.getInt(data, offset + 21, 1);
            int unknown3 = Common.getInt(data, offset + 22, 1);
            int objCount = Common.getInt(data, offset + 23, 1);
            int matCount = Common.getInt(data, offset + 24, 1);
            int polyCount = Common.getInt(data, offset + 25, 1);
            int unknown4 = Common.getInt(data, offset + 26, 2);
            int unknown5 = Common.getInt(data, offset + 28, 4);
            int unknown6 = Common.getInt(data, offset + 32, 4);
            int numVertices = Common.getInt(data, 36, 2);
            int numSurfaces = Common.getInt(data, 38, 2);
            int numTriangles = Common.getInt(data, 40, 2);
            int numQuads = Common.getInt(data, 42, 2);
            CModel model = new CModel();
            model.setName(m.getName());
            Common.msg("-> #" + Common.padNum(i, 2) + " | Offset: " + Common.getHex(offset, 4) + " | Name: " + m.getName());
            Common.msg(" -> Bone Offset: " + Common.getHex(boneOffset, 2));
            Common.msg(" -> Material Offset: " + Common.getHex(matOffset, 2));
            Common.msg(" -> Polygon Offset: " + Common.getHex(polyStart, 2) + " | Size: " + Common.getHex(polyEnd - polyStart, 2));
            Common.msg(" -> Unknown: " + unknown + " | " + unknown2 + " | " + unknown3);
            Common.msg(" -> # Objects: " + Common.padNum(objCount, 3) + " | # Materials: " + Common.padNum(matCount, 3) + " | # Polygons: " + Common.padNum(polyCount, 3));
            this.add(model);
        }
    }
}

