/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import util.Common;
import util.struct.DPath;
import util.struct.formats.NitroBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nitro3D {
    public static final String MDL0 = "MDL0";
    public static final String TEX0 = "TEX0";
    private DPath path;
    private String fileMagic;
    private int constant;
    private int fileSize;
    private int headerSize;
    private int sectionCount;
    private ArrayList<NitroBlock> blocks = new ArrayList();

    public Nitro3D(DPath path) {
        String[] types;
        this.path = path;
        byte[] data = path.read();
        this.fileMagic = Common.getString(data, 0, 4);
        this.constant = Common.getInt(data, 4, 4);
        this.fileSize = Common.getInt(data, 8, 4);
        this.headerSize = Common.getInt(data, 12, 2);
        this.sectionCount = Common.getInt(data, 14, 2);
        boolean show = true;
        for (String type : types = new String[0]) {
            if (!type.equals(this.fileMagic)) continue;
            show = false;
        }
        if (show) {
            Common.msg("Magic: " + this.fileMagic + " (" + Common.getHex(this.fileMagic) + ")");
            Common.msg("Constant: " + Common.getHex(this.constant, 4));
            Common.msg("File Size: " + this.fileSize);
            Common.msg("Header Size: " + this.headerSize);
            Common.msg("# Sections: " + this.sectionCount);
            Common.line();
        }
        int jump = this.headerSize;
        String[] magics = new String[]{};
        for (int i = 0; i < this.sectionCount; ++i) {
            int offset = Common.getInt(data, jump + i * 4, 4);
            String magic = Common.getString(data, offset, 4);
            int sectionSize = Common.getInt(data, offset + 4, 4);
            this.blocks.add(new NitroBlock(magic, offset, sectionSize));
            boolean known = false;
            for (String check : magics) {
                if (!check.equals(magic)) continue;
                known = true;
            }
            if (known) continue;
            Common.msg("Magic: " + magic + " (" + Common.getHex(magic) + ") | Offset: " + Common.getHex(offset, 2) + " | Size: " + sectionSize);
            Common.line();
        }
    }

    public ArrayList<NitroBlock> getBlocks() {
        return this.blocks;
    }

    public NitroBlock getBlock(String magic) {
        for (NitroBlock block : this.getBlocks()) {
            if (!block.getMagic().equals(magic)) continue;
            return block;
        }
        return null;
    }

    public int getBlockOffset(String magic) {
        NitroBlock block = this.getBlock(magic);
        if (block != null) {
            return block.getOffset();
        }
        return 0;
    }

    public byte[] getBlockData(String magic) {
        NitroBlock block = this.getBlock(magic);
        if (block != null) {
            return this.path.read(block.getOffset(), block.getSize());
        }
        return null;
    }

    public static ArrayList<ObjectInfo> getInfo(byte[] data, int offset) {
        ArrayList<ObjectInfo> infoList = new ArrayList<ObjectInfo>();
        int dummy = Common.getInt(data, offset, 1);
        int objCount = Common.getInt(data, offset + 1, 1);
        int sectionSize = Common.getInt(data, offset + 2, 2);
        int unkJump = offset + 4;
        int subHeaderSize = Common.getInt(data, unkJump, 2);
        int subSectionSize = Common.getInt(data, unkJump + 2, 2);
        int constant = Common.getInt(data, unkJump + 4, 4);
        int infoJump = offset + subSectionSize;
        int infoDataSize = Common.getInt(data, infoJump, 2);
        int infoSectionSize = Common.getInt(data, infoJump + 2, 2);
        int nameJump = offset + subSectionSize + infoSectionSize;
        for (int i = 0; i < objCount; ++i) {
            int unkOffset = unkJump + 8 + i * 4;
            int unknown = Common.getInt(data, unkOffset, 4);
            byte[] infoData = Common.getBytes(data, infoJump + 4 + i * infoDataSize, infoDataSize);
            String name = Common.getString(data, nameJump + i * 16, 16);
            infoList.add(new ObjectInfo(unknown, infoData, name.trim()));
        }
        return infoList;
    }

    public static class ObjectInfo {
        private int unknown;
        private byte[] data;
        private String name;

        public ObjectInfo(int unknown, byte[] data, String name) {
            this.unknown = unknown;
            this.data = data;
            this.name = name;
        }

        public int getUnknown() {
            return this.unknown;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getName() {
            return this.name;
        }
    }
}

