/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import util.Common;
import util.Compression;
import util.struct.DArchive;
import util.struct.DFile;
import util.struct.DPath;

public class CyberConnect2Batch
extends DArchive {
    public CyberConnect2Batch(DPath path) {
        super(path);
    }

    public void open() {
        byte[] data = this.getPath().read();
        int version = Common.getInt(data, 4, 2);
        int fileCount = Common.getInt(data, 6, 2);
        ArrayList<DFile> folder = new ArrayList<DFile>();
        int offset = 0;
        for (int i = 0; i < fileCount; ++i) {
            int jump = 8 + i * 32;
            String name = Common.getString(data, jump, 24);
            int unknown = Common.getInt(data, jump + 24, 1);
            int dataSize = Common.getInt(data, jump + 25, 3);
            int comp = Common.getInt(data, jump + 28, 1);
            int fullSize = Common.getInt(data, jump + 29, 3);
            Common.msg("-> #" + Common.padNum(i, 2) + " | Unknown: " + unknown + " | Data Size: " + Common.getHex(dataSize, 3) + " | Compression: " + Common.getHex(comp, 1) + " | Unpacked Size: " + Common.getHex(fullSize, 3) + " | Name: " + name);
            DFile file = new DFile(name.trim(), 8 + fileCount * 32 + offset, dataSize);
            file.setCompression(new Compression(comp, fullSize));
            folder.add(file);
            offset += dataSize;
        }
        this.addFolder(0, this.getPath(), folder);
        this.getModel().addRow("Version", Common.getHex(version, 2));
    }
}

