/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import util.Common;
import util.struct.DModel;
import util.struct.DPath;
import util.struct.models.CModel;
import util.struct.models.CModelPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDesk3DS
extends DModel {
    private CModel model = new CModel();
    private CModelPolygon polygon;
    private ArrayList<Common.Vertex> vtxList;

    public AutoDesk3DS(DPath path) {
        super(path);
    }

    @Override
    public void open() {
        byte[] data = this.getPath().read();
        this.readSection(data, 0, data.length, 0);
        this.add(this.model);
    }

    private void readSection(byte[] data, int offset, int size, int indent) {
        int length = offset + size;
        while (offset < length) {
            int magic = Common.getInt(data, offset, 2);
            int sectionSize = Common.getInt(data, offset + 2, 4);
            int jump = 6;
            String id = "";
            String msg = " | Offset: " + Common.getHex(offset, 2) + " | Size: " + sectionSize;
            boolean hasSub = true;
            switch (magic) {
                case 19789: {
                    id = "MAIN3DS";
                    break;
                }
                case 15677: {
                    id = "EDIT3DS";
                    break;
                }
                case 16384: {
                    id = "EDIT_OBJECT";
                    String objName = Common.getString(data, offset + jump, 12);
                    objName = objName.substring(0, objName.indexOf(Common.getString((byte)0)));
                    msg = msg + " | Name: " + objName;
                    jump += objName.length() + 1;
                    this.polygon = new CModelPolygon(0);
                    this.polygon.setName(objName);
                    this.model.add(this.polygon);
                    break;
                }
                case 16640: {
                    id = "OBJ_TRIMESH";
                    break;
                }
                case 16656: {
                    id = "TRI_VERTEXLIST";
                    hasSub = false;
                    int vertexCount = Common.getInt(data, offset + jump, 2);
                    this.vtxList = this.getVertexList(data, offset + jump + 2, vertexCount);
                    msg = msg + " | Count: " + vertexCount;
                    for (Common.Vertex vtx : this.vtxList) {
                    }
                    break;
                }
                case 16657: {
                    id = "TRI_VERTEXOPTIONS";
                    hasSub = false;
                    break;
                }
                case 16672: {
                    id = "TRI_FACEDESC";
                    int faceCount = Common.getInt(data, offset + jump, 2);
                    msg = msg + " | Count: " + faceCount;
                    for (int i = 0; i < faceCount; ++i) {
                        int jump2 = offset + jump + 2 + i * 8;
                        int point0 = Common.getInt(data, jump2, 2);
                        int point1 = Common.getInt(data, jump2 + 2, 2);
                        int point2 = Common.getInt(data, jump2 + 4, 2);
                    }
                    jump += 2 + faceCount * 8;
                    break;
                }
                case 16720: {
                    id = "TRI_SMOOTH";
                    hasSub = false;
                    break;
                }
                case 16704: {
                    id = "TRI_MAPPINGCOORS";
                    hasSub = false;
                    int mapCount = Common.getInt(data, offset + jump, 2);
                    msg = msg + " | Count: " + mapCount;
                    break;
                }
                case 16736: {
                    id = "TRI_LOCAL";
                    hasSub = false;
                    msg = msg + " | Values(12): ";
                    for (int i = 0; i < 12; ++i) {
                        float value4160 = Common.getFloat(data, offset + jump + i * 4, 4);
                        msg = msg + value4160;
                        if (i >= 11) continue;
                        msg = msg + ",";
                    }
                    break;
                }
                case 45056: {
                    id = "KEYF3DS";
                    break;
                }
                default: {
                    hasSub = false;
                }
            }
            if (id.length() > 0) {
                id = id + "-";
            }
            id = id + Common.getHex(magic, 2);
            Common.msg(Common.padLeft("", indent) + "-> " + id + msg);
            if (hasSub) {
                this.readSection(data, offset + jump, sectionSize - jump, indent + 1);
            }
            offset += sectionSize;
        }
    }

    private ArrayList<Common.Vertex> getVertexList(byte[] data, int offset, int count) {
        ArrayList<Common.Vertex> list = new ArrayList<Common.Vertex>();
        for (int i = 0; i < count; ++i) {
            int jump = offset + i * 12;
            float x = Common.getFloat(data, jump, 4);
            float y = Common.getFloat(data, jump + 4, 4);
            float z = Common.getFloat(data, jump + 8, 4);
            list.add(new Common.Vertex(x, y, z));
        }
        return list;
    }
}

