/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.nio.ByteBuffer;
import util.Common;
import util.struct.DPalette;
import util.struct.DPath;
import util.struct.graphics.CPalette;

public class AdobeClut
extends DPalette {
    public AdobeClut(DPath path) {
        super(path);
    }

    public void open() {
        this.add(new CPalette(this.getPath().read(), CPalette.BGR888));
    }

    public void save(DPalette data) {
        Common.msg("Save as Adobe Clut: " + data);
        ByteBuffer buffer = ByteBuffer.allocate(0);
        for (CPalette pal : data.getPalettes()) {
            buffer = ByteBuffer.allocate(buffer.capacity() + pal.getColorCount() * 3);
            for (int color : pal.getColors()) {
                color = CPalette.encodeColor(color, CPalette.BGR888);
                buffer.put(Common.getBytes(color, 3));
            }
        }
        this.getPath().write(buffer.array());
    }
}

