/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import util.Common;
import util.Compression;
import util.FileAccess;
import util.Plugin;
import util.gui.panels.CTableModel;
import util.struct.DFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPath {
    private File source;
    private ArrayList<DFile> path = new ArrayList();
    private Plugin plugin = new Plugin();
    private CTableModel model;
    private boolean checked = false;
    private byte[] cacheData;

    public DPath(String file) {
        this(new File(file));
    }

    public DPath(File file) {
        this.source = file;
        if (this.source.isDirectory()) {
            this.path.add(new DFile(this.source.getName()));
        } else {
            this.path.add(new DFile(this.source.getName(), this.source.length()));
        }
        this.check();
    }

    public DPath(DPath parent, DFile file) {
        Object[] nodes;
        this.source = parent.getSource();
        for (Object node : nodes = parent.getPath().toArray()) {
            this.path.add((DFile)node);
        }
        this.path.add(file);
    }

    public DPath(File source, DFile[] nodes) {
        this.source = source;
        for (DFile node : nodes) {
            this.path.add(node);
        }
    }

    public DPath(DPath parent) {
        this.source = parent.getSource();
        for (DFile file : parent.getPath()) {
            this.path.add(file);
        }
        this.path.add(new DFile(parent.getFile().getName() + " (Internal)", 2));
        this.checkModel();
    }

    public void check() {
        if (this.getFile().isFile()) {
            Plugin.scan(this);
        }
        this.checkModel();
        this.checked = true;
    }

    public boolean isChecked() {
        return this.checked;
    }

    private void checkModel() {
        this.model = new CTableModel("File Information");
        this.model.setEnabled(false);
        this.model.addRow("Filename", this.getFile().getName(), false);
        this.model.addRow("Type", this.getPlugin().getName(), false);
        this.model.addRow("Offset", "0x" + Common.getHex(this.getFile().getOffset(), 2), false);
        this.model.addRow("Size", Common.calSize(this.getFile().getFullSize()), false);
        this.model.addRow("Compression", this.getFile().getCompressionInfo(), false);
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Common.msg("DPath Property -> " + evt.getPropertyName() + ": " + evt.getOldValue() + " > " + evt.getNewValue());
            }
        });
    }

    public CTableModel getModel() {
        return this.model;
    }

    public String toString() {
        return this.getPathName();
    }

    public File getSource() {
        return this.source;
    }

    public ArrayList<DFile> getPath() {
        return this.path;
    }

    public DPath getParent() {
        Object[] nodes;
        if (this.path.size() > 1 && (nodes = this.path.subList(0, this.path.size() - 2).toArray()) instanceof DFile[]) {
            return new DPath(this.source, (DFile[])nodes);
        }
        return null;
    }

    public String getPathName() {
        String name = this.source.getPath();
        for (int i = 1; i < this.path.size(); ++i) {
            name = name + "\\" + this.path.get(i).getFullName();
        }
        return name;
    }

    public String getParentName() {
        DPath parent = this.getParent();
        if (parent != null) {
            return parent.getPathName();
        }
        return this.source.getParent();
    }

    public DFile getFile() {
        return this.path.get(this.path.size() - 1);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public byte[] read() {
        return this.read(true);
    }

    public byte[] read(boolean decomp) {
        if (decomp) {
            return this.read(0L, this.getFile().getFullSize(), decomp);
        }
        return this.read(0L, this.getFile().getSize(), decomp);
    }

    public byte[] read(long offset, long size) {
        return this.read(offset, size, true);
    }

    public byte[] read(long offset, long size, boolean decomp) {
        byte[] data = null;
        int jump = 0;
        long fullSize = 0L;
        if (this.cacheData == null) {
            for (int pos = 0; pos < this.path.size(); ++pos) {
                boolean targetComp;
                DFile node = this.path.get(pos);
                if (!node.isFile()) continue;
                jump = (int)((long)jump + node.getOffset());
                fullSize = node.getSize();
                boolean parentComp = node.isCompressed() && pos < this.path.size() - 1;
                boolean bl = targetComp = node.isCompressed() && pos == this.path.size() - 1 && decomp;
                if (!parentComp && !targetComp) continue;
                data = data == null ? Compression.extract(node.getCompression(), FileAccess.read(this.source, jump, fullSize)) : Compression.extract(node.getCompression(), Common.getBytes(data, jump, (int)fullSize));
                fullSize = node.getFullSize();
                jump = 0;
            }
        }
        if (offset + size > fullSize && fullSize > 0L || size == 0L && fullSize > 0L) {
            size = fullSize - offset;
        }
        if (data != null) {
            this.cacheData = Common.getBytes(data, jump, (int)fullSize);
            data = Common.getBytes(data, (int)((long)jump + offset), (int)size);
        } else {
            data = this.cacheData != null ? Common.getBytes(this.cacheData, (int)offset, (int)size) : FileAccess.read(this.source, (long)jump + offset, size);
        }
        return data;
    }

    public void write(byte[] data) {
        FileAccess.write(this.source, data);
    }

    public void empty() {
        Common.error("Empty not Supported");
    }

    public void decomp() {
        if (this.getFile().isCompressed()) {
            byte[] data = this.read();
            String exportPath = this.getSource().getParent() + "\\" + this.getFile().getName() + "_extract";
            String ext = this.getFile().getExtension();
            if (ext.length() > 0) {
                String string = exportPath + "." + ext;
            }
        }
    }
}

