/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import util.Common;
import util.Compression;

public class DFile {
    public static final int FOLDER = 0;
    public static final int FILE = 1;
    public static final int INTERNAL = 2;
    public static final int ENDIAN_LITTE = 0;
    public static final int ENDIAN_BIG = 1;
    private String name;
    private String ext;
    private long offset;
    private long size;
    private int type;
    private int endian;
    private int ref;
    private Compression comp = new Compression();

    public DFile(String name, long offset, long size) {
        this.setName(name);
        this.type = 1;
        this.offset = offset;
        this.size = size;
    }

    public DFile(String name, long size) {
        this(name, 0L, size);
    }

    public DFile(String name) {
        this.setName(name);
    }

    public DFile(String name, int type) {
        this.setName(name);
        this.type = type;
    }

    public String toString() {
        if (this.type == 0) {
            return "Folder: " + this.getFullName() + " | Type: " + this.getTypeName();
        }
        return "File: " + this.getFullName() + " | Type: " + this.getTypeName() + " | Size: " + Common.calSize(this.getSize());
    }

    public void setName(String name) {
        this.name = name;
        this.ext = "";
        if (name.contains(".")) {
            this.name = name.substring(0, name.lastIndexOf("."));
            this.ext = name.substring(name.lastIndexOf(".") + 1);
        }
    }

    public void setExtension(String ext) {
        this.ext = ext;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setByteOrder(int endian) {
        this.endian = endian;
    }

    public void setReference(int ref) {
        this.ref = ref;
    }

    public void setCompression(Compression comp) {
        this.comp = comp;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String fname = this.name;
        if (this.ext.length() > 0) {
            fname = fname + "." + this.ext;
        }
        return fname;
    }

    public String getExtension() {
        return this.ext;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        switch (this.type) {
            case 0: {
                return "Folder";
            }
        }
        return "File";
    }

    public int getByteOrder() {
        return this.endian;
    }

    public int getReference() {
        return this.ref;
    }

    public Compression getCompression() {
        return this.comp;
    }

    public long getFullSize() {
        if (this.comp.isCompressed()) {
            return this.comp.getSize();
        }
        return this.size;
    }

    public String getCompressionInfo() {
        return this.comp.getName();
    }

    public boolean isFile() {
        return this.type != 0;
    }

    public boolean isInternal() {
        return this.type == 2;
    }

    public boolean isFolder() {
        return this.type == 0;
    }

    public boolean isCompressed() {
        return this.comp.isCompressed();
    }
}

