/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.media.opengl.GLJPanel;
import util.Common;
import util.gui.frames.FModelListener;

public class FModelRender
extends GLJPanel {
    private Point start;
    public static final int VIEW_NONE = 0;
    public static final int VIEW_TOP = 1;
    public static final int VIEW_BOTTOM = 2;
    public static final int VIEW_FRONT = 3;
    public static final int VIEW_BACK = 4;
    public static final int VIEW_LEFT = 5;
    public static final int VIEW_RIGHT = 6;
    private final int NONE = 0;
    private final int ROTATE = 1;
    private final int SCALE = 2;
    private final int MOVE = 3;
    private int mode;
    private int viewMode;
    private FModelListener listener;

    public FModelRender() {
        this(0);
    }

    public FModelRender(int viewMode) {
        this.viewMode = viewMode;
        this.setBackground(new Color(60, 60, 60));
        this.listeners();
    }

    private void listeners() {
        this.listener = new FModelListener(this);
        this.addGLEventListener(this.listener);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                Point pos = evt.getPoint();
                Point dist = new Point(pos.x - ((FModelRender)FModelRender.this).start.x, pos.y - ((FModelRender)FModelRender.this).start.y);
                switch (FModelRender.this.mode) {
                    case 1: {
                        FModelRender.this.listener.setRotate(dist.x, dist.y);
                        break;
                    }
                    case 2: {
                        FModelRender.this.listener.setScale(dist.x);
                        break;
                    }
                    case 3: {
                        FModelRender.this.listener.setMove(dist.x, dist.y);
                    }
                }
                FModelRender.this.start = pos;
                FModelRender.this.display();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                int button = evt.getButton();
                if (FModelRender.this.mode == 0) {
                    FModelRender.this.start = evt.getPoint();
                    switch (button) {
                        case 1: {
                            if (FModelRender.this.viewMode != 0) break;
                            FModelRender.this.mode = 1;
                            break;
                        }
                        case 2: {
                            FModelRender.this.mode = 2;
                            break;
                        }
                        case 3: {
                            FModelRender.this.mode = 3;
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent evt) {
                boolean SMOVE;
                int button = evt.getButton();
                boolean SROTATE = FModelRender.this.mode == 1 && button == 1;
                boolean SSCALE = FModelRender.this.mode == 2 && button == 2;
                boolean bl = SMOVE = FModelRender.this.mode == 3 && button == 3;
                if (SROTATE || SSCALE || SMOVE) {
                    FModelRender.this.mode = 0;
                }
            }
        });
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        String text = this.getView();
        g.setColor(new Color(240, 240, 240));
        g.setFont(new Font("Tahoma", 1, 11));
        g.drawString(text, (this.getWidth() - this.getStringWidth(g, text)) / 2, this.getHeight() - 10);
        Common.Vertex trans = this.listener.getTranslation();
        Common.Vertex rotate = this.listener.getRotation();
        ArrayList<String[]> display = new ArrayList<String[]>();
        display.add(new String[]{"Translation X:", "" + trans.x});
        display.add(new String[]{"Translation Y:", "" + trans.y});
        display.add(new String[]{"Translation Z:", "" + trans.z});
        display.add(new String[]{"Rotation X:", "" + rotate.x});
        display.add(new String[]{"Rotation Y:", "" + rotate.y});
        display.add(new String[]{"Rotation Z:", "" + rotate.z});
        int i = 0;
        while (i < display.size()) {
            String[] info = (String[])display.get(display.size() - i - 1);
            int index = i++;
            int str0 = this.getStringWidth(g, info[0]);
            int str1 = this.getStringWidth(g, info[1]);
            int stry = this.getHeight() - 10 - index * 20;
            g.drawString(info[0], this.getWidth() - str0 - 50, stry);
            g.drawString(info[1], this.getWidth() - str1 - 5, stry);
        }
    }

    private int getStringWidth(Graphics g, String text) {
        return g.getFontMetrics().stringWidth(text);
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public String getView() {
        switch (this.viewMode) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "front";
            }
            case 4: {
                return "back";
            }
            case 5: {
                return "left";
            }
            case 6: {
                return "right";
            }
        }
        return "persp";
    }
}

