/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import com.sun.opengl.util.GLUT;
import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import util.Common;
import util.gui.frames.FModelRender;

public class FModelListener
implements GLEventListener {
    private GL gl;
    private float baseScale;
    private Common.Vertex translate;
    private Common.Vertex rotate;
    private Color bg;
    private float[] baseColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private float[] shadeColor = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
    private float[] selColor = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    private float[] lineColorOff = new float[]{0.0f, 0.02745098f, 0.5686275f, 1.0f};
    private float[] lineColorOn = new float[]{0.2627451f, 1.0f, 0.6392157f, 1.0f};
    private float[] lineColorEdit = new float[]{0.39215687f, 0.8627451f, 1.0f, 1.0f};
    private float[] pointColorOff = new float[]{0.39215687f, 0.19607843f, 0.43137255f, 1.0f};
    private float[] pointColorOn = new float[]{0.78431374f, 0.0f, 0.78431374f, 1.0f};
    private float[] pointColorEdit = new float[]{0.78431374f, 0.0f, 0.78431374f, 1.0f};
    private float[] jointColor = new float[]{0.0f, 0.4f, 0.0f, 1.0f};
    private float[] jointColorOn = new float[]{0.4f, 0.0f, 0.0f, 1.0f};
    private float[] linkColor = new float[]{0.0f, 0.0f, 0.8f, 0.8f};
    private float[] linkColorOn = new float[]{0.8f, 0.0f, 0.0f, 0.8f};
    private float[] curColor;
    public float lx = 60.0f;
    public float ly = 50.0f;
    public float lz = 95.0f;
    public float lw = 1.0f;
    private final float[][] axisColor = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};

    public FModelListener(FModelRender panel) {
        this.bg = panel.getBackground();
        this.translate = new Common.Vertex();
        this.translate.z = -40.0f;
        this.rotate = new Common.Vertex();
        this.baseScale = 25.0f;
        switch (panel.getViewMode()) {
            case 1: {
                this.rotate.y = 90.0f;
                break;
            }
            case 2: {
                this.rotate.y = -90.0f;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.rotate.x = 180.0f;
                break;
            }
            case 5: {
                this.rotate.x = 90.0f;
                break;
            }
            case 6: {
                this.rotate.x = -90.0f;
                break;
            }
            default: {
                this.rotate.x = -25.0f;
                this.rotate.y = 20.0f;
            }
        }
    }

    public void init(GLAutoDrawable drawable) {
        this.gl = drawable.getGL();
        this.refresh();
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.gl = drawable.getGL();
        GLU glu = new GLU();
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        this.gl.glViewport(x, y, width, height);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        glu.gluPerspective(40.0, h, 0.02f, 2048.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
    }

    public void display(GLAutoDrawable drawable) {
        this.gl = drawable.getGL();
        this.gl.glClear(16640);
        this.redraw(drawable);
        this.gl.glFlush();
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void refresh() {
        this.gl.setSwapInterval(1);
        this.gl.glClearColor((float)this.bg.getRed() / 255.0f, (float)this.bg.getGreen() / 255.0f, (float)this.bg.getBlue() / 255.0f, 0.0f);
        this.gl.glShadeModel(7425);
        this.gl.glBlendFunc(770, 771);
        this.gl.glAlphaFunc(516, 0.0f);
        this.gl.glEnable(2929);
        this.gl.glEnable(3042);
        this.gl.glEnable(3008);
        this.gl.glBindTexture(3553, 0);
        this.gl.glMatrixMode(5888);
        this.gl.glPointSize(4.0f);
    }

    public Common.Vertex getTranslation() {
        return this.translate;
    }

    public Common.Vertex getRotation() {
        return this.rotate;
    }

    private void setPersp() {
        this.gl.glLoadIdentity();
        this.setTranslation();
        this.setRotation();
    }

    private void setTranslation() {
        this.gl.glTranslatef(this.translate.x, this.translate.y, this.translate.z);
        this.gl.glScalef(this.baseScale / 100.0f, this.baseScale / 100.0f, this.baseScale / 100.0f);
    }

    private void setRotation() {
        this.gl.glRotatef(this.rotate.x, 0.0f, 1.0f, 0.0f);
        this.gl.glRotatef(this.rotate.y, 1.0f, 0.0f, 0.0f);
    }

    public void setRotate(int x, int y) {
        this.rotate.x += (float)x;
        this.rotate.y += (float)y;
        if (this.rotate.y > 360.0f) {
            this.rotate.y = 0.0f;
        }
        if (this.rotate.y < -360.0f) {
            this.rotate.y = 0.0f;
        }
    }

    public void setMove(int x, int y) {
        float divide = 60.0f / (this.baseScale / 30.0f);
        this.translate.x = (float)Math.round((this.translate.x + (float)x / divide) * 100.0f) / 100.0f;
        this.translate.y = (float)Math.round((this.translate.y - (float)y / divide) * 100.0f) / 100.0f;
    }

    public void setScale(int scale) {
        float divide = 10.0f / (this.baseScale / 20.0f);
        this.baseScale += (float)scale / divide;
    }

    private void setColor(int drawMode, float[] color) {
    }

    public void redraw(GLAutoDrawable drawable) {
        this.refresh();
        this.setPersp();
        this.drawGrid(10.0f, 50.0f);
        this.drawAxisDisplay(drawable);
    }

    public void setLights(boolean enable) {
        if (enable) {
            this.gl.glEnable(2896);
        } else {
            this.gl.glDisable(2896);
        }
    }

    public void drawLight() {
        this.setPersp();
        this.gl.glTranslatef(this.lx, this.ly, this.lz);
        this.gl.glEnable(16384);
        this.gl.glLightfv(16384, 4611, new float[]{this.lx, this.ly, this.lz, this.lw}, 0);
        this.gl.glLightfv(16384, 4608, new float[]{0.0f, 0.0f, 0.0f, 0.8f}, 0);
        this.gl.glLightfv(16384, 4609, new float[]{1.0f, 1.0f, 1.0f, 0.0f}, 0);
        this.gl.glLightfv(16384, 4610, new float[]{1.0f, 1.0f, 1.0f, 0.0f}, 0);
    }

    private void drawGrid(float grid, float size) {
        int[][] axis = new int[][]{{0, 1, 0}, {1, 2, 0}, {0, 2, 1}};
        for (int i = 0; i < axis.length; ++i) {
            if (axis[i][2] != 1) continue;
            for (int j = 0; j < 2; ++j) {
                int hor = axis[i][0];
                int ver = axis[i][1];
                if (j == 1) {
                    hor = axis[i][1];
                    ver = axis[i][0];
                }
                float lines = size * 2.0f / grid + 1.0f;
                int k = 0;
                while ((float)k < lines) {
                    float[] vertex = new float[]{0.0f, 0.0f, 0.0f};
                    vertex[hor] = size;
                    vertex[ver] = (float)k * grid - size;
                    this.gl.glColor4f(1.0f, 1.0f, 1.0f, 0.2f);
                    this.gl.glLineWidth(1.0f);
                    if ((float)(k + 1) == (lines + 1.0f) / 2.0f) {
                        this.gl.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
                        this.gl.glLineWidth(2.5f);
                    }
                    this.gl.glBegin(1);
                    this.gl.glVertex3f(vertex[0], vertex[1], vertex[2]);
                    vertex[hor] = -size;
                    this.gl.glVertex3f(vertex[0], vertex[1], vertex[2]);
                    this.gl.glEnd();
                    ++k;
                }
            }
        }
    }

    private void drawAxisDisplay(GLAutoDrawable drawable) {
        this.reshape(drawable, 0, -5, 80, 80);
        this.gl.glDisable(2929);
        this.gl.glLoadIdentity();
        float dia = 12.0f;
        this.gl.glLoadIdentity();
        this.gl.glTranslatef(0.0f, 0.0f, -40.0f);
        this.setRotation();
        this.gl.glLineWidth(1.0f);
        this.drawAxis(10.0f);
        this.drawAxisId(10.0f);
        this.reshape(drawable, 0, 0, drawable.getWidth(), drawable.getHeight());
    }

    private void drawAxis(float radius) {
        for (int i = 0; i < 3; ++i) {
            float[] start = new float[]{0.0f, 0.0f, 0.0f};
            float[] end = new float[]{0.0f, 0.0f, 0.0f};
            start[i] = 0.0f;
            end[i] = radius;
            this.gl.glColor3f(this.axisColor[i][0], this.axisColor[i][1], this.axisColor[i][2]);
            this.gl.glBegin(1);
            this.gl.glVertex3f(start[0], start[1], start[2]);
            this.gl.glVertex3f(end[0], end[1], end[2]);
            this.gl.glEnd();
        }
    }

    private void drawAxisId(float radius) {
        float cent = 0.8f;
        float ypos = 1.5f;
        float[][] text = new float[][]{{radius, ypos, cent}, {-cent, radius + ypos, cent}, {-cent, ypos, radius + cent}};
        char[] id = new char[]{'X', 'Y', 'Z'};
        GLUT glut = new GLUT();
        for (int i = 0; i < 3; ++i) {
            this.gl.glColor3f(this.axisColor[i][0], this.axisColor[i][1], this.axisColor[i][2]);
            this.gl.glRasterPos3f(text[i][0], text[i][1], text[i][2]);
            glut.glutBitmapCharacter(6, id[i]);
        }
    }

    private void drawJoint(float radius) {
        this.setColor(3, null);
        this.gl.glLineWidth(1.5f);
        this.drawCircle(radius, 0);
        this.drawCircle(radius, 1);
        this.drawCircle(radius, 2);
        this.gl.glLineWidth(1.5f);
        this.drawAxis(radius);
    }

    private void drawCircle(float radius, int axis) {
        this.gl.glBegin(2);
        float DEG2RAD = 0.01745328f;
        block5: for (int i = 0; i < 360; ++i) {
            float degInRad = (float)i * DEG2RAD;
            float u = (float)Math.cos(degInRad) * radius;
            float v = (float)Math.sin(degInRad) * radius;
            switch (axis) {
                case 0: {
                    this.gl.glVertex3f(u, v, 0.0f);
                    continue block5;
                }
                case 1: {
                    this.gl.glVertex3f(0.0f, u, v);
                    continue block5;
                }
                case 2: {
                    this.gl.glVertex3f(u, 0.0f, v);
                }
            }
        }
        this.gl.glEnd();
    }
}

