/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import util.Common;
import util.gui.CPopupMenu;

public class FImageRender
extends JScrollPane {
    private FLayout layoutPane = new FLayout();
    private FRender renderPane = new FRender();
    private BufferedImage image;
    private static final Color COLOR_BG = new Color(255, 255, 255);
    private static final Color COLOR_GRID = new Color(204, 204, 204);
    private static final int TILE_WIDTH = 8;
    private static final int TILE_HEIGHT = 8;

    public FImageRender() {
        this.setViewportView(this.layoutPane);
        this.layoutPane.add(this.renderPane);
        CPopupMenu popup = new CPopupMenu(this.renderPane);
        popup.add(50);
        this.renderPane.add(popup);
        JScrollBar hscroll = this.getHorizontalScrollBar();
        JScrollBar vscroll = this.getVerticalScrollBar();
        hscroll.setUnitIncrement(5);
        hscroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
            }
        });
        vscroll.setUnitIncrement(5);
        vscroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
            }
        });
        this.setBorder(null);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
    }

    public void setImageSize(Dimension imageSize) {
        this.renderPane.setPreferredSize(imageSize);
    }

    public void setImageSize(int width, int height) {
        this.setImageSize(new Dimension(width, height));
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.setImageSize(image.getWidth(), image.getHeight());
        this.renderPane.revalidate();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public static BufferedImage drawGrid(int tw, int th, int width, int height) {
        BufferedImage grid = new BufferedImage(width, height, 2);
        Graphics g = grid.getGraphics();
        g.setColor(COLOR_BG);
        g.fillRect(0, 0, width, height);
        g.setColor(COLOR_GRID);
        int cols = (int)Math.ceil((double)width / (double)tw);
        int rows = (int)Math.ceil((double)height / (double)th);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                boolean odd;
                boolean even = x % 2 == 1 && y % 2 == 0;
                boolean bl = odd = x % 2 == 0 && y % 2 == 1;
                if (!even && !odd) continue;
                g.fillRect(x * tw, y * th, tw, th);
            }
        }
        return grid;
    }

    private class FRender
    extends JPanel {
        private BufferedImage tileImage;

        public FRender() {
            this.setPreferredSize(new Dimension(64, 64));
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.setBackground(Color.WHITE);
        }

        public void paintComponent(Graphics g) {
            g.drawImage(this.tileImage, 0, 0, this);
            g.drawImage(FImageRender.this.image, 0, 0, this);
        }

        public void setPreferredSize(Dimension size) {
            super.setPreferredSize(size);
            this.updateGrid();
        }

        private void updateGrid() {
            Dimension size = this.getPreferredSize();
            this.tileImage = new BufferedImage(size.width, size.height, 2);
            Graphics g2 = this.tileImage.getGraphics();
            g2.drawImage(FImageRender.drawGrid(8, 8, size.width, size.height), 0, 0, this);
            this.revalidate();
        }
    }

    private class FLayout
    extends JPanel {
        private final int SIZE = 20;

        public FLayout() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.setBackground(new Color(192, 192, 192));
        }

        public void doLayout() {
            if (this.getComponentCount() > 0) {
                int pad;
                Dimension size = this.getComponent(0).getPreferredSize();
                int left = 20;
                int right = 20;
                int top = 20;
                int bottom = 20;
                Dimension scroll = this.getParent().getSize();
                int scrollWidth = scroll.width - 40;
                int scrollHeight = scroll.height - 40;
                if (size.width < scrollWidth) {
                    pad = (scrollWidth - size.width) / 2;
                    left += pad;
                    right += pad + (scrollWidth - size.width - pad * 2);
                } else {
                    size.width += 40;
                }
                if (size.height < scrollHeight) {
                    pad = (scrollHeight - size.height) / 2;
                    top += pad;
                    bottom += pad + (scrollHeight - size.height - pad * 2);
                } else {
                    size.height += 40;
                }
                this.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
                this.setPreferredSize(new Dimension(size.width, size.height));
                this.setMinimumSize(this.getPreferredSize());
            }
            super.doLayout();
            if (FImageRender.this.renderPane.getWidth() != ((FImageRender)FImageRender.this).renderPane.getPreferredSize().width || FImageRender.this.renderPane.getHeight() != ((FImageRender)FImageRender.this).renderPane.getPreferredSize().height) {
                Common.error("Render Panel wrong size!! " + FImageRender.this.renderPane.getSize() + " > " + FImageRender.this.renderPane.getPreferredSize());
            }
        }
    }
}

