/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import util.CIcon;
import util.struct.graphics.CCellBuffer;

public class FGridRender
extends JScrollPane {
    private FRule hrule = new FRule(0);
    private FRule vrule = new FRule(1);
    private FCorner corner = new FCorner();
    private FDisplay displayPanel;

    public FGridRender() {
        this.setColumnHeader(this.hrule);
        this.setRowHeader(this.vrule);
        this.setCorner("UPPER_LEFT_CORNER", this.corner);
        JScrollBar hscroll = this.getHorizontalScrollBar();
        JScrollBar vscroll = this.getVerticalScrollBar();
        hscroll.setUnitIncrement(5);
        hscroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                FGridRender.this.hrule.repaint();
            }
        });
        vscroll.setUnitIncrement(5);
        vscroll.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                FGridRender.this.vrule.repaint();
            }
        });
        this.setBorder(null);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
        this.displayPanel = new FDisplay();
        this.setViewportView(this.displayPanel);
    }

    public void centerDisplay() {
        JScrollBar hscroll = this.getHorizontalScrollBar();
        JScrollBar vscroll = this.getVerticalScrollBar();
        if (vscroll.getValue() == 0) {
            hscroll.setValue((hscroll.getMaximum() - hscroll.getVisibleAmount()) / 2);
            vscroll.setValue((vscroll.getMaximum() - vscroll.getVisibleAmount()) / 2);
        }
    }

    public void doLayout() {
        super.doLayout();
        JViewport col = this.getColumnHeader();
        JViewport row = this.getRowHeader();
        JScrollBar vscroll = this.getVerticalScrollBar();
        JScrollBar hscroll = this.getHorizontalScrollBar();
        vscroll.setBounds(vscroll.getX(), 0, vscroll.getWidth(), vscroll.getHeight() + col.getHeight());
        hscroll.setBounds(0, hscroll.getY(), hscroll.getWidth() + row.getWidth(), hscroll.getHeight());
        this.setComponentZOrder(this.corner, 0);
    }

    private Point getZeroPoint() {
        Point zero = new Point(this.displayPanel.getWidth() / 2, this.displayPanel.getHeight() / 2);
        return zero;
    }

    public void update(CCellBuffer buffer, boolean gridEnabled, boolean renderEnabled, boolean outlineEnabled) {
        this.displayPanel.update(buffer, gridEnabled, renderEnabled, outlineEnabled);
    }

    private class FRule
    extends JViewport {
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
        private int orientation;

        public FRule(int orientation) {
            this.orientation = orientation;
            this.setSize(20, 20);
            this.setPreferredSize(this.getSize());
            this.setMinimumSize(this.getSize());
        }

        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Font font = new Font("Tahoma", 0, 10);
            Color fontColor = new Color(35, 35, 35);
            Color color = new Color(100, 100, 100);
            int hscroll = FGridRender.this.getHorizontalScrollBar().getValue();
            int vscroll = FGridRender.this.getVerticalScrollBar().getValue();
            Point center = new Point(((FGridRender)FGridRender.this).getZeroPoint().x - hscroll, ((FGridRender)FGridRender.this).getZeroPoint().y - vscroll);
            int size = 64;
            g.setColor(color);
            g.setFont(font);
            Graphics2D g2 = (Graphics2D)g;
            if (this.orientation == 0) {
                g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
                int minCount = (int)Math.ceil((double)center.x / (double)size);
                int maxCount = (int)Math.ceil((double)(this.getWidth() - center.x) / (double)size);
                for (int i = -minCount; i < maxCount; ++i) {
                    int x = center.x + i * size;
                    g.setColor(color);
                    g.drawLine(x, 0, x, this.getHeight());
                    for (int j = 0; j < size / 8; ++j) {
                        g.drawLine(x + j * 8, 13, x + j * 8, 18);
                    }
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setColor(fontColor);
                    g2.drawString("" + i * size, x + 6, 10);
                }
            } else {
                g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
                int minCount = (int)Math.ceil((double)center.y / (double)size);
                int maxCount = (int)Math.ceil((double)(this.getHeight() - center.y) / (double)size);
                for (int i = -minCount; i < maxCount; ++i) {
                    int y = center.y + i * size;
                    g.setColor(color);
                    g.drawLine(0, y, this.getWidth(), y);
                    for (int j = 0; j < size / 8; ++j) {
                        g.drawLine(13, y + j * 8, 18, y + j * 8);
                    }
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.rotate(-1.5707963267948966);
                    g2.setColor(fontColor);
                    g2.drawString("" + i * size, -y + 6, 10);
                    g2.rotate(1.5707963267948966);
                }
            }
        }
    }

    private class FCorner
    extends JPanel {
        public FCorner() {
            this.setPreferredSize(new Dimension(20, 20));
        }

        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(new Color(100, 100, 100));
            g.drawRect(-1, -1, this.getWidth(), this.getHeight());
            g.drawImage(CIcon.RULER.getImage(), 2, 2, this);
        }
    }

    private class FDisplay
    extends JPanel {
        private CCellBuffer buffer;
        private boolean gridEnabled = true;
        private boolean renderEnabled = true;
        private boolean outlineEnabled = true;

        public FDisplay() {
            this.setPreferredSize(new Dimension(500, 500));
        }

        public void update(CCellBuffer buffer, boolean gridEnabled, boolean renderEnabled, boolean outlineEnabled) {
            this.buffer = buffer;
            this.gridEnabled = gridEnabled;
            this.renderEnabled = renderEnabled;
            this.outlineEnabled = outlineEnabled;
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Point zero = FGridRender.this.getZeroPoint();
            if (this.gridEnabled) {
                this.drawGrid(g);
            }
            this.drawCenterPointer(g);
            if (this.buffer != null) {
                if (this.renderEnabled) {
                    g.drawImage(this.buffer.getImage(), zero.x + this.buffer.getX(), zero.y + this.buffer.getY(), this);
                }
                if (this.outlineEnabled) {
                    g.drawImage(this.buffer.getOutline(), zero.x + this.buffer.getX(), zero.y + this.buffer.getY(), this);
                }
            }
        }

        private void drawCenterPointer(Graphics g) {
            Point zero = FGridRender.this.getZeroPoint();
            g.setColor(new Color(255, 0, 0, 150));
            g.drawLine(zero.x, 0, zero.x, this.getHeight());
            g.drawLine(0, zero.y, this.getWidth(), zero.y);
        }

        private void drawGrid(Graphics g) {
            int j;
            int i;
            Color color = new Color(100, 100, 100, 128);
            Color color2 = new Color(200, 200, 200, 128);
            Point center = FGridRender.this.getZeroPoint();
            int size = 64;
            int minCount = (int)Math.ceil((double)center.x / (double)size);
            int maxCount = (int)Math.ceil((double)(this.getWidth() - center.x) / (double)size);
            for (i = -minCount; i < maxCount; ++i) {
                int x = center.x + i * size;
                g.setColor(color);
                g.drawLine(x, 0, x, this.getHeight());
                g.setColor(color2);
                for (j = 0; j < size / 8; ++j) {
                    g.drawLine(x + j * 8, 0, x + j * 8, this.getHeight());
                }
            }
            minCount = (int)Math.ceil((double)center.y / (double)size);
            maxCount = (int)Math.ceil((double)(this.getHeight() - center.y) / (double)size);
            for (i = -minCount; i < maxCount; ++i) {
                int y = center.y + i * size;
                g.setColor(color);
                g.drawLine(0, y, this.getWidth(), y);
                g.setColor(color2);
                for (j = 0; j < size / 8; ++j) {
                    g.drawLine(0, y + j * 8, this.getWidth(), y + j * 8);
                }
            }
        }
    }
}

