/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class FFrameRender {
    private int index;
    private int time;
    private BufferedImage bufferedImage = new BufferedImage(52, 52, 2);

    public FFrameRender(int index, int time, BufferedImage image) {
        this.index = index;
        this.time = time;
        this.setImage(image);
    }

    public void setImage(BufferedImage image) {
        this.bufferedImage = new BufferedImage(52, 52, 2);
        Graphics2D g = (Graphics2D)this.bufferedImage.getGraphics();
        double xscale = (double)this.bufferedImage.getWidth() / (double)image.getWidth();
        double yscale = (double)this.bufferedImage.getHeight() / (double)image.getHeight();
        double scale = xscale;
        if (yscale < xscale) {
            scale = yscale;
        }
        int scaleWidth = (int)Math.floor((double)image.getWidth() * scale);
        int scaleHeight = (int)Math.floor((double)image.getHeight() * scale);
        Image scaledImage = image.getScaledInstance(scaleWidth, scaleHeight, 16);
        int x = (this.bufferedImage.getWidth() - scaledImage.getWidth(null)) / 2;
        int y = (this.bufferedImage.getHeight() - scaledImage.getHeight(null)) / 2;
        g.drawImage(scaledImage, x, y, null);
    }

    public int getIndex() {
        return this.index;
    }

    public int getTime() {
        return this.time;
    }

    public BufferedImage getImage() {
        return this.bufferedImage;
    }
}

