/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import ctool.Loader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import util.CAction;
import util.CProperty;
import util.Common;
import util.FileAccess;
import util.TFileFilter;
import util.gui.CDesktop;
import util.gui.CFileChooser;
import util.gui.frames.CFrame;
import util.gui.panels.CComboBoxModel;
import util.struct.DFormat;
import util.struct.DPalette;
import util.struct.DPath;
import util.struct.graphics.CPalette;

public class CPaletteFrame
extends CFrame {
    private JScrollPane scrollPane;
    private FDisplay displayPanel;
    private int selColor;

    public CPaletteFrame(DFormat format) {
        super(format);
        this.setPalette(this.getFormat());
        this.scrollPane = new JScrollPane();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(2);
        this.displayPanel = new FDisplay();
        this.scrollPane.setBorder(null);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportView(this.displayPanel);
        this.add(this.scrollPane);
        this.getToolBar().addComboBox(CProperty.SELECTED_PALETTE_INDEX, "Bank:", "Palette Bank");
        this.getToolBar().addComboBox(CProperty.PALETTE_COLOR_INDEX, "Color:", "Selected Color");
        this.getToolBar().addButton(102);
        this.getToolBar().addButton(103);
        this.getToolBar().addButton(104);
        this.getToolBar().addButton(106);
        this.getToolBar().addButton(107);
        this.getToolBar().addButton(105);
    }

    public DPalette getFormat() {
        return (DPalette)super.getFormat();
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        ignored = true;
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        CPalette selPalette = this.getPaletteBank();
        if (name.equals(CProperty.PALETTE_COLOR_INDEX.getName())) {
            this.selColor = (Integer)((CComboBoxModel)value).getSelectedItem();
            CProperty.COLOR_FOREGROUND.setValue(Color.decode("" + selPalette.getColor(this.selColor)));
        } else if (name.equals(CProperty.COLOR_FOREGROUND.getName())) {
            Color color = (Color)value;
            int encode = CPalette.encodeColor(color.getRGB(), selPalette.getColorFormat());
            int decode = CPalette.decodeColor(encode, selPalette.getColorFormat());
            selPalette.setColor(this.selColor, decode);
            CProperty.COLOR_FOREGROUND.setValue(Color.decode("" + selPalette.getColor(this.selColor)));
        } else {
            ignored = false;
        }
        super.checkProperty(evt, ignored);
    }

    public void setProperties() {
        super.setProperties();
        CAction.getAction(23).setEnabled(true);
        if (this.getPaletteBank() != null) {
            CDesktop.PANEL_INFO.addModel(this.getPaletteBank().getModel());
        }
        this.setSelectedColor(this.selColor);
    }

    private void setSelectedColor(int selColor) {
        CPalette selPalette = this.getPaletteBank();
        if (selPalette != null) {
            CComboBoxModel model;
            boolean accept;
            if (selColor >= selPalette.getColorCount()) {
                selColor = selPalette.getColorCount() - 1;
            }
            boolean bl = accept = (model = (CComboBoxModel)CProperty.PALETTE_COLOR_INDEX.getValue()).getSelectedItem() == null;
            if (!accept) {
                accept = ((Integer)model.getSelectedItem()).intValue() != selPalette.getColor(selColor);
            }
            this.selColor = selColor;
            Object[] colorModel = new Integer[selPalette.getColorCount()];
            for (int i = 0; i < colorModel.length; ++i) {
                colorModel[i] = i;
            }
            CProperty.PALETTE_COLOR_INDEX.setValue(new CComboBoxModel(colorModel, selColor));
            if (accept) {
                CProperty.COLOR_FOREGROUND.setValue(Color.decode("" + selPalette.getColor(selColor)));
            }
        }
    }

    public void update() {
        CPalette selPalette = this.getPaletteBank();
        if (selPalette != null) {
            this.displayPanel.checkButtons();
            int[] colors = selPalette.getColors();
            for (int i = 0; i < colors.length; ++i) {
                int color = colors[i];
                FColorButton button = this.displayPanel.getButton(i);
                button.setBackground(new Color(color));
            }
            this.revalidate();
            this.displayPanel.revalidate();
            this.displayPanel.doLayout();
            CAction.getAction(103).setEnabled(colors.length > 1);
            CAction.getAction(104).setEnabled(this.selColor > 0);
            CAction.getAction(106).setEnabled(this.selColor > 0);
            CAction.getAction(107).setEnabled(this.selColor < selPalette.getColorCount() - 1);
            CAction.getAction(105).setEnabled(this.selColor < selPalette.getColorCount() - 1);
        }
    }

    public boolean doAction(int action) {
        CPalette selPalette = this.getPaletteBank();
        boolean accept = true;
        switch (action) {
            case 23: {
                CFileChooser dialog = new CFileChooser(1, this.getFormat());
                if (!dialog.showChooser()) break;
                Common.msg("Export As: " + dialog.getSelectedFile());
                DPath path = new DPath(dialog.getSelectedFile());
                DPalette palette = (DPalette)Loader.getFormat(path, ((TFileFilter)dialog.getFileFilter()).getPlugins().get(0));
                palette.save(this.getFormat());
                FileAccess.endWrite();
                Loader.add(path.getSource());
                break;
            }
            case 102: {
                selPalette.addColor(0);
                this.setSelectedColor(selPalette.getColorCount() - 1);
                JScrollBar vscroll = this.scrollPane.getVerticalScrollBar();
                vscroll.setValue(vscroll.getMaximum());
                break;
            }
            case 103: {
                selPalette.removeColor(this.selColor);
                this.setSelectedColor(this.selColor);
                break;
            }
            case 104: {
                selPalette.moveTo(this.selColor, 0);
                this.setSelectedColor(0);
                break;
            }
            case 106: {
                selPalette.moveTo(this.selColor, this.selColor - 1);
                this.setSelectedColor(this.selColor - 1);
                break;
            }
            case 107: {
                selPalette.moveTo(this.selColor, this.selColor + 1);
                this.setSelectedColor(this.selColor + 1);
                break;
            }
            case 105: {
                selPalette.moveTo(this.selColor, selPalette.getColorCount() - 1);
                this.setSelectedColor(selPalette.getColorCount() - 1);
                break;
            }
            default: {
                accept = false;
            }
        }
        return accept;
    }

    private class FColorButton
    extends JPanel {
        public static final int SIZE = 24;
        private int index;
        private boolean dragging = false;
        private boolean mouseOver = false;
        private Point mouseStart;

        public FColorButton(int color) {
            this.setSize(new Dimension(24, 24));
            this.setBackground(new Color(color));
            this.listeners();
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        private void setDragging(boolean dragging) {
            this.dragging = dragging;
            CPaletteFrame.this.getDesktop().setResizing(dragging);
        }

        public boolean isDragging() {
            return this.dragging;
        }

        private void setMouseOver(boolean mouseOver) {
            this.mouseOver = mouseOver;
        }

        public boolean isMouseOver() {
            return this.mouseOver;
        }

        public boolean isSelected() {
            return CPaletteFrame.this.selColor == this.getIndex();
        }

        public String toString() {
            return "Button #" + this.getIndex() + " (" + Common.getHex(this.getBackground().getRGB(), 3, true) + ")";
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            this.setToolTipText("#" + Common.getHex(color.getRGB(), 3, true));
        }

        public void setCursor(Cursor cursor) {
            this.getParent().setCursor(cursor);
        }

        public void paintComponent(Graphics g) {
            int edge = 2;
            if (this.isMouseOver() || this.isSelected()) {
                g.setColor(Color.BLACK);
                int width = 4;
                int min = edge;
                int max = width + edge + 1;
                g.drawRect(min, min, width, width);
                g.drawRect(this.getWidth() - max, min, width, width);
                g.drawRect(min, this.getHeight() - max, width, width);
                g.drawRect(this.getWidth() - max, this.getHeight() - max, width, width);
                min = edge + 1;
                max = min * 2 + 1;
                g.setColor(Color.WHITE);
                g.drawRect(min, min, this.getWidth() - max, this.getHeight() - max);
            }
            int min = edge + 2;
            int max = min * 2 + 1;
            g.setColor(new Color(100, 100, 100));
            g.drawRect(min, min, this.getWidth() - max, this.getHeight() - max);
            min = edge + 3;
            max = min * 2;
            g.setColor(this.getBackground());
            g.fillRect(min, min, this.getWidth() - max, this.getHeight() - max);
        }

        private void listeners() {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    FColorButton.this.mouseStart = e.getLocationOnScreen();
                    FColorButton.this.setDragging(true);
                    CPaletteFrame.this.setSelectedColor(FColorButton.this.getIndex());
                }

                public void mouseReleased(MouseEvent e) {
                    FColorButton.this.setDragging(false);
                    FColorButton.this.move(e);
                }

                public void mouseEntered(MouseEvent e) {
                    if (!FColorButton.this.isDragging() && !CPaletteFrame.this.getDesktop().isResizing()) {
                        FColorButton.this.setMouseOver(true);
                        FColorButton.this.setCursor(new Cursor(12));
                        FColorButton.this.getParent().repaint();
                    }
                }

                public void mouseExited(MouseEvent e) {
                    FColorButton.this.setMouseOver(false);
                    FColorButton.this.setCursor(null);
                    FColorButton.this.getParent().repaint();
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                public void mouseDragged(MouseEvent e) {
                    FColorButton.this.move(e);
                }
            });
        }

        private void move(MouseEvent e) {
            Point mouse = e.getLocationOnScreen();
            Point pos = new Point(this.getX() + (mouse.x - this.mouseStart.x), this.getY() + (mouse.y - this.mouseStart.y));
            this.setLocation(pos);
            Component[] components = this.getParent().getComponents();
            FColorButton target = (FColorButton)e.getComponent();
            for (int i = 0; i < components.length; ++i) {
                FColorButton button = (FColorButton)components[i];
                if (button == target) continue;
                Point screen = button.getLocationOnScreen();
                Rectangle rect = new Rectangle(screen.x, screen.y, button.getWidth(), button.getHeight());
                if (CPaletteFrame.this.displayPanel.getColumn(button.getIndex()) == CPaletteFrame.this.displayPanel.getColumnCount() - 1 || button.getIndex() == CPaletteFrame.this.displayPanel.getButtonCount() - 1) {
                    rect.width = ((CPaletteFrame)CPaletteFrame.this).displayPanel.getPreferredSize().width - button.getX();
                }
                if (CPaletteFrame.this.displayPanel.getRow(button.getIndex()) == CPaletteFrame.this.displayPanel.getRowCount() - 1) {
                    rect.height = ((CPaletteFrame)CPaletteFrame.this).displayPanel.getPreferredSize().height - button.getY();
                }
                if (!rect.contains(mouse)) continue;
                CPaletteFrame.this.displayPanel.moveTo(target, button.getIndex());
                break;
            }
            this.getParent().doLayout();
            this.mouseStart = mouse;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FDisplay
    extends JPanel {
        private ArrayList<FColorButton> buttons = new ArrayList();

        private FDisplay() {
        }

        @Override
        public void setCursor(Cursor cursor) {
            if (!CPaletteFrame.this.getDesktop().isResizing()) {
                CPaletteFrame.this.getDesktop().setCursor(cursor);
            }
        }

        public void add(FColorButton button) {
            super.add(button);
            button.setIndex(this.getButtonCount());
            this.buttons.add(button);
        }

        public void remove(FColorButton button) {
            super.remove(button);
            this.buttons.remove(button);
        }

        public void moveTo(FColorButton target, int index) {
            CPaletteFrame.this.getPaletteBank().moveTo(target.getIndex(), index);
            this.buttons.remove(target);
            this.buttons.add(index, target);
            this.checkButtons();
            CPaletteFrame.this.setSelectedColor(target.getIndex());
        }

        private void checkButtons() {
            for (int i = 0; i < this.getButtonCount(); ++i) {
                this.getButton(i).setIndex(i);
            }
            while (this.getButtonCount() > CPaletteFrame.this.getPaletteBank().getColorCount()) {
                this.remove(this.getButton(this.getButtonCount() - 1));
            }
        }

        public ArrayList<FColorButton> getButtons() {
            return this.buttons;
        }

        public int getButtonCount() {
            return this.buttons.size();
        }

        public FColorButton getButton(int index) {
            if (this.getButtonCount() <= index) {
                this.add(new FColorButton(0));
            }
            return this.buttons.get(index);
        }

        public int getSelectedIndex() {
            for (int i = 0; i < this.getButtonCount(); ++i) {
                if (!this.getButton(i).isSelected()) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(FColorButton button) {
            return this.buttons.indexOf(button);
        }

        public int getMaxWidth() {
            int width = this.getParent().getWidth();
            if (CPaletteFrame.this.getPaletteBank() != null && CPaletteFrame.this.getPaletteBank().getDepth() == 4 && 384 <= width) {
                width = 384;
            }
            return width;
        }

        public int getColumnCount() {
            return (int)Math.floor((double)this.getMaxWidth() / 24.0);
        }

        public int getRowCount() {
            return this.getRow(this.getButtonCount() - 1) + 1;
        }

        public int getRow(int index) {
            return (int)Math.floor((double)index / (double)this.getColumnCount());
        }

        public int getColumn(int index) {
            return index - this.getRow(index) * this.getColumnCount();
        }

        public Rectangle getButtonBounds(int index) {
            int row = this.getRow(index);
            int column = this.getColumn(index);
            int size = 24;
            return new Rectangle(column * size, row * size, size, size);
        }

        @Override
        public void doLayout() {
            int height = this.getRowCount() * 24;
            if (this.getParent().getHeight() > height) {
                height = this.getParent().getHeight();
            }
            this.setPreferredSize(new Dimension(this.getMaxWidth(), height));
            int x = 0;
            int y = 0;
            for (FColorButton item : this.buttons) {
                int width = item.getWidth();
                if (x + width > this.getMaxWidth()) {
                    x = 0;
                    y += 24;
                }
                if (!item.isDragging()) {
                    item.setLocation(x, y);
                }
                x += width;
            }
            this.repaint();
        }

        private void orderButtons() {
            int selectedTab = this.getSelectedIndex();
            for (int i = 0; i < this.buttons.size(); ++i) {
                FColorButton button = this.buttons.get(i);
                if (i < selectedTab) {
                    this.setComponentZOrder(button, selectedTab - i);
                    continue;
                }
                if (i > selectedTab) {
                    this.setComponentZOrder(button, i);
                    continue;
                }
                this.setComponentZOrder(button, 0);
            }
        }
    }
}

