/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import util.CProperty;
import util.gui.frames.CFrame;
import util.gui.frames.FModelRender;
import util.struct.DFormat;
import util.struct.DImage;
import util.struct.DModel;
import util.struct.DPalette;

public class CModelFrame
extends CFrame {
    private FModelLayout display;
    private boolean toggleAlpha = false;

    public CModelFrame(DFormat format) {
        super(format);
        this.setBorder(null);
        this.setModel(this.getFormat());
        this.setImage((DImage)this.getAsset(20, null));
        this.setPalette((DPalette)this.getAsset(5, null));
        this.display = new FModelLayout();
        this.add(this.display);
        this.getToolBar().addComboBox(CProperty.SELECTED_MODEL_INDEX, "Model", "Model Index");
        this.getToolBar().addSeparator();
        this.getToolBar().addToggle(2000, CProperty.ALPHA);
    }

    public DModel getFormat() {
        return (DModel)super.getFormat();
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        ignored = true;
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (name.equals(CProperty.ALPHA.getName())) {
            this.toggleAlpha = (Boolean)value;
        } else {
            ignored = false;
        }
        super.checkProperty(evt, ignored);
    }

    public void setProperties() {
        super.setProperties();
        CProperty.ALPHA.setValue(this.toggleAlpha);
    }

    public void update() {
    }

    public boolean doAction(int action) {
        boolean accept = true;
        switch (action) {
            default: 
        }
        accept = false;
        return accept;
    }

    private class FModelLayout
    extends JPanel {
        private static final int SPACE = 6;
        private ArrayList<Rectangle> bounds = new ArrayList();

        public FModelLayout() {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setBackground(new Color(180, 180, 180));
            this.add(new FModelRender());
        }

        public void doLayout() {
            int count = this.getComponentCount();
            int rows = 1;
            int cols = 1;
            if (count > 1) {
                cols = 2;
                rows = count / 2;
            }
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            int mwidth = width - 6 * (cols - 1);
            int mheight = height - 6 * (rows - 1);
            int cwidth = (int)Math.floor((double)mwidth / (double)cols);
            int cheight = (int)Math.floor((double)mheight / (double)rows);
            int lwidth = mwidth - cwidth * (cols - 1);
            int lheight = mheight - cheight * (rows - 1);
            this.bounds = new ArrayList();
            for (int i = 0; i < count; ++i) {
                Component comp = this.getComponent(i);
                int col = i % 2;
                int row = i / 2;
                int twidth = cwidth;
                int theight = cheight;
                if (col + 1 == cols) {
                    twidth = lwidth;
                }
                if (row + 1 == rows) {
                    theight = lheight;
                }
                comp.setBounds(insets.left + col * 6 + col * cwidth, insets.top + row * 6 + row * cheight, twidth, theight);
                this.bounds.add(comp.getBounds());
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(new Color(40, 40, 40));
            g2.setStroke(new BasicStroke(5.0f));
            for (Rectangle rect : this.bounds) {
                g.drawRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 1, 1);
            }
        }
    }
}

