/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import util.CClipboard;
import util.CProperty;
import util.gui.frames.CFrame;
import util.gui.frames.FImageRender;
import util.struct.DFormat;
import util.struct.DGraphic;
import util.struct.DMap;
import util.struct.DPalette;

public class CMapFrame
extends CFrame {
    private FImageRender display;
    private boolean toggleAlpha = false;
    private BufferedImage image;

    public CMapFrame(DFormat format) {
        super(format);
        this.setMap(this.getFormat());
        this.setTile((DGraphic)this.getAsset(6, null));
        this.setPalette((DPalette)this.getAsset(5, null));
        this.display = new FImageRender();
        this.add(this.display);
        this.getToolBar().addComboBox(CProperty.SELECTED_PALETTE_INDEX, "Palette", "Palette Index");
        this.getToolBar().addComboBox(CProperty.SELECTED_TILE_INDEX, "Tile", "Bank Index");
        this.getToolBar().addSeparator();
        this.getToolBar().addToggle(2000, CProperty.ALPHA);
    }

    public DMap getFormat() {
        return (DMap)super.getFormat();
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        ignored = true;
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (name.equals(CProperty.ALPHA.getName())) {
            this.toggleAlpha = (Boolean)value;
        } else {
            ignored = false;
        }
        super.checkProperty(evt, ignored);
    }

    public void setProperties() {
        super.setProperties();
        CProperty.ALPHA.setValue(this.toggleAlpha);
    }

    public void update() {
        if (this.getPaletteBank() != null && this.getTileBank() != null) {
            this.image = this.getMapBank().getBuffer(this.getPaletteBank(), this.getTileBank(), this.toggleAlpha);
            this.display.setImage(this.image);
        }
    }

    public boolean doAction(int action) {
        boolean accept = true;
        switch (action) {
            case 50: {
                CClipboard.setImage(this.image);
                break;
            }
            default: {
                accept = false;
            }
        }
        return accept;
    }
}

