/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import util.CAction;
import util.CProperty;
import util.gui.CDesktop;
import util.gui.frames.CFrame;
import util.gui.frames.FGridRender;
import util.struct.DAnim;
import util.struct.DCell;
import util.struct.DFormat;
import util.struct.DGraphic;
import util.struct.DMapCell;
import util.struct.DPalette;
import util.struct.graphics.CAnimBank;
import util.struct.graphics.CAnimBuffer;
import util.struct.graphics.CCellBuffer;
import util.struct.graphics.CMapCell;

public class CMapCellFrame
extends CFrame {
    private FGridRender display;
    private boolean toggleAlpha = true;
    private boolean toggleOrder = false;
    private boolean toggleGrid = true;
    private boolean toggleOutline = true;
    private boolean toggleRender = true;
    private CCellBuffer buffer;

    public CMapCellFrame(DFormat format) {
        super(format);
        this.setMapCell(this.getFormat());
        this.setAnim((DAnim)this.getAsset(8, null));
        this.setCell((DCell)this.getAsset(7, null));
        this.setTile((DGraphic)this.getAsset(6, null));
        this.setPalette((DPalette)this.getAsset(5, null));
        this.display = new FGridRender();
        this.add(this.display);
        this.getToolBar().addComboBox(CProperty.SELECTED_MAP_CELL_INDEX, "Mapped Cell:", "Mapped Cell Bank");
        this.getToolBar().addSeparator();
        this.getToolBar().addToggle(2000, CProperty.ALPHA);
        this.getToolBar().addToggle(3001, CProperty.CELL_GRID);
        this.getToolBar().addToggle(3002, CProperty.CELL_OUTLINE);
        this.getToolBar().addToggle(3000, CProperty.CELL_ORDER);
        this.getToolBar().addToggle(3003, CProperty.CELL_RENDER);
    }

    public DMapCell getFormat() {
        return (DMapCell)super.getFormat();
    }

    public void setProperties() {
        super.setProperties();
        this.display.centerDisplay();
        boolean renderable = this.getPaletteBank() != null && this.getImageBank() != null;
        CAction.getAction(3003).setEnabled(renderable);
        CProperty.ALPHA.setValue(this.toggleAlpha);
        CProperty.CELL_ORDER.setValue(this.toggleOrder);
        CProperty.CELL_GRID.setValue(this.toggleGrid);
        CProperty.CELL_OUTLINE.setValue(this.toggleOutline);
        CProperty.CELL_RENDER.setValue(this.toggleRender);
        CDesktop.PANEL_INFO.addModel(this.getMapCellBank().getModel());
        this.buffer();
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        ignored = true;
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (name.equals(CProperty.ALPHA.getName())) {
            this.toggleAlpha = (Boolean)value;
            this.buffer();
        } else if (name.equals(CProperty.CELL_ORDER.getName())) {
            this.toggleOrder = (Boolean)value;
        } else if (name.equals(CProperty.CELL_GRID.getName())) {
            this.toggleGrid = (Boolean)value;
        } else if (name.equals(CProperty.CELL_OUTLINE.getName())) {
            this.toggleOutline = (Boolean)value;
        } else if (name.equals(CProperty.CELL_RENDER.getName())) {
            this.toggleRender = (Boolean)value;
        } else {
            ignored = false;
        }
        super.checkProperty(evt, ignored);
        boolean paletteChange = name.equals(CProperty.SELECTED_PALETTE.getName());
        boolean imageChange = name.equals(CProperty.SELECTED_TILE.getName());
        if (paletteChange || imageChange) {
            this.buffer();
        }
        if (name.equals(CProperty.SELECTED_CELL_INDEX.getName())) {
            CDesktop.PANEL_INFO.setModel(this.getCellBank().getModel());
            this.buffer();
        }
    }

    private boolean isTransparent() {
        return this.toggleAlpha;
    }

    private boolean isReverseOrder() {
        return this.toggleOrder;
    }

    private boolean isGridEnabled() {
        return this.toggleGrid;
    }

    private boolean isOutlineEnabled() {
        return this.toggleOutline;
    }

    private boolean isRenderEnabled() {
        return this.toggleRender;
    }

    public void update() {
        if (this.getCellBank() != null) {
            this.display.update(this.buffer, this.isGridEnabled(), this.isRenderEnabled(), this.isOutlineEnabled());
        }
    }

    private void buffer() {
        ArrayList<CAnimBuffer> anims = new ArrayList<CAnimBuffer>();
        if (this.getAnimAsset() != null) {
            for (CAnimBank anim : this.getAnimAsset().getAnimBanks()) {
                anims.add(anim.getBuffer(this.getPaletteAsset(), this.getTileAsset(), this.getCellAsset(), this.toggleAlpha));
            }
            Rectangle bounds = null;
            ArrayList<CCellBuffer> cells = new ArrayList<CCellBuffer>();
            for (int i = 0; i < this.getMapCellBank().getItemCount(); ++i) {
                CMapCell cell = this.getMapCellBank().get(this.getMapCellBank().getItemCount() - i - 1);
                CAnimBuffer anim = (CAnimBuffer)anims.get(cell.getFrame());
                CCellBuffer frame = anim.getFrame(0);
                BufferedImage image = new BufferedImage(frame.getWidth(), frame.getHeight(), 2);
                Graphics g = image.getGraphics();
                g.setColor(Color.BLACK);
                g.drawRect(0, 0, image.getWidth() - 1, image.getHeight() - 1);
                CCellBuffer cellBuffer = new CCellBuffer(frame.getImage(), new Point(frame.getX() + cell.getX(), frame.getY() + cell.getY()));
                cells.add(cellBuffer);
                bounds = CCellBuffer.checkBounds(bounds, cellBuffer.getBounds());
            }
            BufferedImage image = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics g = image.getGraphics();
            for (CCellBuffer cell : cells) {
                g.drawImage(cell.getImage(), cell.getX() - bounds.x, cell.getY() - bounds.y, null);
            }
            this.buffer = new CCellBuffer(image, bounds.getLocation());
        }
        this.update();
    }

    public boolean doAction(int action) {
        boolean accept = true;
        switch (action) {
            default: 
        }
        accept = false;
        return accept;
    }
}

