/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import util.CAction;
import util.Common;
import util.gui.frames.CFrame;
import util.struct.DFile;
import util.struct.DFormat;
import util.struct.DPath;

public class CHexFrame
extends CFrame {
    public static final Color TEXT = new Color(128, 128, 128);
    public static final Color BUTTON = new Color(240, 240, 240);
    public static final Color SEPARATOR = new Color(227, 227, 227);
    public static final Color SELECTED = new Color(0, 0, 255);
    public static final Color ALT = new Color(0, 0, 128);
    public static final Color BUTTON_SELECT = SEPARATOR;
    private JScrollBar scrollBar;
    private JScrollBar hscrollBar;
    private CSplitPane splitPane;
    private CSplitPane topPane;
    private JLayeredPane bodyPane;
    private JTextComponent offsetArea;
    private JTextComponent hexArea;
    private JTextComponent asciiArea;
    private CHeaderPane hexHeader;
    private CHeaderPane asciiHeader;
    private int offsetWidth = 4;
    private int rowWidth = 16;
    private Font font = new Font("Lucida Console", 0, 12);
    private long readOffset;
    private int highlightedRow;
    private int highlightedColumn;
    private int selectedRow;

    public CHexFrame(DFormat format) {
        super(format);
        this.initComponents();
    }

    private void initComponents() {
        this.topPane = new CSplitPane();
        this.bodyPane = new JLayeredPane();
        this.scrollBar = new JScrollBar();
        this.hscrollBar = new JScrollBar();
        this.splitPane = new CSplitPane();
        this.offsetArea = new JTextArea();
        this.hexArea = new JTextArea();
        this.asciiArea = new JTextArea();
        this.hexHeader = new CHeaderPane();
        this.asciiHeader = new CHeaderPane();
        this.offsetArea.setFont(this.font);
        this.offsetArea.setEditable(false);
        this.offsetArea.setFocusable(false);
        this.offsetArea.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.offsetArea.setBackground(BUTTON);
        this.offsetArea.setForeground(TEXT);
        this.offsetArea.addMouseMotionListener(new MouseAdapter(){

            public void mouseMoved(MouseEvent e) {
                CHexFrame.this.setHightlightedRow((int)Math.floor((double)e.getPoint().y / (double)CHexFrame.this.getRowHeight()));
            }
        });
        this.offsetArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                CHexFrame.this.setSelectedRow((int)Math.floor((double)e.getPoint().y / (double)CHexFrame.this.getRowHeight()));
            }

            public void mouseExited(MouseEvent e) {
                CHexFrame.this.setHightlightedRow(-1);
            }
        });
        this.hexArea.setFont(this.font);
        this.hexArea.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 4));
        this.hexArea.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                CHexFrame.this.move(e);
            }

            public void mouseMoved(MouseEvent e) {
                CHexFrame.this.move(e);
            }
        });
        this.asciiArea.setFont(this.font);
        this.asciiArea.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 4));
        this.asciiArea.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                CHexFrame.this.move(e);
            }

            public void mouseMoved(MouseEvent e) {
                CHexFrame.this.move(e);
            }
        });
        this.bodyPane.setLayout(new CBorderLayout());
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                CHexFrame.this.update();
            }
        });
        this.bodyPane.add((Component)this.scrollBar, "East");
        this.hscrollBar.setOrientation(0);
        this.hscrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                CHexFrame.this.update();
            }
        });
        this.bodyPane.add((Component)this.hscrollBar, "South");
        this.splitPane.addMouseMotionListener(new MouseAdapter(){

            public void mouseDragged(MouseEvent e) {
                CHexFrame.this.resize(e);
            }
        });
        this.splitPane.setLeftComponent(this.offsetArea);
        this.splitPane.setMiddleComponent(this.hexArea);
        this.splitPane.setRightComponent(this.asciiArea);
        this.bodyPane.add(this.splitPane);
        this.hexHeader.setBorder(this.hexArea.getBorder());
        this.asciiHeader.setBorder(this.asciiArea.getBorder());
        this.topPane.setPreferredSize(new Dimension(0, 16));
        this.topPane.addMouseMotionListener(new MouseAdapter(){

            public void mouseDragged(MouseEvent e) {
                CHexFrame.this.resize(e);
            }
        });
        this.topPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SEPARATOR));
        this.topPane.setLeftComponent(new CHeaderPane());
        this.topPane.setMiddleComponent(this.hexHeader);
        this.topPane.setRightComponent(this.asciiHeader);
        this.bodyPane.add((Component)this.topPane, "North");
        this.add(this.bodyPane);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                CHexFrame.this.scrollBar.setValue(CHexFrame.this.scrollBar.getValue() + e.getWheelRotation());
            }
        });
    }

    public PropertyChangeListener setPropertyListener() {
        return null;
    }

    public void setHightlightedRow(int row) {
        this.highlightedRow = row;
        this.updateDisplay();
    }

    public void setHiglightedColumn(int column) {
        this.highlightedColumn = column;
        this.updateDisplay();
    }

    public void setSelectedRow(int row) {
        this.selectedRow = row;
    }

    public int getRowHeight() {
        return this.hexArea.getFontMetrics(this.font).getHeight();
    }

    public int getRowCount() {
        return (int)Math.ceil((double)this.hexArea.getHeight() / (double)this.getRowHeight());
    }

    public int getColumnWidth() {
        return this.hexArea.getFontMetrics(this.font).charWidth('a');
    }

    public int getColumnCount() {
        return (int)Math.floor((double)this.hexArea.getWidth() / (double)this.getColumnWidth());
    }

    public void resize(MouseEvent e) {
        Point mouse = e.getPoint();
        CSplitPane split = (CSplitPane)e.getComponent();
        if (split.isResizing()) {
            switch (split.getResizeMode()) {
                case 1: {
                    JComponent left = (JComponent)this.splitPane.getLeftComponent();
                    int width = (int)Math.round((double)(mouse.x - left.getInsets().left - left.getInsets().right) / (double)this.getColumnWidth() / 2.0);
                    if (width < 2) {
                        width = 2;
                    }
                    if (width > 6) {
                        width = 6;
                    }
                    this.offsetWidth = width;
                    this.update();
                    break;
                }
                case 2: {
                    int width;
                    JComponent mid = (JComponent)this.splitPane.getCenterComponent();
                    this.rowWidth = width = (int)Math.round((double)(mouse.x - mid.getX() - mid.getInsets().left - mid.getInsets().right) / (double)this.getColumnWidth() / 3.0);
                    this.update();
                }
            }
        }
    }

    public void move(MouseEvent e) {
        Point mouse = e.getPoint();
        double row = (double)mouse.y / (double)this.getRowHeight();
        double col = (double)mouse.x / (double)this.getColumnWidth();
        if (e.getComponent() == this.hexArea) {
            col /= 3.0;
        }
        this.highlightedRow = (int)Math.floor(row);
        this.highlightedColumn = (int)Math.floor(col);
        this.updateDisplay();
    }

    public void update() {
        CAction.getAction(24).setEnabled(false);
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            DPath path = this.getFormat().getPath();
            DFile file = path.getFile();
            int visibleRow = this.scrollBar.getValue() * this.rowWidth;
            int offsetRow = (int)Math.floor((double)this.readOffset / (double)this.rowWidth);
            int totalRows = (int)Math.ceil((double)file.getFullSize() / (double)this.rowWidth);
            this.scrollBar.setMaximum(totalRows + 2);
            this.scrollBar.setVisibleAmount(rowCount);
            int fullWidth = this.offsetArea.getWidth() + this.hexArea.getWidth() + this.asciiArea.getWidth() + this.splitPane.getHorizontalSpacing() * 2 + this.scrollBar.getWidth();
            int parentWidth = this.bodyPane.getWidth();
            int visibleWidth = (int)Math.round((double)parentWidth / (double)fullWidth * 100.0);
            this.hscrollBar.setVisibleAmount(visibleWidth);
            this.hscrollBar.setUnitIncrement(5);
            this.hscrollBar.setMaximum(100);
            this.updateText(path, visibleRow, rowCount);
        }
        this.topPane.doLayout();
        this.splitPane.doLayout();
    }

    public boolean doAction(int action) {
        boolean accept = true;
        switch (action) {
            default: 
        }
        accept = false;
        return accept;
    }

    public void updateDisplay() {
        try {
            this.removeHighlights(this.offsetArea);
            this.removeHighlights(this.hexHeader);
            this.removeHighlights(this.asciiHeader);
            int width = this.offsetWidth * 2 + 1;
            this.offsetArea.getHighlighter().addHighlight(width * this.highlightedRow, width * this.highlightedRow + width, new CHighlight());
            width = 3;
            this.hexHeader.getHighlighter().addHighlight(width * this.highlightedColumn, width * this.highlightedColumn + width - 1, new CHighlight());
            width = 1;
            this.asciiHeader.getHighlighter().addHighlight(width * this.highlightedColumn, width * this.highlightedColumn + width, new CHighlight());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void updateText(DPath path, long visibleOffset, int visibleRows) {
        String offsetText = "";
        String hexText = "";
        String asciiText = "";
        for (int i = 0; i < visibleRows; ++i) {
            byte[] data;
            long offset = visibleOffset + (long)(i * this.rowWidth);
            int size = this.rowWidth;
            if (offset + (long)size > path.getFile().getFullSize()) {
                size = (int)(path.getFile().getFullSize() - offset);
            }
            if (size <= 0) break;
            for (byte value : data = path.read(offset, size)) {
                hexText = hexText + Common.getHex(value) + " ";
                asciiText = value >= 32 && value <= 126 ? asciiText + Common.getString(value) : asciiText + ".";
            }
            offsetText = offsetText + Common.getHex(offset, this.offsetWidth) + "\n";
            hexText = hexText.substring(0, hexText.length() - 1) + "\n";
            asciiText = asciiText + "\n";
        }
        this.offsetArea.setText(offsetText);
        this.hexArea.setText(hexText);
        this.asciiArea.setText(asciiText);
        String hexHeaderText = "";
        String asciiHeaderText = "";
        for (int i = 0; i < this.rowWidth; ++i) {
            String value = Common.getHex(i, 1);
            hexHeaderText = hexHeaderText + value + " ";
            asciiHeaderText = asciiHeaderText + value.substring(value.length() - 1);
        }
        this.hexHeader.setText(hexHeaderText);
        this.asciiHeader.setText(asciiHeaderText);
    }

    public void removeHighlights(JTextComponent textComponent) {
        Highlighter highlighter = textComponent.getHighlighter();
        for (Highlighter.Highlight highlight : highlighter.getHighlights()) {
            if (!(highlight.getPainter() instanceof CHighlight)) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    private class CHeaderPane
    extends JTextArea {
        public CHeaderPane() {
            this.setEditable(false);
            this.setFocusable(false);
            this.setBackground(BUTTON);
            this.setForeground(TEXT);
            this.setFont(CHexFrame.this.font);
        }
    }

    private class CSplitPane
    extends JLayeredPane {
        public static final int WEST = 1;
        public static final int EAST = 2;
        private Component west = new JButton("Left");
        private Component center = new JButton("Center");
        private Component east = new JButton("Right");
        private int resizeMode;
        private boolean resizing = false;

        public CSplitPane() {
            this.setLeftComponent(this.west);
            this.setMiddleComponent(this.center);
            this.setRightComponent(this.east);
            this.addMouseMotionListener(new MouseAdapter(){

                public void mouseMoved(MouseEvent e) {
                    if (CSplitPane.this.getWestSplit().contains(e.getPoint())) {
                        CHexFrame.this.getDesktop().setCursor(new Cursor(10));
                        CSplitPane.this.resizeMode = 1;
                    } else if (CSplitPane.this.getEastSplit().contains(e.getPoint())) {
                        CHexFrame.this.getDesktop().setCursor(new Cursor(11));
                        CSplitPane.this.resizeMode = 2;
                    } else {
                        CHexFrame.this.getDesktop().setCursor(null);
                        CSplitPane.this.resizeMode = 0;
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (CSplitPane.this.resizeMode > 0) {
                        CSplitPane.this.resizing = true;
                        CHexFrame.this.getDesktop().setResizing(CSplitPane.this.resizing);
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    CHexFrame.this.getDesktop().setCursor(null);
                    CSplitPane.this.resizing = false;
                    CHexFrame.this.getDesktop().setResizing(CSplitPane.this.resizing);
                }

                public void mouseExited(MouseEvent e) {
                    if (!CSplitPane.this.resizing) {
                        CHexFrame.this.getDesktop().setCursor(null);
                    }
                }
            });
        }

        public void paintComponent(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.west.getBackground());
            g.fillRect(this.west.getX(), this.west.getY(), this.west.getWidth() + 1, this.west.getHeight());
            g.setColor(this.center.getBackground());
            g.fillRect(this.center.getX() - 2, this.west.getY(), this.center.getWidth() + 4, this.center.getHeight());
            g.setColor(this.east.getBackground());
            g.fillRect(this.east.getX() - 2, this.east.getY(), this.getWidth() - this.east.getX() + 2, this.east.getHeight());
            g.setColor(SEPARATOR);
            g.drawLine(this.center.getX() - 3, 0, this.center.getX() - 3, this.getHeight());
            g.drawLine(this.east.getX() - 3, 0, this.east.getX() - 3, this.getHeight());
        }

        public boolean isResizing() {
            return this.resizing;
        }

        public int getResizeMode() {
            return this.resizeMode;
        }

        public int getHorizontalSpacing() {
            return 4;
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            int y = insets.top;
            int height = this.getHeight() - insets.top - insets.bottom;
            int westX = insets.left;
            int westWidth = CHexFrame.this.offsetWidth * CHexFrame.this.getColumnWidth() * 2 + 8;
            int centerX = westWidth + this.getHorizontalSpacing() + insets.left;
            int centerWidth = CHexFrame.this.rowWidth * CHexFrame.this.getColumnWidth() * 3 + 8;
            int eastX = centerX + centerWidth + this.getHorizontalSpacing();
            int eastWidth = CHexFrame.this.rowWidth * CHexFrame.this.getColumnWidth() + 8;
            int fullWidth = eastX + eastWidth;
            int hscroll = (int)Math.round((double)CHexFrame.this.hscrollBar.getValue() / 100.0 * (double)fullWidth);
            this.west.setLocation(westX - hscroll, y);
            this.west.setSize(westWidth, height);
            this.center.setLocation(centerX - hscroll, y);
            this.center.setSize(centerWidth, height);
            this.east.setLocation(eastX - hscroll, y);
            this.east.setSize(eastWidth, height);
        }

        public Rectangle getWestSplit() {
            return new Rectangle(this.west.getWidth(), 0, this.getHorizontalSpacing(), this.getHeight());
        }

        public Rectangle getEastSplit() {
            return new Rectangle(this.center.getX() + this.center.getWidth(), 0, this.getHorizontalSpacing(), this.getHeight());
        }

        public void setLeftComponent(Component component) {
            this.remove(this.west);
            this.add(component, "West");
            this.west = component;
            this.addListeners(this.west);
        }

        public void setMiddleComponent(Component component) {
            this.remove(this.center);
            this.add(component, "Center");
            this.center = component;
            this.addListeners(this.center);
        }

        public void setRightComponent(Component component) {
            this.remove(this.east);
            this.add(component, "East");
            this.east = component;
            this.addListeners(this.east);
        }

        public Component getLeftComponent() {
            return this.west;
        }

        public Component getCenterComponent() {
            return this.center;
        }

        public Component getRightComponent() {
            return this.east;
        }

        private void addListeners(Component component) {
            component.addMouseMotionListener(new MouseAdapter(){

                public void mouseMoved(MouseEvent e) {
                    Point mouse = new Point(e.getComponent().getX() + e.getPoint().x, e.getComponent().getY() + e.getPoint().y);
                    CHexFrame.this.getDesktop().setCursor(null);
                }
            });
        }
    }

    private class CBorderLayout
    extends BorderLayout {
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            Component south = this.getLayoutComponent("South");
            Component east = this.getLayoutComponent("East");
            if (south != null && east != null) {
                south.setSize(parent.getWidth() - east.getWidth(), south.getHeight());
            }
        }
    }

    private class CHighlight
    extends DefaultHighlighter.DefaultHighlightPainter {
        public CHighlight() {
            super(BUTTON_SELECT);
        }
    }
}

