/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import ctool.Loader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import util.CProperty;
import util.Common;
import util.gui.CDesktop;
import util.gui.CFrameBox;
import util.gui.CTab;
import util.gui.CToolBar;
import util.gui.panels.CComboBoxModel;
import util.gui.panels.CTableModel;
import util.struct.DAnim;
import util.struct.DCell;
import util.struct.DFormat;
import util.struct.DGraphic;
import util.struct.DImage;
import util.struct.DMap;
import util.struct.DMapAnim;
import util.struct.DMapCell;
import util.struct.DModel;
import util.struct.DPalette;
import util.struct.graphics.CAnimBank;
import util.struct.graphics.CCell;
import util.struct.graphics.CGraphic;
import util.struct.graphics.CImage;
import util.struct.graphics.CMapBank;
import util.struct.graphics.CMapCellBank;
import util.struct.graphics.CPalette;
import util.struct.models.CModel;

public abstract class CFrame
extends JPanel {
    public static final Color COLOR_BG = new Color(120, 120, 120);
    public static final Color COLOR_FILL = new Color(180, 180, 180);
    public static final Color COLOR_LINE = new Color(48, 48, 48);
    public static final Color COLOR_SELECT = new Color(51, 153, 255);
    private CToolBar toolBar;
    private DFormat format;
    private boolean selected;
    private int index;
    private PropertyChangeListener listener;
    private DPalette selPalette;
    private DGraphic selTile;
    private DImage selImage;
    private DCell selCell;
    private DAnim selAnim;
    private DMap selMap;
    private DModel selModel;
    private DMapCell selMapCell;
    private DMapAnim selMapAnim;

    public CFrame(DFormat format) {
        this.format = format;
        this.setName(format.getPath().getFile().getFullName());
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this.toolBar = new CToolBar();
        this.add((Component)this.toolBar, "North");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                CFrame.this.update();
            }
        });
        this.setPropertyListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (CFrame.this.isSelected()) {
                    CFrame.this.checkProperty(evt, false);
                }
            }
        });
    }

    public String toString() {
        return "Frame: " + this.getName();
    }

    public DFormat getFormat() {
        return this.format;
    }

    public abstract void update();

    public abstract boolean doAction(int var1);

    public final void setPropertyListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public final void setEnabled(boolean enabled) {
        CProperty.removePropertyChangeListener(this.listener);
        this.getFrameBox().removeFrame(this);
    }

    public final void setVisible(boolean visible) {
        boolean oldVisible = this.isVisible();
        super.setVisible(visible);
        if (!oldVisible && visible) {
            CProperty.addPropertyChangeListener(this.listener);
            this.update();
        } else if (oldVisible && !visible) {
            CProperty.removePropertyChangeListener(this.listener);
        }
    }

    public final void setCursor(Cursor cursor) {
        if (!this.getDesktop().isResizing()) {
            this.getDesktop().setCursor(cursor);
        }
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int index) {
        int oldIndex = this.index;
        this.index = index;
        this.firePropertyChange("index", oldIndex, index);
    }

    public final void setSelected(boolean selected) {
        this.selected = selected;
        if (this.getParent() != null) {
            if (this.getFrameBox().getSelected() != this && selected) {
                this.getFrameBox().setSelected(this);
            }
            CTab tab = this.getFrameBox().getTab(this);
            if (selected) {
                tab.setState(2);
            } else {
                tab.setState(0);
            }
        }
        if (selected) {
            this.setProperties();
        }
        this.setVisible(selected);
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public final CFrameBox getFrameBox() {
        Container parent = super.getParent();
        if (parent != null) {
            return (CFrameBox)parent.getParent();
        }
        return null;
    }

    public final CDesktop getDesktop() {
        return this.getFrameBox().getDesktop();
    }

    public final CToolBar getToolBar() {
        return this.toolBar;
    }

    public final CFrame getFrame() {
        return this;
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        String id = "-> " + this.getFormat().getName() + " Editor ";
        if (name.equals(CProperty.SELECTED_PALETTE.getName())) {
            Common.msg(id + "Change Palette Asset: " + this.selPalette + " > " + this.getPaletteAsset());
            this.selPalette = this.getPaletteAsset();
        } else if (name.equals(CProperty.SELECTED_TILE.getName())) {
            Common.msg(id + "Change Tile Asset: " + this.selTile + " > " + this.getTileAsset());
            this.selTile = this.getTileAsset();
        } else if (name.equals(CProperty.SELECTED_IMAGE.getName())) {
            Common.msg(id + "Change Image Asset: " + this.selImage + " > " + this.getImageAsset());
            this.selImage = this.getImageAsset();
        } else if (name.equals(CProperty.SELECTED_CELL.getName())) {
            Common.msg(id + "Change Cell Asset: " + this.selCell + " > " + this.getCellAsset());
            this.selCell = this.getCellAsset();
        } else if (name.equals(CProperty.SELECTED_ANIM.getName())) {
            Common.msg(id + "Change Animation Asset: " + this.selAnim + " > " + this.getAnimAsset());
            this.selAnim = this.getAnimAsset();
        } else if (name.equals(CProperty.SELECTED_MAP.getName())) {
            Common.msg(id + "Change Map Asset: " + this.selMap + " > " + this.getMapAsset());
            this.selMap = this.getMapAsset();
        } else if (name.equals(CProperty.SELECTED_MODEL.getName())) {
            Common.msg(id + "Change Model Asset: " + this.selModel + " > " + this.getModelAsset());
            this.selModel = this.getModelAsset();
        } else if (name.equals(CProperty.SELECTED_PALETTE_INDEX.getName())) {
            this.setPaletteBank(this.getModel(CProperty.SELECTED_PALETTE_INDEX).getSelectedIndex());
        } else if (name.equals(CProperty.SELECTED_TILE_INDEX.getName())) {
            this.setTileBank(this.getModel(CProperty.SELECTED_TILE_INDEX).getSelectedIndex());
        } else if (name.equals(CProperty.SELECTED_IMAGE_INDEX.getName())) {
            this.setImageBank(this.getModel(CProperty.SELECTED_IMAGE_INDEX).getSelectedIndex());
        } else if (name.equals(CProperty.SELECTED_CELL_INDEX.getName())) {
            this.setCellBank(this.getModel(CProperty.SELECTED_CELL_INDEX).getSelectedIndex());
        } else if (name.equals(CProperty.SELECTED_ANIM_INDEX.getName())) {
            this.setAnimBank(this.getModel(CProperty.SELECTED_ANIM_INDEX).getSelectedIndex());
        } else if (name.equals(CProperty.SELECTED_MAP_INDEX.getName())) {
            this.setMapBank(this.getModel(CProperty.SELECTED_MAP_INDEX).getSelectedIndex());
        } else if (name.equals(CProperty.SELECTED_MAP_CELL_INDEX.getName())) {
            this.setMapCellBank(this.getModel(CProperty.SELECTED_MAP_CELL_INDEX).getSelectedIndex());
        } else if (!name.equals(CProperty.SELECTED_FRAME.getName()) && !ignored) {
            Common.msg(id + name + ".value = " + value);
        }
        this.update();
    }

    public void setProperties() {
        CDesktop.PANEL_INFO.removeModel();
        CDesktop.PANEL_INFO.addModel(this.getFormat().getPath().getModel());
        CDesktop.PANEL_INFO.addModel(this.getFormat().getModel());
        CTableModel assetsModel = new CTableModel("Assets");
        int type = this.getFormat().getType();
        if (type == 5 || type == 6 || type == 20 || type == 9 || type == 7 || type == 8 || type == 50 || type == 31) {
            this.selPalette = (DPalette)this.getAsset(5, this.selPalette);
            this.setPaletteAsset(this.selPalette);
            if (this.selPalette != null) {
                this.setSelectedModel(CProperty.SELECTED_PALETTE_INDEX, this.selPalette.getItems().toArray(), this.selPalette.getSelected());
                if (type != 5) {
                    assetsModel.addRow("Palette", CProperty.SELECTED_PALETTE);
                }
            } else {
                this.setSelectedModel(CProperty.SELECTED_PALETTE_INDEX);
            }
        }
        if (type == 6 || type == 9 || type == 7 || type == 8 || type == 50) {
            this.selTile = (DGraphic)this.getAsset(6, this.selTile);
            this.setTileAsset(this.selTile);
            if (this.selTile != null) {
                this.setSelectedModel(CProperty.SELECTED_TILE_INDEX, this.selTile.getItems().toArray(), this.selTile.getSelected());
                if (type != 6) {
                    assetsModel.addRow("Image", CProperty.SELECTED_TILE);
                }
            } else {
                this.setSelectedModel(CProperty.SELECTED_TILE_INDEX);
            }
        }
        if (type == 20 || type == 31) {
            this.selImage = (DImage)this.getAsset(20, this.selImage);
            this.setImageAsset(this.selImage);
            if (this.selImage != null) {
                this.setSelectedModel(CProperty.SELECTED_IMAGE_INDEX, this.selImage.getItems().toArray(), this.selImage.getSelected());
                if (type != 20) {
                    assetsModel.addRow("Image", CProperty.SELECTED_IMAGE);
                }
            } else {
                this.setSelectedModel(CProperty.SELECTED_IMAGE_INDEX);
            }
        }
        if (type == 9) {
            this.selMap = (DMap)this.getAsset(9, this.selMap);
            this.setMapAsset(this.selMap);
            if (this.selMap != null) {
                this.setSelectedModel(CProperty.SELECTED_MAP_INDEX, this.selMap.getItems().toArray(), this.selMap.getSelected());
                if (type != 9) {
                    assetsModel.addRow("Map", CProperty.SELECTED_MAP);
                }
            } else {
                this.setSelectedModel(CProperty.SELECTED_MAP_INDEX);
            }
        }
        if (type == 7 || type == 8 || type == 50) {
            this.selCell = (DCell)this.getAsset(7, this.selCell);
            this.setCellAsset(this.selCell);
            if (this.selCell != null) {
                this.setSelectedModel(CProperty.SELECTED_CELL_INDEX, this.selCell.getItems().toArray(), this.selCell.getSelected());
                if (type != 7) {
                    assetsModel.addRow("Cell", CProperty.SELECTED_CELL);
                }
            } else {
                this.setSelectedModel(CProperty.SELECTED_CELL_INDEX);
            }
        }
        if (type == 8 || type == 50) {
            this.selAnim = (DAnim)this.getAsset(8, this.selAnim);
            this.setAnimAsset(this.selAnim);
            if (this.selAnim != null) {
                this.setSelectedModel(CProperty.SELECTED_ANIM_INDEX, this.selAnim.getItems().toArray(), this.selAnim.getSelected());
                if (type != 8) {
                    assetsModel.addRow("Animation", CProperty.SELECTED_ANIM);
                }
            } else {
                this.setSelectedModel(CProperty.SELECTED_ANIM_INDEX);
            }
        }
        if (type == 50) {
            this.selMapCell = (DMapCell)this.getAsset(50, this.selMapCell);
            this.setMapCellAsset(this.selMapCell);
            if (this.selMapCell != null) {
                this.setSelectedModel(CProperty.SELECTED_MAP_CELL_INDEX, this.selMapCell.getItems().toArray(), this.selMapCell.getSelected());
                if (type != 50) {
                    assetsModel.addRow("Mapped Cell", CProperty.SELECTED_MAP_CELL);
                }
            } else {
                this.setSelectedModel(CProperty.SELECTED_MAP_CELL_INDEX);
            }
        }
        if (type == 31) {
            this.selModel = (DModel)this.getAsset(31, this.selModel);
            this.setModelAsset(this.selModel);
            if (this.selModel != null) {
                this.setSelectedModel(CProperty.SELECTED_MODEL_INDEX, this.selModel.getItems().toArray(), this.selModel.getSelected());
                if (type != 31) {
                    assetsModel.addRow("Model", CProperty.SELECTED_MODEL);
                }
            } else {
                this.setSelectedModel(CProperty.SELECTED_MODEL_INDEX);
            }
        }
        CDesktop.PANEL_INFO.addModel(assetsModel);
    }

    protected DFormat getAsset(int type, DFormat format) {
        return Loader.getSelectedFormat(type, format);
    }

    protected void setSelectedModel(CProperty.CPropertyOption property) {
        property.setValue(new CComboBoxModel());
    }

    private void setSelectedModel(CProperty.CPropertyOption property, Object[] list, Object selected) {
        property.setValue(new CComboBoxModel(list, selected));
    }

    private Object getSelectedModel(CProperty.CPropertyOption property) {
        CComboBoxModel model = this.getModel(property);
        return model.getSelectedItem();
    }

    private CComboBoxModel getModel(CProperty.CPropertyOption property) {
        return (CComboBoxModel)property.getValue();
    }

    protected void setPalette(DPalette asset) {
        this.selPalette = asset;
    }

    protected void setPaletteAsset(DPalette asset) {
        this.setSelectedModel(CProperty.SELECTED_PALETTE, Loader.getFormats(5).toArray(), asset);
        this.selPalette = asset;
    }

    protected void setPaletteBank(int index) {
        this.selPalette.setSelectedIndex(index);
    }

    protected DPalette getPaletteAsset() {
        return (DPalette)this.getSelectedModel(CProperty.SELECTED_PALETTE);
    }

    protected CPalette getPaletteBank() {
        if (this.selPalette != null) {
            return this.selPalette.getSelected();
        }
        return null;
    }

    protected void setTile(DGraphic asset) {
        this.selTile = asset;
    }

    protected void setTileAsset(DGraphic asset) {
        this.setSelectedModel(CProperty.SELECTED_TILE, Loader.getFormats(6).toArray(), asset);
        this.selTile = asset;
    }

    protected void setTileBank(int index) {
        this.selTile.setSelectedIndex(index);
    }

    protected DGraphic getTileAsset() {
        return (DGraphic)this.getSelectedModel(CProperty.SELECTED_TILE);
    }

    protected CGraphic getTileBank() {
        if (this.selTile != null) {
            return this.selTile.getSelected();
        }
        return null;
    }

    protected void setImage(DImage asset) {
        this.selImage = asset;
    }

    protected void setImageAsset(DImage asset) {
        this.setSelectedModel(CProperty.SELECTED_IMAGE, Loader.getFormats(20).toArray(), asset);
        this.selImage = asset;
    }

    protected void setImageBank(int index) {
        this.selImage.setSelectedIndex(index);
    }

    protected DImage getImageAsset() {
        return (DImage)this.getSelectedModel(CProperty.SELECTED_IMAGE);
    }

    protected CImage getImageBank() {
        if (this.selImage != null) {
            return this.selImage.getSelected();
        }
        return null;
    }

    protected void setMap(DMap asset) {
        this.selMap = asset;
    }

    protected void setMapAsset(DMap asset) {
        this.setSelectedModel(CProperty.SELECTED_MAP, Loader.getFormats(9).toArray(), asset);
        this.selMap = asset;
    }

    protected void setMapBank(int index) {
        this.selMap.setSelectedIndex(index);
    }

    protected DMap getMapAsset() {
        return (DMap)this.getSelectedModel(CProperty.SELECTED_MAP);
    }

    protected CMapBank getMapBank() {
        if (this.selMap != null) {
            return this.selMap.getSelected();
        }
        return null;
    }

    protected void setCell(DCell asset) {
        this.selCell = asset;
    }

    protected void setCellAsset(DCell asset) {
        this.setSelectedModel(CProperty.SELECTED_CELL, Loader.getFormats(7).toArray(), asset);
        this.selCell = asset;
    }

    protected void setCellBank(int index) {
        this.selCell.setSelectedIndex(index);
    }

    protected DCell getCellAsset() {
        return (DCell)this.getSelectedModel(CProperty.SELECTED_CELL);
    }

    protected CCell getCellBank() {
        if (this.selCell != null) {
            return this.selCell.getSelected();
        }
        return null;
    }

    protected void setAnim(DAnim asset) {
        this.selAnim = asset;
    }

    protected void setAnimAsset(DAnim asset) {
        this.setSelectedModel(CProperty.SELECTED_ANIM, Loader.getFormats(8).toArray(), asset);
        this.selAnim = asset;
    }

    protected void setAnimBank(int index) {
        this.selAnim.setSelectedIndex(index);
    }

    protected DAnim getAnimAsset() {
        return (DAnim)this.getSelectedModel(CProperty.SELECTED_ANIM);
    }

    protected CAnimBank getAnimBank() {
        if (this.selAnim != null) {
            return this.selAnim.getSelected();
        }
        return null;
    }

    protected void setMapCell(DMapCell asset) {
        this.selMapCell = asset;
    }

    protected void setMapCellAsset(DMapCell asset) {
        this.setSelectedModel(CProperty.SELECTED_MAP_CELL, Loader.getFormats(50).toArray(), asset);
        this.selMapCell = asset;
    }

    protected void setMapCellBank(int index) {
        this.selMapCell.setSelectedIndex(index);
    }

    protected DMapCell getMapCellAsset() {
        return (DMapCell)this.getSelectedModel(CProperty.SELECTED_MAP_CELL);
    }

    protected CMapCellBank getMapCellBank() {
        if (this.selMapCell != null) {
            return this.selMapCell.getSelected();
        }
        return null;
    }

    protected void setMapAnim(DMapAnim asset) {
        this.selMapAnim = asset;
    }

    protected void setMapAnimAsset(DMapAnim asset) {
        this.setSelectedModel(CProperty.SELECTED_MAP_ANIM, Loader.getFormats(51).toArray(), asset);
        this.selMapAnim = asset;
    }

    protected void setMapAnimBank(int index) {
        this.selMapAnim.setSelectedIndex(index);
    }

    protected DMapAnim getMapAnimAsset() {
        return (DMapAnim)this.getSelectedModel(CProperty.SELECTED_MAP_ANIM);
    }

    protected CAnimBank getMapAnimBank() {
        if (this.selMapAnim != null) {
            return this.selMapAnim.getSelected();
        }
        return null;
    }

    protected void setModel(DModel asset) {
        this.selModel = asset;
    }

    protected void setModelAsset(DModel asset) {
        this.setSelectedModel(CProperty.SELECTED_MODEL, Loader.getFormats(31).toArray(), asset);
        this.selModel = asset;
    }

    protected void setModelBank(int index) {
        this.selModel.setSelectedIndex(index);
    }

    protected DModel getModelAsset() {
        return (DModel)this.getSelectedModel(CProperty.SELECTED_MODEL);
    }

    protected CModel getModelBank() {
        if (this.selModel != null) {
            return this.selModel.getSelected();
        }
        return null;
    }
}

