/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.beans.PropertyChangeEvent;
import util.CAction;
import util.CProperty;
import util.gui.CDesktop;
import util.gui.frames.CFrame;
import util.gui.frames.FGridRender;
import util.struct.DCell;
import util.struct.DFormat;
import util.struct.DGraphic;
import util.struct.DPalette;
import util.struct.graphics.CCellBuffer;

public class CCellFrame
extends CFrame {
    private FGridRender display;
    private boolean toggleAlpha = false;
    private boolean toggleOrder = false;
    private boolean toggleGrid = true;
    private boolean toggleOutline = true;
    private boolean toggleRender = true;
    private CCellBuffer buffer;

    public CCellFrame(DFormat format) {
        super(format);
        this.setCell(this.getFormat());
        this.setTile((DGraphic)this.getAsset(6, null));
        this.setPalette((DPalette)this.getAsset(5, null));
        this.display = new FGridRender();
        this.add(this.display);
        this.getToolBar().addComboBox(CProperty.SELECTED_CELL_INDEX, "Bank:", "Cell Bank");
        this.getToolBar().addComboBox(CProperty.SELECTED_TILE_INDEX, "Image:", "Image Bank");
        this.getToolBar().addComboBox(CProperty.SELECTED_PALETTE_INDEX, "Palette:", "Palette Bank");
        this.getToolBar().addSeparator();
        this.getToolBar().addToggle(2000, CProperty.ALPHA);
        this.getToolBar().addToggle(3001, CProperty.CELL_GRID);
        this.getToolBar().addToggle(3002, CProperty.CELL_OUTLINE);
        this.getToolBar().addToggle(3000, CProperty.CELL_ORDER);
        this.getToolBar().addToggle(3003, CProperty.CELL_RENDER);
    }

    public DCell getFormat() {
        return (DCell)super.getFormat();
    }

    public void setProperties() {
        super.setProperties();
        this.display.centerDisplay();
        boolean renderable = this.getPaletteBank() != null && this.getTileBank() != null;
        CAction.getAction(3003).setEnabled(renderable);
        CProperty.ALPHA.setValue(this.toggleAlpha);
        CProperty.CELL_ORDER.setValue(this.toggleOrder);
        CProperty.CELL_GRID.setValue(this.toggleGrid);
        CProperty.CELL_OUTLINE.setValue(this.toggleOutline);
        CProperty.CELL_RENDER.setValue(this.toggleRender);
        if (this.getCellBank() != null) {
            CDesktop.PANEL_INFO.addModel(this.getCellBank().getModel());
        }
        this.buffer();
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        ignored = true;
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (name.equals(CProperty.ALPHA.getName())) {
            this.toggleAlpha = (Boolean)value;
            this.buffer();
        } else if (name.equals(CProperty.CELL_ORDER.getName())) {
            this.toggleOrder = (Boolean)value;
            this.buffer();
        } else if (name.equals(CProperty.CELL_GRID.getName())) {
            this.toggleGrid = (Boolean)value;
        } else if (name.equals(CProperty.CELL_OUTLINE.getName())) {
            this.toggleOutline = (Boolean)value;
        } else if (name.equals(CProperty.CELL_RENDER.getName())) {
            this.toggleRender = (Boolean)value;
        } else {
            ignored = false;
        }
        super.checkProperty(evt, ignored);
        boolean paletteChange = name.equals(CProperty.SELECTED_PALETTE.getName());
        boolean imageChange = name.equals(CProperty.SELECTED_TILE.getName());
        if (paletteChange || imageChange) {
            this.buffer();
        }
        if (name.equals(CProperty.SELECTED_CELL_INDEX.getName())) {
            CDesktop.PANEL_INFO.setModel(this.getCellBank().getModel());
            this.buffer();
        }
    }

    private boolean isTransparent() {
        return this.toggleAlpha;
    }

    private boolean isReverseOrder() {
        return this.toggleOrder;
    }

    private boolean isGridEnabled() {
        return this.toggleGrid;
    }

    private boolean isOutlineEnabled() {
        return this.toggleOutline;
    }

    private boolean isRenderEnabled() {
        return this.toggleRender;
    }

    public void update() {
        if (this.getCellBank() != null) {
            this.display.update(this.buffer, this.isGridEnabled(), this.isRenderEnabled(), this.isOutlineEnabled());
        }
    }

    private void buffer() {
        if (this.getCellBank() != null) {
            this.buffer = this.getCellBank().getBuffer(this.getPaletteBank(), this.getTileBank(), this.getCellAsset().isSubImage(), this.isTransparent(), this.isReverseOrder());
        }
        this.update();
    }

    public boolean doAction(int action) {
        boolean accept = true;
        switch (action) {
            default: 
        }
        accept = false;
        return accept;
    }
}

