/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import util.gui.CTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTabPane
extends JLayeredPane {
    private Point start;

    public CTabPane() {
        this.setLayout(new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public Dimension preferredLayoutSize(Container parent) {
                return CTabPane.this.getPreferredSize();
            }

            public Dimension minimumLayoutSize(Container parent) {
                return CTabPane.this.getMinimumSize();
            }

            public void layoutContainer(Container parent) {
                ArrayList<CTab> tabs = CTabPane.this.getTabs();
                int selectedTab = CTabPane.this.getSelectedIndex();
                for (int i = 0; i < tabs.size(); ++i) {
                    CTab tab = tabs.get(i);
                    if (i < selectedTab) {
                        CTabPane.this.setComponentZOrder(tab, selectedTab - i);
                        continue;
                    }
                    if (i > selectedTab) {
                        CTabPane.this.setComponentZOrder(tab, i);
                        continue;
                    }
                    CTabPane.this.setComponentZOrder(tab, 0);
                }
                int x = 0;
                for (CTab tab : tabs) {
                    int width = tab.getWidth();
                    if (!tab.isDragging()) {
                        tab.setLocation(x, CTabPane.this.getHeight() - tab.getHeight());
                    }
                    x += width;
                }
            }
        });
    }

    @Override
    public String toString() {
        return "TabPane: " + this.getComponentCount();
    }

    public void dragTabStart(CTab target, Point point) {
        target.setDragging(true);
        this.start = new Point(target.getX() + point.x, target.getY() + point.y);
    }

    public void dragTabStop(CTab target) {
        target.setDragging(false);
        this.doLayout();
    }

    public void dragTab(CTab target, Point point) {
        Point mouse = new Point(target.getX() + point.x, target.getY() + point.y);
        Point diff = new Point(mouse.x - this.start.x, mouse.y - this.start.y);
        int x = target.getX() + diff.x;
        if (x < 0) {
            x = 0;
        }
        if (x + target.getWidth() > this.getTabsWidth()) {
            x = this.getTabsWidth() - target.getWidth();
        }
        target.setLocation(x, target.getY());
        this.start = mouse;
        for (CTab tab : this.getTabs()) {
            boolean after;
            int left = tab.getX();
            int mid = tab.getX() + tab.getWidth() / 2;
            int right = tab.getX() + tab.getWidth();
            if (tab == target) continue;
            int index = target.getIndex();
            boolean before = mouse.x >= left && mouse.x <= mid;
            boolean bl = after = mouse.x >= mid && mouse.x <= right;
            if (!before && !after) continue;
            target.setIndex(tab.getIndex());
            tab.setIndex(index);
            this.doLayout();
        }
    }

    @Override
    public Component add(Component component) {
        component.addMouseMotionListener(new MouseAdapter(){

            public void mouseDragged(MouseEvent e) {
                CTab tab = (CTab)e.getComponent();
                if (tab.isDragging()) {
                    CTabPane.this.dragTab(tab, e.getPoint());
                }
            }
        });
        component.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    CTabPane.this.dragTabStart((CTab)e.getComponent(), e.getPoint());
                }
            }

            public void mouseReleased(MouseEvent e) {
                CTabPane.this.dragTabStop((CTab)e.getComponent());
            }
        });
        return super.add(component);
    }

    public ArrayList<CTab> getTabs() {
        ArrayList<CTab> tabs = new ArrayList<CTab>();
        block0: for (int i = 0; i < this.getComponentCount(); ++i) {
            for (Component component : this.getComponents()) {
                CTab tab = (CTab)component;
                if (tab.getIndex() != i) continue;
                tabs.add(tab);
                continue block0;
            }
        }
        return tabs;
    }

    public int getTabCount() {
        return this.getComponentCount();
    }

    public int getTabsWidth() {
        int width = 0;
        for (CTab tab : this.getTabs()) {
            width += tab.getWidth();
        }
        return width;
    }

    public double getTabsWidthDivider() {
        int width = this.getWidth() - 30;
        if (width >= this.getTabsWidth()) {
            return 1.0;
        }
        return (double)width / (double)this.getTabsWidth();
    }

    public int getSelectedIndex() {
        for (CTab tab : this.getTabs()) {
            if (!tab.isSelected()) continue;
            return tab.getIndex();
        }
        return -1;
    }
}

