/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import util.CImageIcon;
import util.gui.CTabPane;

public class CTab
extends JLayeredPane {
    public static final int OFF = 0;
    public static final int OVER = 1;
    public static final int ON = 2;
    public static final int DRAGGING = 3;
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    public static final int RIGHT = 2;
    private Component target;
    private JLabel label;
    private CloseButton button;
    private int state;
    private int index;
    private boolean buttonEnabled = true;
    private boolean dragging = false;
    private BufferedImage[][] tabGraphics = this.getTabGraphics();

    public CTab(Component parent, Component target) {
        this.target = target;
        Font font = new Font("Tahoma", 0, 10);
        this.label = new JLabel();
        this.label.setFont(font);
        this.label.setForeground(new Color(65, 65, 65));
        this.label.setText(target.getName());
        this.add(this.label);
        this.button = new CloseButton();
        this.add(this.button);
        this.setName(target.getName());
        this.setState(0);
        this.listeners();
    }

    public void doLayout() {
        int width = this.label.getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
        int height = this.tabGraphics[1][0].getHeight();
        if (this.label.getIcon() != null) {
            width += this.label.getIcon().getIconWidth() + this.label.getIconTextGap();
        }
        this.label.setLocation(this.tabGraphics[0][0].getWidth() + 1, 1);
        this.label.setSize(width, height);
        this.button.setLocation(this.label.getX() + this.label.getWidth() + 3, (int)Math.round((double)(this.label.getHeight() - this.button.getHeight()) / 2.0) + 1);
        width += this.tabGraphics[0][0].getWidth() + this.tabGraphics[1][0].getWidth() + this.tabGraphics[2][0].getWidth();
        if (this.button.isVisible()) {
            width += this.button.getWidth();
        }
        this.setSize(width, height);
        this.repaint();
    }

    public BufferedImage[][] getTabGraphics() {
        CImageIcon image = new CImageIcon("group");
        BufferedImage tab_l_off = image.getSubImage(18, 0, 5, 19);
        BufferedImage tab_m_off = image.getSubImage(24, 0, 5, 19);
        BufferedImage tab_r_off = image.getSubImage(30, 0, 5, 19);
        BufferedImage tab_l_over = image.getSubImage(36, 0, 5, 19);
        BufferedImage tab_m_over = image.getSubImage(42, 0, 5, 19);
        BufferedImage tab_r_over = image.getSubImage(48, 0, 5, 19);
        BufferedImage tab_l_on = image.getSubImage(54, 0, 5, 19);
        BufferedImage tab_m_on = image.getSubImage(60, 0, 5, 19);
        BufferedImage tab_r_on = image.getSubImage(66, 0, 5, 19);
        BufferedImage tab_l_drag = image.getSubImage(72, 0, 5, 19);
        BufferedImage tab_m_drag = image.getSubImage(78, 0, 5, 19);
        BufferedImage tab_r_drag = image.getSubImage(84, 0, 5, 19);
        return new BufferedImage[][]{{tab_l_off, tab_l_over, tab_l_on, tab_l_drag}, {tab_m_off, tab_m_over, tab_m_on, tab_m_drag}, {tab_r_off, tab_r_over, tab_r_on, tab_r_drag}};
    }

    public CTab getThis() {
        return this;
    }

    public String toString() {
        return "Tab: " + this.getName();
    }

    public void listeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (CTab.this.state != 2) {
                    CTab.this.setState(1);
                }
            }

            public void mouseReleased(MouseEvent e) {
                CTab.this.setDragging(false);
                CTab.this.setState(CTab.this.getState());
            }

            public void mouseExited(MouseEvent e) {
                if (CTab.this.state != 2) {
                    CTab.this.setState(0);
                }
            }
        });
        this.getTarget().addPropertyChangeListener("index", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CTab.this.setIndex((Integer)evt.getNewValue());
            }
        });
    }

    public void setState(int state) {
        this.state = state;
        this.button.setVisible(state == 2 && this.buttonEnabled);
        this.doLayout();
    }

    public void setIcon(Icon icon) {
        this.getLabel().setIcon(icon);
    }

    public void setButtonEnabled(boolean buttonEnabled) {
        this.buttonEnabled = buttonEnabled;
    }

    public int getState() {
        return this.state;
    }

    public Component getTarget() {
        return this.target;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isSelected() {
        return this.state == 2;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public CTabPane getParent() {
        return (CTabPane)super.getParent();
    }

    public final JLabel getLabel() {
        return this.label;
    }

    public final CloseButton getButton() {
        return this.button;
    }

    public void paintComponent(Graphics g) {
        int state = this.getState();
        if (this.isDragging()) {
            state = 3;
        }
        g.drawImage(this.tabGraphics[0][state], 0, 0, null);
        g.drawImage(this.tabGraphics[1][state], this.tabGraphics[0][state].getWidth(), 0, this.getWidth() - this.tabGraphics[0][state].getWidth() - this.tabGraphics[2][state].getWidth(), this.tabGraphics[1][state].getHeight(), null);
        g.drawImage(this.tabGraphics[2][state], this.getWidth() - this.tabGraphics[2][state].getWidth(), 0, null);
    }

    public class CloseButton
    extends AbstractButton {
        private CImageIcon image = new CImageIcon("group_icons");
        private BufferedImage close_off = this.image.getSubImage(0, 0, 7, 7);
        private BufferedImage close_on = this.image.getSubImage(8, 0, 7, 7);
        private boolean over = false;

        public CloseButton() {
            this.setSize(11, 11);
            this.setFocusable(false);
            this.setIcon(new ImageIcon(this.close_off));
            this.setRolloverIcon(new ImageIcon(this.close_on));
            this.setRolloverEnabled(false);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    CTab.this.target.setEnabled(false);
                }

                public void mouseEntered(MouseEvent e) {
                    CloseButton.this.over = true;
                    CloseButton.this.repaint();
                }

                public void mouseExited(MouseEvent e) {
                    CloseButton.this.over = false;
                    CloseButton.this.repaint();
                }
            });
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.over) {
                g2.setColor(new Color(172, 172, 172));
                g2.draw(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 4.0f, 4.0f));
                this.getRolloverIcon().paintIcon(this, g2, this.getInsets().left, this.getInsets().top);
            } else {
                this.getIcon().paintIcon(this, g2, this.getInsets().left, this.getInsets().top);
            }
        }
    }
}

