/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import util.gui.CDesktop;
import util.gui.CDock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPanelBox
extends JLayeredPane {
    public static final int FLOAT = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 4;

    private CDesktop getDesktop() {
        return (CDesktop)this.getParent();
    }

    public CDock getDock(int dock, int bar) {
        for (Component component : this.getComponents()) {
            CDock target = (CDock)component;
            if (target.getDock() != dock || target.getBar() != bar) continue;
            return target;
        }
        CDock target = new CDock(dock, bar);
        DropTarget dropTarget = new DropTarget(target, 2, this.getDesktop().getDragDrop());
        this.add(target);
        this.doLayout();
        return target;
    }

    public ArrayList<CDock> getDocks(int dock) {
        ArrayList<CDock> results = new ArrayList<CDock>();
        for (Component component : this.getComponents()) {
            CDock target = (CDock)component;
            if (target.getDock() != dock) continue;
            results.add(target);
        }
        return results;
    }

    @Override
    public void doLayout() {
        int left = 0;
        for (CDock dock : this.getDocks(2)) {
            Dimension size = dock.getMinimumSize();
            dock.setBounds(left, 0, size.width, this.getHeight());
            dock.doLayout();
            left += dock.getWidth();
        }
        int right = 0;
        for (CDock dock : this.getDocks(3)) {
            Dimension size = dock.getMinimumSize();
            dock.setBounds(this.getWidth() - right - size.width, 0, size.width, this.getHeight());
            dock.doLayout();
            right += dock.getWidth();
        }
        int top = 0;
        for (CDock dock : this.getDocks(1)) {
            Dimension size = dock.getMinimumSize();
            dock.setBounds(left, top, this.getWidth() - left - right, size.height);
            dock.doLayout();
            top += dock.getHeight();
        }
        int bottom = 0;
        for (CDock dock : this.getDocks(4)) {
            Dimension size = dock.getMinimumSize();
            dock.setBounds(left, this.getHeight() - bottom - size.height, this.getWidth() - left - right, size.height);
            dock.doLayout();
            bottom += dock.getHeight();
        }
        this.getDesktop().getFrameBox().setBounds(this.getX() + left, this.getY() + top, this.getWidth() - left - right, this.getHeight() - top - bottom);
        this.getDesktop().getFrameBox().doLayout();
    }

    public Rectangle getLeftBounds() {
        int width = 0;
        for (CDock dock : this.getDocks(2)) {
            width += dock.getWidth();
        }
        return new Rectangle(0, 0, width, this.getHeight());
    }

    public Rectangle getRightBounds() {
        int width = 0;
        for (CDock dock : this.getDocks(3)) {
            width += dock.getWidth();
        }
        return new Rectangle(this.getWidth() - width, 0, width, this.getHeight());
    }

    public Rectangle getTopBounds() {
        Rectangle left = this.getLeftBounds();
        Rectangle right = this.getRightBounds();
        int height = 0;
        for (CDock dock : this.getDocks(1)) {
            height += dock.getHeight();
        }
        return new Rectangle(left.width, 0, this.getWidth() - left.width - right.width, height);
    }

    public Rectangle getBottomBounds() {
        Rectangle left = this.getLeftBounds();
        Rectangle right = this.getRightBounds();
        int height = 0;
        for (CDock dock : this.getDocks(4)) {
            height += dock.getHeight();
        }
        return new Rectangle(left.width, this.getHeight() - height, this.getWidth() - left.width - right.width, height);
    }

    public int getNextTopBar() {
        return this.getNextBar(1);
    }

    public int getNextBottomBar() {
        return this.getNextBar(4);
    }

    public int getNextLeftBar() {
        return this.getNextBar(2);
    }

    public int getNextRightBar() {
        return this.getNextBar(3);
    }

    private int getNextBar(int dockId) {
        int bar = 0;
        for (CDock dock : this.getDocks(dockId)) {
            if (dock.getBar() <= bar) continue;
            bar = dock.getBar();
        }
        return bar + 1;
    }
}

