/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import util.CIcon;

public class COptionPane
extends JDialog {
    public static final int SINGLE = 0;
    public static final int MULTIPLE = 1;
    public static final int WIN_WIDTH = 300;
    private CContentPane contentPane;
    private CFooterPane footerPane;
    private JCheckBox checkBox;
    private int option;
    private int optionCount;

    public COptionPane(int optionType) {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(320, 320);
        this.setLocation((size.width - this.getWidth()) / 2, (size.height - this.getHeight()) / 2);
        this.setIconImage(CIcon.FILE_ROOT.getImage());
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.contentPane = new CContentPane();
        this.add(this.contentPane);
        this.footerPane = new CFooterPane();
        JPanel optionPane = new JPanel();
        optionPane.setLayout(new FlowLayout(2, 10, 0));
        this.footerPane.add(optionPane);
        this.checkBox = new JCheckBox("Do this for all conflicts");
        this.checkBox.setFocusable(false);
        if (optionType == 1) {
            this.footerPane.add((Component)this.checkBox, "West");
        }
        optionPane.add(new CFooterButton("Cancel", 0));
        this.add((Component)this.footerPane, "South");
    }

    public void setContent(String message, String[] options) {
        this.contentPane.setContent(message, options);
    }

    public static int showDialog(String message, String title, String[] options, int optionType) {
        COptionPane pane = new COptionPane(optionType);
        pane.setTitle(title);
        pane.setContent(message, options);
        pane.setVisible(true);
        int result = pane.getOption();
        if (pane.isChecked()) {
            result |= 0x10;
        }
        return result;
    }

    public void setOption(int option) {
        this.option = option;
    }

    public int getOption() {
        return this.option;
    }

    public boolean isChecked() {
        return this.checkBox.isSelected();
    }

    private class CFooterButton
    extends JButton {
        public static final int CANCEL = 0;
        public static final int SKIP = 1;
        private int action;

        public CFooterButton(String text, int buttonAction) {
            this.action = buttonAction;
            this.setText(text);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    switch (CFooterButton.this.action) {
                        case 0: {
                            COptionPane.this.dispose();
                            break;
                        }
                        case 1: {
                            COptionPane.this.setOption(COptionPane.this.optionCount + 1);
                            COptionPane.this.dispose();
                        }
                    }
                }
            });
        }

        public void setSize(int width, int height) {
            super.setSize(width, this.getParent().getHeight());
        }

        public void setLocation(int x, int y) {
            super.setLocation(x, 0);
        }
    }

    private class CFooterPane
    extends JPanel {
        private static final int PADDING = 7;

        public CFooterPane() {
            this.setBackground(new Color(240, 240, 240));
            this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            this.setPreferredSize(new Dimension(0, 40));
            this.setLayout(new BorderLayout());
        }

        public void paintComponent(Graphics g) {
            g.setColor(new Color(240, 240, 240));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(new Color(223, 223, 223));
            g.drawLine(0, 0, this.getWidth(), 0);
        }
    }

    private class CContentButton
    extends JButton {
        private int action;

        public CContentButton(String text, int actionId) {
            this.action = actionId;
            this.setPreferredSize(new Dimension(0, 40));
            this.setFocusable(false);
            this.setText(text);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    COptionPane.this.setOption(CContentButton.this.action);
                    COptionPane.this.dispose();
                }
            });
        }
    }

    private class CContentPane
    extends JPanel {
        public CContentPane() {
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        public void doLayout() {
            int y = 0;
            for (Component child : this.getComponents()) {
                child.setBounds(this.getInsets().left, this.getInsets().top + y, this.getWidth() - this.getInsets().left - this.getInsets().right, child.getPreferredSize().height);
                y += child.getPreferredSize().height + 5;
            }
        }

        public void setContent(String message, String[] options) {
            this.removeAll();
            COptionPane.this.optionCount = options.length;
            for (String line : message.split("\n")) {
                JLabel label = new JLabel(line);
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                this.add(label);
            }
            for (int i = 0; i < options.length; ++i) {
                CContentButton button = new CContentButton(options[i], i + 1);
                this.add(button);
            }
            int height = 0;
            for (Component comp : this.getComponents()) {
                height += comp.getPreferredSize().height + 10;
            }
            this.setPreferredSize(new Dimension(300, height));
            this.revalidate();
            COptionPane.this.pack();
        }
    }
}

