/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import ctool.Loader;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import util.Plugin;
import util.TFileFilter;
import util.TFileView;
import util.struct.DFormat;
import util.struct.DPath;

public class CFileChooser
extends JFileChooser {
    public static final int OPEN = 0;
    public static final int EXPORT = 1;
    private File selectedFile;
    private DFormat format;
    private int mode;

    public CFileChooser(int mode, DFormat format) {
        DPath path;
        this.mode = mode;
        this.format = format;
        this.setFileView(new TFileView());
        if (this.getFormat() != null && (path = this.getFormat().getPath()).getParentName() != null) {
            this.selectedFile = new File(path.getParentName() + "\\" + path.getFile().getFullName());
            File file = new File(path.getParentName());
            this.setCurrentDirectory(file);
            this.setSelectedFile(this.selectedFile);
        }
        switch (mode) {
            case 0: {
                this.setOpenChooser();
                break;
            }
            case 1: {
                this.setExportChooser();
            }
        }
    }

    private DFormat getFormat() {
        return this.format;
    }

    private void setOpenChooser() {
        this.setDialogTitle("Open...");
        this.addFilter(this, "Archives", 3);
        this.addFilter(this, "Palettes", 5);
        this.addFilter(this, "Tiled Images", 6);
        this.addFilter(this, "Maps", 9);
        this.addFilter(this, "Sprites", 7);
        this.addFilter(this, "Sprite Animations", 8);
        for (Plugin plugin : Plugin.getPlugins()) {
            TFileFilter filter = new TFileFilter(plugin);
            this.addChoosableFileFilter(filter);
            if (this.getFormat() == null || !plugin.getId().equals(this.getFormat().getPath().getPlugin().getId())) continue;
            this.setFileFilter(filter);
        }
        this.setFileFilter(this.getAcceptAllFileFilter());
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
                    CFileChooser.this.selectedFile = (File)evt.getNewValue();
                }
            }
        });
    }

    private void setExportChooser() {
        this.setDialogTitle("Export As...");
        this.setAcceptAllFileFilterUsed(false);
        TFileFilter selFilter = null;
        for (Plugin plugin : this.getFormat().getPlugins()) {
            TFileFilter filter = new TFileFilter(plugin);
            this.addChoosableFileFilter(filter);
            if (!plugin.getId().equals(this.getFormat().getPath().getPlugin().getId())) continue;
            selFilter = filter;
        }
        this.setFileFilter(selFilter);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JFileChooser dialog;
                if (evt.getPropertyName().equals("SelectedFileChangedProperty") && evt.getNewValue() != null) {
                    CFileChooser.this.selectedFile = (File)evt.getNewValue();
                }
                if (evt.getPropertyName().equals("directoryChanged")) {
                    dialog = (JFileChooser)evt.getSource();
                    CFileChooser.this.selectedFile = new File(dialog.getCurrentDirectory().getPath() + "\\" + CFileChooser.this.selectedFile.getName());
                    dialog.setSelectedFile(CFileChooser.this.selectedFile);
                }
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    dialog = (JFileChooser)evt.getSource();
                    String filePath = CFileChooser.this.selectedFile.getPath();
                    for (Plugin plugin : ((TFileFilter)evt.getOldValue()).getPlugins()) {
                        for (String ext : plugin.getExtensions()) {
                            if (!filePath.endsWith(ext)) continue;
                            filePath = filePath.substring(0, filePath.lastIndexOf(ext));
                        }
                    }
                    filePath = filePath + ((TFileFilter)evt.getNewValue()).getPlugins().get(0).getExtensions()[0];
                    dialog.setSelectedFile(new File(filePath));
                }
            }
        });
    }

    public boolean showChooser() {
        boolean save = false;
        switch (this.mode) {
            case 0: {
                if (this.showOpenDialog(this) != 0 || !this.selectedFile.exists()) break;
                Loader.add(this.selectedFile);
                break;
            }
            case 1: {
                boolean bl = save = this.showSaveDialog(this) == 0;
                if (!save || !this.getSelectedFile().exists()) break;
                save = JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite this file?", "Console Tool", 0) == 0;
            }
        }
        return save;
    }

    private void addFilter(JFileChooser dialog, String name, int format) {
        dialog.addChoosableFileFilter(new TFileFilter(name, Plugin.get(format)));
    }
}

