/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import ctool.Loader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import util.Common;
import util.gui.CDesktop;
import util.gui.CDock;
import util.gui.CDragBox;
import util.gui.CGroup;
import util.gui.CPanelBox;
import util.gui.CTab;
import util.gui.CTabPane;
import util.gui.panels.CPanel;

public class CDragDrop
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
Transferable {
    private Object object;
    private CDesktop desktop;
    private int dockId;
    private int barId;
    private int index;
    private int groupId;
    private int mode;
    private Point startMouse;

    public CDragDrop(CDesktop desktop) {
        this.desktop = desktop;
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        if (((MouseEvent)e.getTriggerEvent()).getButton() == 1) {
            this.startMouse = e.getDragOrigin();
            e.startDrag(null, this, this);
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
        this.object = e.getSource();
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        this.dropTargetDrag(e);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
        this.dropTargetDrag(e);
    }

    public void dragExit(DropTargetEvent e) {
        this.desktop.getDragBox().hideDrag();
    }

    private void dropTargetDrag(DropTargetDragEvent e) {
        boolean accept = false;
        Transferable t = e.getTransferable();
        accept = this.getFileList(t) != null ? true : this.dropObjectDrag(e);
        if (accept) {
            e.acceptDrag(e.getDropAction());
        } else {
            e.rejectDrag();
        }
    }

    private boolean dropObjectDrag(DropTargetDragEvent e) {
        boolean accept = false;
        Point mouse = e.getLocation();
        Component target = ((DropTarget)e.getSource()).getComponent();
        CDragBox dragBox = this.desktop.getDragBox();
        Component component = this.getComponent(e.getTransferable());
        if (target instanceof CDesktop) {
            accept = this.dropDesktopDrag(e);
        } else if (target instanceof CDock) {
            accept = this.dropDockDrag(e);
        } else if (target instanceof CGroup) {
            accept = this.dropGroupDrag(e);
        } else {
            Common.msg("Unknown " + target);
            accept = false;
        }
        if (!accept) {
            dragBox.hideDrag();
        }
        return accept;
    }

    private boolean dropDesktopDrag(DropTargetDragEvent e) {
        boolean accept = true;
        Point mouse = e.getLocation();
        Component target = ((DropTarget)e.getSource()).getComponent();
        CDragBox dragBox = this.desktop.getDragBox();
        Component component = this.getComponent(e.getTransferable());
        CPanelBox groupBox = this.desktop.getPanelBox();
        int x = groupBox.getX();
        int y = groupBox.getY();
        mouse = new Point(mouse.x, mouse.y);
        Rectangle top = groupBox.getTopBounds();
        Rectangle bottom = groupBox.getBottomBounds();
        Rectangle left = groupBox.getLeftBounds();
        Rectangle right = groupBox.getRightBounds();
        Rectangle topDock = new Rectangle(x + top.x, y + top.height, top.width, 25);
        Rectangle bottomDock = new Rectangle(x + bottom.x, y + bottom.y - 25, bottom.width, 25);
        Rectangle leftDock = new Rectangle(x + left.width, y + top.height, 25, left.height - top.height - bottom.height);
        Rectangle rightDock = new Rectangle(x + right.x - 25, y + top.height, 25, right.height - top.height - bottom.height);
        this.index = 0;
        boolean check = true;
        int oldDock = -1;
        if (component instanceof CGroup) {
            check = ((CGroup)component).getParentDock().getComponentCount() > 1;
            oldDock = ((CGroup)component).getDock();
        }
        if (topDock.contains(mouse)) {
            dragBox.showDrag(1, topDock);
            this.dockId = 1;
            this.barId = groupBox.getNextTopBar();
        } else if (bottomDock.contains(mouse)) {
            dragBox.showDrag(4, bottomDock);
            this.dockId = 4;
            this.barId = groupBox.getNextBottomBar();
        } else if (leftDock.contains(mouse) && (check || oldDock != 2)) {
            dragBox.showDrag(2, leftDock);
            this.dockId = 2;
            this.barId = groupBox.getNextLeftBar();
        } else if (rightDock.contains(mouse) && (check || oldDock != 3)) {
            dragBox.showDrag(3, rightDock);
            this.dockId = 3;
            this.barId = groupBox.getNextRightBar();
        } else {
            accept = false;
        }
        return accept;
    }

    private boolean dropDockDrag(DropTargetDragEvent e) {
        CTab tab;
        boolean accept = false;
        Point mouse = e.getLocation();
        Component target = ((DropTarget)e.getSource()).getComponent();
        CDragBox dragBox = this.desktop.getDragBox();
        Component component = this.getComponent(e.getTransferable());
        CDock dock = (CDock)target;
        this.dockId = dock.getDock();
        this.barId = dock.getBar();
        this.index = dock.getNextGroup();
        int dockX = dock.getParent().getX() + dock.getX();
        int dockY = dock.getParent().getY() + dock.getY();
        if (component instanceof CTab && (tab = (CTab)component).getTarget() instanceof CPanel) {
            CPanel panel = (CPanel)tab.getTarget();
            this.groupId = panel.getParentDock().getNextGroup();
        }
        for (int i = 0; i < dock.getGroups().size(); ++i) {
            CGroup group = dock.getGroups().get(i);
            Rectangle rectTop = new Rectangle(group.getX(), group.getY() - 10, group.getWidth(), 10);
            Rectangle rectBottom = new Rectangle(rectTop.x, group.getY() + group.getHeight(), group.getWidth(), 30);
            if (rectTop.contains(mouse)) {
                this.index = i;
                accept = true;
                this.mode = 13;
                if (i == 0) {
                    this.mode = 11;
                }
                dragBox.showDrag(this.mode, new Rectangle(rectTop.x + dockX, rectTop.y + dockY, rectTop.width, rectTop.height));
                continue;
            }
            if (i + 1 != dock.getGroups().size() || !rectBottom.contains(mouse) || !dock.isSide()) continue;
            this.index = i + 1;
            accept = true;
            dragBox.showDrag(12, new Rectangle(rectBottom.x + dockX, rectBottom.y + dockY, rectBottom.width, rectBottom.height));
        }
        return accept;
    }

    private boolean dropGroupDrag(DropTargetDragEvent e) {
        boolean show;
        boolean accept = true;
        Point mouse = e.getLocation();
        Component target = ((DropTarget)e.getSource()).getComponent();
        CDragBox dragBox = this.desktop.getDragBox();
        Component component = this.getComponent(e.getTransferable());
        CGroup group = (CGroup)target;
        CDock dock = group.getParentDock();
        this.dockId = group.getDock();
        this.barId = group.getBar();
        this.groupId = group.getGroup();
        int dockX = dock.getParent().getX() + dock.getX();
        int dockY = dock.getParent().getY() + dock.getY();
        Rectangle rect = group.getBounds();
        rect.x += dockX;
        rect.y += dockY;
        Rectangle rectTop = new Rectangle(0, 0, group.getWidth(), 10);
        CTabPane tabPane = group.getTabPane();
        boolean bl = show = component != null;
        if (component instanceof CTab) {
            CTab tab = (CTab)component;
            if (tab.getParent() == tabPane) {
                if (tabPane.getBounds().contains(mouse) && tab.isDragging() && tabPane.getTabCount() > 1) {
                    show = false;
                    tabPane.dragTab(tab, new Point(mouse.x - tabPane.getX() - tab.getX(), mouse.y - tabPane.getY() - tab.getY()));
                } else {
                    tab.setDragging(false);
                    tab.getParent().dragTabStop(tab);
                }
            } else {
                tab.setDragging(false);
            }
        }
        if (show) {
            if (rectTop.contains(mouse)) {
                this.index = dock.getComponentZOrder(group);
                this.groupId = dock.getNextGroup();
                this.mode = 13;
                if (this.index == 0) {
                    this.mode = 11;
                }
                Rectangle dragRectTop = new Rectangle(rectTop.x + group.getX() + dockX, rectTop.y + group.getY() + dockY - 10, rectTop.width, rectTop.height);
                dragBox.showDrag(this.mode, dragRectTop);
            } else {
                dragBox.showDrag(10, rect);
            }
        } else {
            dragBox.hideDrag();
        }
        return accept;
    }

    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(e.getDropAction());
        if (this.getFileList(e.getTransferable()) != null) {
            Iterator iter = this.getFileList(e.getTransferable()).iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                Loader.add(file, !iter.hasNext());
            }
        } else {
            this.dropObject(e);
        }
        e.dropComplete(true);
    }

    private void dropObject(DropTargetDropEvent e) {
        this.desktop.getDragBox().hideDrag();
        Component component = this.getComponent(e.getTransferable());
        if (component != null) {
            Container oldParent = component.getParent();
            Component newParent = ((DropTarget)e.getSource()).getComponent();
            CDock dock = this.desktop.getPanelBox().getDock(this.dockId, this.barId);
            if (component instanceof CGroup) {
                boolean check;
                CGroup group = (CGroup)component;
                boolean bl = check = this.mode != 11 && this.mode != 13;
                if (newParent instanceof CGroup && !check) {
                    CGroup newGroup = (CGroup)newParent;
                    if (group != newGroup) {
                        Object[] panels = group.getPanels().toArray();
                        CPanel selectPanel = (CPanel)panels[0];
                        for (Object panelObject : panels) {
                            CPanel panel = (CPanel)panelObject;
                            panel.setSize(panel.getPanelSize());
                            group.removePanel(panel);
                            newGroup.addPanel(panel);
                        }
                        newGroup.setSelected(selectPanel);
                    }
                } else {
                    group.setDock(this.dockId);
                    group.setBar(this.barId);
                    if (dock != oldParent) {
                        dock.addGroup(group, this.index);
                        CPanel selectPanel = group.getSelected();
                        selectPanel.setSize(selectPanel.getPanelSize());
                        group.setSize(group.getMinimumSize());
                    }
                }
            } else if (component instanceof CTab) {
                CTab tab = (CTab)component;
                if (!tab.isDragging()) {
                    CPanel panel = (CPanel)tab.getTarget();
                    CGroup group = dock.getGroup(this.groupId);
                    CGroup oldGroup = panel.getParentGroup();
                    if (dock.getGroupCount() > 1 && group.getPanelCount() == 0) {
                        dock.moveTo(group, this.index);
                    }
                    if (group != oldGroup) {
                        panel.setSize(panel.getPanelSize());
                        group.addPanel(panel);
                        group.setSelected(panel);
                    }
                } else {
                    tab.getParent().dragTabStop(tab);
                }
            }
            this.desktop.doLayout();
        } else {
            Common.msg("Not a Component!!");
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] supportedFlavors = new DataFlavor[2];
        try {
            supportedFlavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref"), DataFlavor.javaFileListFlavor};
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return supportedFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int i$ = 0;
        DataFlavor[] arr$ = this.getTransferDataFlavors();
        int len$ = arr$.length;
        if (i$ < len$) {
            DataFlavor dataFlavor = arr$[i$];
            return flavor.isMimeTypeEqual(dataFlavor);
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) {
        if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) {
            return this.object;
        }
        return null;
    }

    public List getFileList(Transferable t) {
        try {
            Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
            return (List)data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Component getComponent(Transferable t) {
        try {
            DataFlavor flavor = new DataFlavor("application/x-java-jvm-local-objectref");
            DragSourceContext source = (DragSourceContext)t.getTransferData(flavor);
            if (source != null) {
                return source.getTrigger().getComponent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

