/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import ctool.CWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import util.CProperty;
import util.gui.CDock;
import util.gui.CDragBox;
import util.gui.CDragDrop;
import util.gui.CFrameBox;
import util.gui.CPanelBox;
import util.gui.CToolBar;
import util.gui.CToolBox;
import util.gui.frames.CFrame;
import util.gui.panels.CColorPanel;
import util.gui.panels.CFramesPanel;
import util.gui.panels.CInfoPanel;
import util.gui.panels.CPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDesktop
extends JLayeredPane {
    private final int baseSize = 20;
    private int baseLeft = 20;
    private Point selPos = new Point(this.baseLeft, 20);
    private CWindow window;
    private CToolBox toolBox;
    private CPanelBox panelBox;
    private CFrameBox frameBox;
    private CDragDrop dragDrop;
    private DragSource dragSource;
    private CDragBox dragBox;
    private boolean opened;
    private boolean resizing = false;
    private ArrayList<CPanel> panels = new ArrayList();
    public static final int FLOAT = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 4;
    public static final CToolBar TOOL_MAIN = new CToolBar(1);
    public static final CFramesPanel PANEL_FRAMES = new CFramesPanel("Frames", 4);
    public static final CInfoPanel PANEL_INFO = new CInfoPanel("Info", 3);
    public static final CColorPanel PANEL_COLOR = new CColorPanel("Color", 3);

    public CDesktop(CWindow window) {
        this.window = window;
        this.setOpaque(true);
        this.setBackground(new Color(137, 140, 149));
        this.toolBox = new CToolBox();
        this.panelBox = new CPanelBox();
        this.frameBox = new CFrameBox();
        this.dragDrop = new CDragDrop(this);
        this.dragSource = new DragSource();
        this.dragBox = new CDragBox(this);
        DropTarget dropTarget = new DropTarget(this, 2, this.getDragDrop());
        this.add(this.dragBox);
        this.add(this.frameBox);
        this.add(this.toolBox);
        this.add(this.panelBox);
        this.initComponents();
        this.setLayout(new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(20, 20);
            }

            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(20, 20);
            }

            public void layoutContainer(Container parent) {
                CDesktop.this.dragBox.setBounds(0, 0, CDesktop.this.getWidth(), CDesktop.this.getHeight());
                CDesktop.this.toolBox.setBounds(0, 0, CDesktop.this.getWidth(), CDesktop.this.getHeight());
                CDesktop.this.toolBox.doLayout();
                CDesktop.this.repaint();
                CDesktop.this.getWindow().saveSettings();
            }
        });
    }

    public CWindow getWindow() {
        return this.window;
    }

    public CToolBox getToolBox() {
        return this.toolBox;
    }

    public CPanelBox getPanelBox() {
        return this.panelBox;
    }

    public CFrameBox getFrameBox() {
        return this.frameBox;
    }

    public CDragDrop getDragDrop() {
        return this.dragDrop;
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public CDragBox getDragBox() {
        return this.dragBox;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.getWindow().setCursor(cursor);
    }

    public void setResizing(boolean resizing) {
        this.resizing = resizing;
        if (!resizing) {
            this.setCursor(null);
        }
    }

    public boolean isResizing() {
        return this.resizing;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
        this.doLayout();
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void addTool(CToolBar tool) {
        this.toolBox.addTool(tool);
    }

    public void addPanel(CPanel panel) {
        this.panels.add(panel);
        CDock dock = this.panelBox.getDock(panel.getDock(), panel.getBar());
        dock.getGroup(panel.getGroup()).addPanel(panel);
    }

    public void addFrame(CFrame frame, boolean selected) {
        this.frameBox.addFrame(frame, selected);
    }

    public CPanel getPanel(String name) {
        for (CPanel panel : this.panels) {
            if (!panel.getName().equals(name)) continue;
            return panel;
        }
        return null;
    }

    public ArrayList<CPanel> getPanels() {
        return this.panels;
    }

    public void initComponents() {
        TOOL_MAIN.addButton(19);
        TOOL_MAIN.addButton(20);
        TOOL_MAIN.addButton(21);
        TOOL_MAIN.addButton(22);
        TOOL_MAIN.addButton(23);
        TOOL_MAIN.addSeparator();
        TOOL_MAIN.addButton(24);
        this.addTool(TOOL_MAIN);
        PANEL_FRAMES.setProperty(CProperty.TOGGLE_FRAMES);
        this.addPanel(PANEL_FRAMES);
        PANEL_INFO.setProperty(CProperty.TOGGLE_INFO);
        this.addPanel(PANEL_INFO);
        PANEL_COLOR.setProperty(CProperty.TOGGLE_COLOR);
        this.addPanel(PANEL_COLOR);
    }
}

