/*
 * Decompiled with CFR 0.152.
 */
package util;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextFilter
extends PlainDocument {
    public static final String NUMERIC = "0123456789";
    public static final String FLOAT = "0123456789.";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String ALPHA_NUMERIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final String HEXIDECIMAL = "0123456789ABCDEF";
    private String filter;
    private int maxLength;

    public TextFilter() {
        this(ALPHA_NUMERIC);
    }

    public TextFilter(String filter) {
        this(filter, 0, false);
    }

    public TextFilter(String filter, int maxLength) {
        this(filter, maxLength, false);
    }

    public TextFilter(String filter, int maxLength, boolean negativeAccepted) {
        this.filter = filter;
        this.maxLength = maxLength;
        this.setNegativeAccepted(negativeAccepted);
    }

    public String getFilter() {
        return this.filter;
    }

    public void setNegativeAccepted(boolean negativeAccepted) {
        if (this.filter.equals(NUMERIC) || this.filter.equals(FLOAT)) {
            if (negativeAccepted) {
                this.filter = this.filter + "-";
            }
        } else {
            this.filter.replaceAll("-", "");
        }
    }

    public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
        if (string == null) {
            return;
        }
        if (this.filter.equals(UPPERCASE) || this.filter.equals(HEXIDECIMAL)) {
            string = string.toUpperCase();
        } else if (this.filter.equals(LOWERCASE)) {
            string = string.toLowerCase();
        }
        String parse = string;
        string = "";
        for (char charAt : parse.toCharArray()) {
            if (this.filter.indexOf(charAt) == -1) continue;
            string = string + charAt;
        }
        if (this.filter.equals(NUMERIC) || this.filter.equals("0123456789-")) {
            string = this.getText(0, this.getLength()) + string;
            if (string.length() > 0) {
                string = "" + Integer.parseInt(string);
            }
            this.remove(0, this.getLength());
            offset = 0;
        }
        if (this.filter.equals(FLOAT) || this.filter.equals("0123456789.-")) {
            string = this.getText(0, this.getLength()) + string;
            if (string.length() > 0) {
                string = "" + Float.parseFloat(string);
            }
            this.remove(0, this.getLength());
            offset = 0;
        }
        if (string.length() + this.getLength() > this.maxLength && this.maxLength > 0) {
            string = string.substring(0, this.maxLength - this.getLength());
        }
        super.insertString(offset, string, attr);
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
    }
}

