/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import util.Common;

public class Settings
extends Properties {
    private static Settings props = new Settings();
    private static String propsPath = "settings.ini";
    private static boolean loadedState = false;

    public synchronized Enumeration keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList);
        return keyList.elements();
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, "" + value);
    }

    public String getProperty(String key, Object defaultValue) {
        return super.getProperty(key, "" + defaultValue);
    }

    public static Settings getInstance() {
        return props;
    }

    public static boolean isLoaded() {
        return loadedState;
    }

    public static void setLoaded(boolean loaded) {
        loadedState = loaded;
    }

    public static void loadSettings() {
        try {
            props.load(new FileInputStream(propsPath));
        }
        catch (IOException ex) {
            Settings.writeSettings();
        }
    }

    public static String loadSetting(String key, Object defaultValue) {
        key = Common.trimName(key);
        return props.getProperty(key, "" + defaultValue);
    }

    public static int loadInteger(String key, int defaultValue) {
        return Common.getInt(Settings.loadSetting(key, defaultValue));
    }

    public static boolean loadBoolean(String key, boolean defaultValue) {
        return Common.getBoolean(Settings.loadSetting(key, defaultValue));
    }

    public static void saveSetting(String key, Object value) {
        key = Common.trimName(key);
        if (Settings.isLoaded() && !Settings.loadSetting(key, null).equals("" + value)) {
            props.setProperty(key, value);
            Settings.writeSettings();
        }
    }

    public static void writeSettings() {
        try {
            props.store(new FileOutputStream(propsPath), "Saved Settings");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

