/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class CClipboard {
    public static void setImage(BufferedImage image) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(image), null);
    }

    private static class ImageSelection
    implements Transferable {
        private BufferedImage bufferedImage;
        private DataFlavor dataFlavor = DataFlavor.imageFlavor;

        public ImageSelection(BufferedImage image) {
            this.bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g = (Graphics2D)this.bufferedImage.getGraphics();
            g.setColor(new Color(255, 255, 255));
            g.fillRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
            g.drawImage((Image)image, 0, 0, null);
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] data = new DataFlavor[]{this.dataFlavor};
            return data;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.dataFlavor.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.bufferedImage;
        }
    }
}

