/*
 * Decompiled with CFR 0.152.
 */
package dsareditor;

import dsareditor.Code;
import dsareditor.CodeList;
import dsareditor.EditCodePanel;
import dsareditor.EditFolderPanel;
import dsareditor.EditGamePanel;
import dsareditor.EmptyPanel;
import dsareditor.Folder;
import dsareditor.Game;
import dsareditor.GameIDCalc;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Scanner;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdesktop.layout.GroupLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GameEdit
extends JFrame {
    private CodeList masterList = new CodeList();
    private DefaultTreeModel treemodel;
    private Component lastpanel;
    private File openfile;
    private File lastfile;
    private final String swversion = "1.0 final";
    private JScrollPane jScrollPane1;
    private JSplitPane jspVertSplit;
    private JMenuBar mnuBar;
    private JMenu mnuCodeList;
    private JMenuItem mnuExportSubscr;
    private JMenu mnuFile;
    private JMenuItem mnuFileExit;
    private JMenu mnuFileExport;
    private JMenuItem mnuFileNew;
    private JMenuItem mnuFileOpen;
    private JMenuItem mnuFileSave;
    private JMenuItem mnuFileSaveAs;
    private JSeparator mnuFileSep;
    private JMenuItem mnuListAddCode;
    private JMenuItem mnuListAddFolder;
    private JMenuItem mnuListAddGame;
    private JMenuItem mnuListDupe;
    private JMenuItem mnuListRemove;
    private JSeparator mnuListSep1;
    private JSeparator mnuListSep2;
    private JMenu mnuTools;
    private JMenuItem mnuToolsAbout;
    private JMenuItem mnuToolsGameID;
    private JSeparator mnuToolsSep;
    private JPanel pnlEdit;
    private JTree treCodes;

    public GameEdit() {
        this.initComponents();
        this.treemodel = new DefaultTreeModel(this.masterList);
        this.treCodes.setModel(this.treemodel);
        this.lastpanel = new EmptyPanel();
        this.pnlEdit.add(this.lastpanel);
        this.loadConfig();
    }

    public void loadConfig() {
        JOptionPane msgbox = new JOptionPane();
        File setfile = new File("settings.ini");
        int width = -1;
        int height = -1;
        this.lastfile = new File("");
        if (setfile.exists()) {
            try {
                Scanner read = new Scanner(setfile);
                while (read.hasNextLine()) {
                    String line = read.nextLine();
                    if (line.startsWith("lastfile=")) {
                        line = line.substring(9);
                        this.lastfile = new File(line);
                        continue;
                    }
                    if (line.startsWith("dividerw=")) {
                        line = line.substring(9);
                        try {
                            this.jspVertSplit.setDividerLocation(Integer.parseInt(line));
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (line.startsWith("winwidth=")) {
                        line = line.substring(9);
                        try {
                            width = Integer.parseInt(line);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (!line.startsWith("winheight=")) continue;
                    line = line.substring(10);
                    try {
                        height = Integer.parseInt(line);
                    }
                    catch (Exception e) {}
                }
                read.close();
                if (height > 10 && width > 10) {
                    this.setSize(width, height);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Unable to load the config file, settings.ini. Did you do something to it?");
            }
        }
    }

    public void writeConfig() {
        File setfile = new File("settings.ini");
        try {
            PrintWriter pout = new PrintWriter(setfile);
            pout.println("lastfile=" + this.lastfile.getAbsolutePath());
            pout.println("dividerw=" + this.jspVertSplit.getDividerLocation());
            pout.println("winwidth=" + this.getWidth());
            pout.println("winheight=" + this.getHeight());
            pout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openXML() {
        JOptionPane msgbox = new JOptionPane();
        DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docmaker = builder.newDocumentBuilder();
            Document actualdoc = docmaker.parse(this.openfile);
            NodeList games = actualdoc.getElementsByTagName("game");
            this.masterList.clearGames();
            for (int g = 0; g < games.getLength(); ++g) {
                NodeList agame = games.item(g).getChildNodes();
                Game current = new Game(this.masterList, this.getTagValue(agame, "name"));
                current.setGameID(this.getTagValue(agame, "gameid"));
                current.setDate(this.getTagValue(agame, "date"));
                this.masterList.addGame(current);
                this.getCodes(agame, current);
            }
            this.treemodel.reload();
            this.mnuFileSave.setEnabled(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Unable to open the XML file you selected. Perhaps you opened a bad file?");
            ex.printStackTrace();
        }
    }

    public String getTagValue(NodeList nodelst, String tag) {
        String retval = new String();
        for (int i = 0; i < nodelst.getLength(); ++i) {
            Node temp = nodelst.item(i);
            if (!temp.getNodeName().equalsIgnoreCase(tag)) continue;
            retval = temp.getTextContent();
            break;
        }
        return retval;
    }

    public void getCodes(NodeList lst, Game mygame) {
        for (int i = 0; i < lst.getLength(); ++i) {
            Node temp = lst.item(i);
            if (temp.getNodeName().equalsIgnoreCase("cheat")) {
                NodeList code = temp.getChildNodes();
                Code thecode = new Code(mygame, this.getTagValue(code, "name"));
                thecode.setCode(this.getTagValue(code, "codes"));
                thecode.setNote(this.getTagValue(code, "note"));
                mygame.addCode(thecode);
            }
            if (!temp.getNodeName().equalsIgnoreCase("folder")) continue;
            NodeList foldconts = temp.getChildNodes();
            Folder codefold = new Folder(mygame, this.getTagValue(foldconts, "name"));
            codefold.setNote(this.getTagValue(foldconts, "note"));
            codefold.setAllowedOn(this.getTagValue(foldconts, "allowedon"));
            this.getCodes(foldconts, codefold);
            mygame.addCode(codefold);
        }
    }

    public void writeSubscriptionXML(String subname, File outfile) {
        JOptionPane msgbox = new JOptionPane();
        try {
            PrintWriter pout = new PrintWriter(new FileOutputStream(outfile));
            pout.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pout.println("<subscription>");
            pout.println("\t<name>" + subname + "</name>");
            pout.println("\t<codelist>");
            for (int g = 0; g < this.masterList.getChildCount(); ++g) {
                Game gme = (Game)this.masterList.getChildAt(g);
                pout.println("\t\t<game>");
                pout.println("\t\t\t<name>" + gme.getName() + "</name>");
                pout.println("\t\t\t<gameid>" + gme.getGameID() + "</gameid>");
                pout.println("\t\t\t<date>" + gme.getDate() + "</date>");
                this.writeCodes(pout, gme, 3);
                pout.println("\t\t</game>");
            }
            pout.println("\t</codelist>");
            pout.println("</subscription>");
            pout.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Something went wrong when saving the file. The file is probably empty now.");
            ex.printStackTrace();
        }
    }

    public void writeXMLoutput() {
        JOptionPane msgbox = new JOptionPane();
        try {
            PrintWriter pout = new PrintWriter(new FileOutputStream(this.openfile));
            pout.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pout.println("<codelist>");
            for (int g = 0; g < this.masterList.getChildCount(); ++g) {
                Game gme = (Game)this.masterList.getChildAt(g);
                pout.println("\t<game>");
                pout.println("\t\t<name>" + gme.getName() + "</name>");
                pout.println("\t\t<gameid>" + gme.getGameID() + "</gameid>");
                pout.println("\t\t<date>" + gme.getDate() + "</date>");
                this.writeCodes(pout, gme, 2);
                pout.println("\t</game>");
            }
            pout.println("</codelist>");
            pout.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Something went wrong when saving the file. The file is probably empty now.");
            ex.printStackTrace();
        }
    }

    public void writeCodes(PrintWriter pout, Game gme, int tabs) {
        for (int c = 0; c < gme.getChildCount(); ++c) {
            if (gme.getChildAt(c) instanceof Code) {
                Code mycode = (Code)gme.getChildAt(c);
                this.printtabs(pout, tabs);
                pout.println("<cheat>");
                this.printtabs(pout, tabs + 1);
                pout.println("<name>" + mycode.getName() + "</name>");
                if (mycode.getNote().length() > 0) {
                    this.printtabs(pout, tabs + 1);
                    pout.println("<note>" + mycode.getNote() + "</note>");
                }
                if (mycode.getCode().length() > 0) {
                    this.printtabs(pout, tabs + 1);
                    pout.println("<codes>" + mycode.getCode() + "</codes>");
                }
                this.printtabs(pout, tabs);
                pout.println("</cheat>");
                continue;
            }
            if (!(gme.getChildAt(c) instanceof Folder)) continue;
            Folder myfolder = (Folder)gme.getChildAt(c);
            this.printtabs(pout, tabs);
            pout.println("<folder>");
            this.printtabs(pout, tabs + 1);
            pout.println("<name>" + myfolder.getName() + "</name>");
            if (myfolder.getAllowedOn().length() > 0) {
                this.printtabs(pout, tabs + 1);
                pout.println("<allowedon>" + myfolder.getAllowedOn() + "</allowedon>");
            }
            if (myfolder.getNote().length() > 0) {
                this.printtabs(pout, tabs + 1);
                pout.println("<note>" + myfolder.getNote() + "</note>");
            }
            this.writeCodes(pout, myfolder, tabs + 1);
            this.printtabs(pout, tabs);
            pout.println("</folder>");
        }
    }

    public void printtabs(PrintWriter pout, int tabs) {
        for (int i = 0; i < tabs; ++i) {
            pout.print("\t");
        }
    }

    private void initComponents() {
        this.jspVertSplit = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.treCodes = new JTree();
        this.pnlEdit = new JPanel();
        this.mnuBar = new JMenuBar();
        this.mnuFile = new JMenu();
        this.mnuFileNew = new JMenuItem();
        this.mnuFileOpen = new JMenuItem();
        this.mnuFileSave = new JMenuItem();
        this.mnuFileSaveAs = new JMenuItem();
        this.mnuFileExport = new JMenu();
        this.mnuExportSubscr = new JMenuItem();
        this.mnuFileSep = new JSeparator();
        this.mnuFileExit = new JMenuItem();
        this.mnuCodeList = new JMenu();
        this.mnuListAddGame = new JMenuItem();
        this.mnuListAddFolder = new JMenuItem();
        this.mnuListAddCode = new JMenuItem();
        this.mnuListSep1 = new JSeparator();
        this.mnuListDupe = new JMenuItem();
        this.mnuListSep2 = new JSeparator();
        this.mnuListRemove = new JMenuItem();
        this.mnuTools = new JMenu();
        this.mnuToolsGameID = new JMenuItem();
        this.mnuToolsSep = new JSeparator();
        this.mnuToolsAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Code Editor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GameEdit.this.formWindowClosing(evt);
            }
        });
        this.jspVertSplit.setDividerLocation(200);
        this.treCodes.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                GameEdit.this.treCodesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.treCodes);
        this.jspVertSplit.setLeftComponent(this.jScrollPane1);
        this.pnlEdit.setLayout(new GridLayout(1, 0));
        this.jspVertSplit.setRightComponent(this.pnlEdit);
        this.mnuFile.setText("File");
        this.mnuFileNew.setText("New code file");
        this.mnuFileNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuFileNewActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuFileNew);
        this.mnuFileOpen.setText("Open XML file...");
        this.mnuFileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuFileOpenActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuFileOpen);
        this.mnuFileSave.setText("Save");
        this.mnuFileSave.setEnabled(false);
        this.mnuFileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuFileSaveActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuFileSave);
        this.mnuFileSaveAs.setText("Save as...");
        this.mnuFileSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuFileSaveAsActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuFileSaveAs);
        this.mnuFileExport.setText("Export");
        this.mnuExportSubscr.setText("As subscription...");
        this.mnuExportSubscr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuExportSubscrActionPerformed(evt);
            }
        });
        this.mnuFileExport.add(this.mnuExportSubscr);
        this.mnuFile.add(this.mnuFileExport);
        this.mnuFile.add(this.mnuFileSep);
        this.mnuFileExit.setText("Exit");
        this.mnuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuFileExitActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuFileExit);
        this.mnuBar.add(this.mnuFile);
        this.mnuCodeList.setText("Code List");
        this.mnuListAddGame.setText("Add Game...");
        this.mnuListAddGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuListAddGameActionPerformed(evt);
            }
        });
        this.mnuCodeList.add(this.mnuListAddGame);
        this.mnuListAddFolder.setText("Add Folder...");
        this.mnuListAddFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuListAddFolderActionPerformed(evt);
            }
        });
        this.mnuCodeList.add(this.mnuListAddFolder);
        this.mnuListAddCode.setText("Add Code...");
        this.mnuListAddCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuListAddCodeActionPerformed(evt);
            }
        });
        this.mnuCodeList.add(this.mnuListAddCode);
        this.mnuCodeList.add(this.mnuListSep1);
        this.mnuListDupe.setText("Duplicate Code");
        this.mnuListDupe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuListDupeActionPerformed(evt);
            }
        });
        this.mnuCodeList.add(this.mnuListDupe);
        this.mnuCodeList.add(this.mnuListSep2);
        this.mnuListRemove.setText("Delete selection");
        this.mnuListRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuListRemoveActionPerformed(evt);
            }
        });
        this.mnuCodeList.add(this.mnuListRemove);
        this.mnuBar.add(this.mnuCodeList);
        this.mnuTools.setText("Tools");
        this.mnuToolsGameID.setText("Get GameID from ROM");
        this.mnuToolsGameID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuToolsGameIDActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuToolsGameID);
        this.mnuTools.add(this.mnuToolsSep);
        this.mnuToolsAbout.setText("About the editor...");
        this.mnuToolsAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEdit.this.mnuToolsAboutActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mnuToolsAbout);
        this.mnuBar.add(this.mnuTools);
        this.setJMenuBar(this.mnuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jspVertSplit, -1, 529, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.jspVertSplit, -1, 318, Short.MAX_VALUE));
        this.pack();
    }

    private void mnuExportSubscrActionPerformed(ActionEvent evt) {
        JFileChooser fbox = new JFileChooser();
        JOptionPane msgbox = new JOptionPane();
        String subname = JOptionPane.showInputDialog(this, (Object)"Enter a name for your subscription, which will appear in the ARDS code manager:");
        if (subname != null && subname.length() > 0) {
            fbox.setSelectedFile(this.lastfile);
            fbox.addChoosableFileFilter(new FileFilter(){

                public String getDescription() {
                    return "XML files";
                }

                public boolean accept(File inf) {
                    boolean goodfile = inf.getName().toLowerCase().endsWith(".xml");
                    if (inf.isDirectory()) {
                        goodfile = true;
                    }
                    return goodfile;
                }
            });
            if (fbox.showSaveDialog(this) == 0) {
                File outfile = fbox.getSelectedFile();
                if (!outfile.getName().toLowerCase().endsWith(".xml")) {
                    outfile = new File(outfile.getAbsolutePath() + ".xml");
                }
                this.writeSubscriptionXML(subname, outfile);
            }
        }
    }

    private void mnuListDupeActionPerformed(ActionEvent evt) {
        JOptionPane msgbox = new JOptionPane();
        if (!this.treCodes.isSelectionEmpty() && this.treCodes.getLastSelectedPathComponent() instanceof Code) {
            Code selection = (Code)this.treCodes.getLastSelectedPathComponent();
            Game thegame = (Game)selection.getParent();
            String times = "0";
            int useindx = thegame.getIndex(selection) + 1;
            times = JOptionPane.showInputDialog(this, "Duplicate this code how many times? (Max 50)", "1");
            if (times != null && times.length() > 0) {
                try {
                    int number = Integer.parseInt(times);
                    if (number >= 50) {
                        number = 50;
                    } else if (number < 0) {
                        number = 0;
                    }
                    for (int i = 0; i < number; ++i) {
                        Code nextDupe = new Code(thegame, selection.getName());
                        nextDupe.setCode(selection.getCode());
                        nextDupe.setNote(selection.getNote());
                        thegame.insert(nextDupe, useindx);
                    }
                    this.treemodel.reload(thegame);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "You should consider entering a number next time.");
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "You must first select a code to duplicate.");
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.writeConfig();
    }

    private void mnuToolsAboutActionPerformed(ActionEvent evt) {
        JOptionPane msgbox = new JOptionPane();
        JOptionPane.showMessageDialog(this, "Action Replay Nintendo DS code editor version 1.0 final.\n\nThis program is free software. It has been created\nWITHOUT the permission of anyone behind the DS Action Replay.");
    }

    private void mnuFileNewActionPerformed(ActionEvent evt) {
        JOptionPane msgbox = new JOptionPane();
        int answer = JOptionPane.showConfirmDialog(this, "Are you sure you want to start over?", "New file", 0);
        if (answer == 0) {
            this.masterList = new CodeList();
            this.treemodel = new DefaultTreeModel(this.masterList);
            this.treCodes.setModel(this.treemodel);
            this.mnuFileSave.setEnabled(false);
        }
    }

    private void mnuListAddFolderActionPerformed(ActionEvent evt) {
        JOptionPane msgbox = new JOptionPane();
        if (!this.treCodes.isSelectionEmpty() && this.treCodes.getLastSelectedPathComponent() instanceof Game && !(this.treCodes.getLastSelectedPathComponent() instanceof Folder)) {
            Game selection = (Game)this.treCodes.getSelectionPath().getLastPathComponent();
            String name = JOptionPane.showInputDialog(this, "Please enter a name for this folder:", "Empty");
            if (name != null && name.length() > 0) {
                Folder folder = new Folder(selection, name);
                selection.addCode(folder);
                this.treemodel.reload(selection);
            }
        } else {
            JOptionPane.showMessageDialog(this, "You must first select the game you wish to add a folder to. Folders can not be nested.");
        }
    }

    private void mnuToolsGameIDActionPerformed(ActionEvent evt) {
        JFileChooser opengame = new JFileChooser();
        opengame.addChoosableFileFilter(new FileFilter(){

            public String getDescription() {
                return "NDS roms";
            }

            public boolean accept(File inf) {
                boolean goodfile = inf.getName().toLowerCase().endsWith(".nds");
                if (inf.isDirectory()) {
                    goodfile = true;
                }
                return goodfile;
            }
        });
        if (opengame.showOpenDialog(this) == 0) {
            try {
                GameIDCalc calcbox = new GameIDCalc(opengame.getSelectedFile());
                calcbox.setLocationRelativeTo(this);
                calcbox.setVisible(true);
            }
            catch (Exception ex) {
                System.out.println("Something terrible happened! Here is the error:");
                ex.printStackTrace();
            }
        }
    }

    private void mnuListAddGameActionPerformed(ActionEvent evt) {
        JOptionPane msgbox = new JOptionPane();
        String name = JOptionPane.showInputDialog(this, "Please enter the name of this game:", "Unknown");
        if (name != null && name.length() > 0) {
            Game mygame = new Game(this.masterList, name);
            mygame.setGameID("ABCE deadbeef");
            mygame.setDate(EditGamePanel.getNow());
            this.masterList.addGame(mygame);
            this.treemodel.reload();
        }
    }

    private void mnuFileSaveActionPerformed(ActionEvent evt) {
        this.writeXMLoutput();
    }

    private void mnuListAddCodeActionPerformed(ActionEvent evt) {
        JOptionPane msgbox = new JOptionPane();
        if (!this.treCodes.isSelectionEmpty() && this.treCodes.getSelectionPath().getLastPathComponent() instanceof Game) {
            Game selection = (Game)this.treCodes.getSelectionPath().getLastPathComponent();
            String name = JOptionPane.showInputDialog(this, "Please enter a name for this code:", "Untitled");
            if (name != null && name.length() > 0) {
                Code mycode = new Code(selection, name);
                selection.addCode(mycode);
                this.treemodel.reload(selection);
            }
        } else if (!this.treCodes.isSelectionEmpty() && this.treCodes.getLastSelectedPathComponent() instanceof Code) {
            Code selection = (Code)this.treCodes.getLastSelectedPathComponent();
            Game codeparent = (Game)selection.getParent();
            String name = JOptionPane.showInputDialog(this, "Please enter a name for this code:", "Untitled");
            if (name != null && name.length() > 0) {
                Code mycode = new Code(codeparent, name);
                codeparent.insert(mycode, codeparent.getIndex(selection));
                this.treemodel.reload(codeparent);
            }
        } else {
            JOptionPane.showMessageDialog(this, "You must first select the game you wish to add a code to.");
        }
    }

    private void mnuListRemoveActionPerformed(ActionEvent evt) {
        JOptionPane msgbox = new JOptionPane();
        boolean deleteThem = false;
        if (!this.treCodes.isSelectionEmpty() && this.treCodes.getSelectionPath().getLastPathComponent() instanceof TreeNode) {
            Game mygame;
            Code mycode;
            int answer;
            TreePath[] paths = this.treCodes.getSelectionPaths();
            TreeNode selection = (TreeNode)paths[0].getLastPathComponent();
            if (paths.length == 1) {
                answer = 1;
                if (selection instanceof Code) {
                    mycode = (Code)selection;
                    answer = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete: " + mycode.getName() + "?", "Confirm deletion", 0);
                } else if (selection instanceof Game) {
                    mygame = (Game)selection;
                    answer = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete: " + mygame.getName() + "?", "Confirm deletion", 0);
                }
                if (answer == 0) {
                    deleteThem = true;
                }
            } else {
                answer = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete all of the stuff you just selected?", "Confirm deletion", 0);
                if (answer == 0) {
                    deleteThem = true;
                }
            }
            if (deleteThem) {
                for (int selno = paths.length; selno > 0; --selno) {
                    Game thegame;
                    selection = (TreeNode)paths[selno - 1].getLastPathComponent();
                    if (selection instanceof Code) {
                        mycode = (Code)selection;
                        thegame = (Game)mycode.getParent();
                        if (paths.length < 20) {
                            this.treemodel.removeNodeFromParent(mycode);
                            continue;
                        }
                        thegame.deleteCode(mycode);
                        continue;
                    }
                    if (selection instanceof Folder) {
                        Folder myfold = (Folder)selection;
                        thegame = (Game)myfold.getParent();
                        if (paths.length < 20) {
                            this.treemodel.removeNodeFromParent(myfold);
                            continue;
                        }
                        thegame.deleteCode(myfold);
                        continue;
                    }
                    if (!(selection instanceof Game)) continue;
                    mygame = (Game)selection;
                    if (paths.length < 20) {
                        this.treemodel.removeNodeFromParent(mygame);
                        continue;
                    }
                    this.masterList.removeGame(mygame);
                }
                this.pnlEdit.remove(this.lastpanel);
                this.lastpanel = new EmptyPanel();
                this.pnlEdit.add(this.lastpanel);
                this.pnlEdit.revalidate();
                if (paths.length >= 20) {
                    this.treemodel.reload();
                }
            }
        }
    }

    private void mnuFileOpenActionPerformed(ActionEvent evt) {
        JFileChooser fbox = new JFileChooser();
        fbox.setSelectedFile(this.lastfile);
        fbox.addChoosableFileFilter(new FileFilter(){

            public String getDescription() {
                return "XML files";
            }

            public boolean accept(File inf) {
                boolean goodfile = inf.getName().toLowerCase().endsWith(".xml");
                if (inf.isDirectory()) {
                    goodfile = true;
                }
                return goodfile;
            }
        });
        if (fbox.showOpenDialog(this) == 0) {
            this.openfile = fbox.getSelectedFile();
            this.openXML();
            this.lastfile = this.openfile;
        }
    }

    private void mnuFileExitActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.dispose();
    }

    private void mnuFileSaveAsActionPerformed(ActionEvent evt) {
        JFileChooser fbox = new JFileChooser();
        fbox.setSelectedFile(this.lastfile);
        fbox.addChoosableFileFilter(new FileFilter(){

            public String getDescription() {
                return "XML files";
            }

            public boolean accept(File inf) {
                boolean goodfile = inf.getName().toLowerCase().endsWith(".xml");
                if (inf.isDirectory()) {
                    goodfile = true;
                }
                return goodfile;
            }
        });
        if (fbox.showSaveDialog(this) == 0) {
            this.openfile = fbox.getSelectedFile();
            if (!this.openfile.getName().toLowerCase().endsWith(".xml")) {
                this.openfile = new File(this.openfile.getAbsolutePath() + ".xml");
            }
            this.mnuFileSave.setEnabled(true);
            this.writeXMLoutput();
            this.lastfile = this.openfile;
        }
    }

    private void treCodesValueChanged(TreeSelectionEvent evt) {
        if (!this.treCodes.isSelectionEmpty() && this.treCodes.getSelectionPath().getLastPathComponent() instanceof TreeNode) {
            TreeNode selection = (TreeNode)this.treCodes.getSelectionPath().getLastPathComponent();
            if (selection instanceof Code) {
                this.pnlEdit.remove(this.lastpanel);
                this.lastpanel = new EditCodePanel((Code)selection);
                this.pnlEdit.add(this.lastpanel);
                this.pnlEdit.revalidate();
            } else if (selection instanceof Folder) {
                this.pnlEdit.remove(this.lastpanel);
                this.lastpanel = new EditFolderPanel((Folder)selection);
                this.pnlEdit.add(this.lastpanel);
                this.pnlEdit.revalidate();
            } else if (selection instanceof Game) {
                this.pnlEdit.remove(this.lastpanel);
                this.lastpanel = new EditGamePanel((Game)selection);
                this.pnlEdit.add(this.lastpanel);
                this.pnlEdit.revalidate();
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GameEdit().setVisible(true);
            }
        });
    }
}

