/*
 * Decompiled with CFR 0.152.
 */
package dsareditor;

import dsareditor.Code;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class EditCodePanel
extends JPanel {
    Code editing;
    private JButton btnApply;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel lblCodeData;
    private JLabel lblCodeIdentifier;
    private JLabel lblName;
    private JLabel lblNotes;
    private JComboBox pulCodeType;
    private JTextArea txtCodeData;
    private JTextField txtCodeName;
    private JTextField txtNotes;

    public EditCodePanel(Code content) {
        this.initComponents();
        this.editing = content;
        this.displayValues();
    }

    public void displayValues() {
        this.txtCodeName.setText(this.editing.getName());
        this.txtNotes.setText(this.editing.getNote());
        String codetype = this.editing.getCode();
        if (codetype.startsWith("master ")) {
            codetype = codetype.substring(7);
            this.pulCodeType.setSelectedIndex(1);
        } else if (codetype.startsWith("always_on ")) {
            codetype = codetype.substring(10);
            this.pulCodeType.setSelectedIndex(2);
        } else if (codetype.startsWith("on ")) {
            codetype = codetype.substring(3);
            this.pulCodeType.setSelectedIndex(3);
        }
        this.txtCodeData.setText(this.prettyPrint(codetype));
    }

    public String prettyPrint(String text) {
        StringTokenizer read = new StringTokenizer(text);
        String output = new String();
        int lines = 0;
        while (read.hasMoreTokens()) {
            output = output + read.nextToken();
            if (++lines % 2 == 0) {
                lines -= 2;
                output = output + "\n";
                continue;
            }
            output = output + " ";
        }
        return output;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.lblName = new JLabel();
        this.txtCodeName = new JTextField();
        this.lblNotes = new JLabel();
        this.txtNotes = new JTextField();
        this.lblCodeData = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtCodeData = new JTextArea();
        this.btnApply = new JButton();
        this.lblCodeIdentifier = new JLabel();
        this.pulCodeType = new JComboBox();
        this.jLabel1.setText("jLabel1");
        this.lblName.setText("Code name:");
        this.txtCodeName.setText("My code");
        this.lblNotes.setText("Notes: (optional)");
        this.lblCodeData.setText("Code data:");
        this.txtCodeData.setColumns(20);
        this.txtCodeData.setRows(5);
        this.jScrollPane1.setViewportView(this.txtCodeData);
        this.btnApply.setText("Apply Changes");
        this.btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditCodePanel.this.btnApplyActionPerformed(evt);
            }
        });
        this.lblCodeIdentifier.setText("Special code identifiers:");
        this.pulCodeType.setModel(new DefaultComboBoxModel<String>(new String[]{"Normal Code", "Master Code", "Always On", "On by default"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.lblNotes, -1, 256, Short.MAX_VALUE).add(this.lblName, -1, 256, Short.MAX_VALUE).add(this.txtCodeName, -1, 256, Short.MAX_VALUE).add(this.txtNotes, -1, 256, Short.MAX_VALUE).add(this.lblCodeIdentifier, -1, 256, Short.MAX_VALUE).add(this.pulCodeType, 0, 256, Short.MAX_VALUE).add(this.lblCodeData, -1, 256, Short.MAX_VALUE).add(this.jScrollPane1, -1, 256, Short.MAX_VALUE).add(2, this.btnApply)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.lblName).addPreferredGap(0).add(this.txtCodeName, -2, -1, -2).addPreferredGap(0).add(this.lblNotes).addPreferredGap(0).add(this.txtNotes, -2, -1, -2).addPreferredGap(0).add(this.lblCodeIdentifier).addPreferredGap(0).add(this.pulCodeType, -2, -1, -2).addPreferredGap(0).add(this.lblCodeData).addPreferredGap(0).add(this.jScrollPane1, -1, 103, Short.MAX_VALUE).addPreferredGap(0).add(this.btnApply).addContainerGap()));
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        this.editing.setName(this.txtCodeName.getText());
        this.editing.setNote(this.txtNotes.getText());
        StringTokenizer output = new StringTokenizer(this.txtCodeData.getText());
        String result = new String();
        switch (this.pulCodeType.getSelectedIndex()) {
            case 1: {
                result = result + "master ";
                break;
            }
            case 2: {
                result = result + "always_on ";
                break;
            }
            case 3: {
                result = result + "on ";
                break;
            }
        }
        while (output.hasMoreTokens()) {
            result = result + output.nextToken() + " ";
        }
        this.editing.setCode(result);
    }
}

