@ECHO off
CLS

SET toolpath=%~dp0
SET inname=%1
SET infilename=%~nx1
SET outname=The_Nameless_Game.nds
SET patchfile="%toolpath%\The_Nameless_Game.patch"

REM bsdiff 4.3 win32 download: http://sites.inka.de/tesla/download/bsdiff4.3-win32.zip (http://sites.inka.de/tesla/others.html#bsdiff)
SET patcher="%toolpath%\tools\bspatch.exe"

SET md5="%toolpath%\tools\md5comp.exe"

REM Clean ROM information: http://datomatic.no-intro.org/?page=show_record&n=2420&s=28
SET hashpre="EE9BCF9A65F7A01BDABBA79053280922"
SET hashpost="B8FCD6501C37C755B7C366C3FF19965E"

IF NOT [%inname%] == [] GOTO FoundFilename
	REM Set default filenames
	SET inname=ind-nngj.nds
	SET infilename=ind-nngj.nds
	
:FoundFilename
IF EXIST %inname% GOTO FoundFile
	ECHO Could not find specific file: %infilename%
	GOTO End
	
:FoundFile
IF EXIST %patcher% GOTO FoundPatcher
	ECHO Please download the following ZIP and extract bspatch.exe to the "tools" directory:
	ECHO http://sites.inka.de/tesla/download/bsdiff4.3-win32.zip
	GOTO End

:FoundPatcher
	ECHO Checking MD5 of input file...
	
IF NOT EXIST %md5% GOTO MD5NotFound
	%md5% %inname% %hashpre%
	
IF %ERRORLEVEL% == 0 GOTO FinishedMD5
	ECHO Input file: %infilename%
	ECHO Did not match the expected MD5 hash: %hashpre%
	GOTO End
	
:MD5NotFound
	ECHO The integrity of the input ROM file could not be checked because %md5% was not found.
	SET /P ANS=Would you still like to continue? (WARNING: Game may not work properly) [Y/N]: 
	IF /i %ANS% == y GOTO FinishedMD5
	goto End

:FinishedMD5
	ECHO Patching %infilename%...
	%patcher% %inname% "%outname%" %patchfile%
	
IF NOT EXIST %md5% GOTO SkipMD5Del
	ECHO Checking MD5 on new file...
	
IF EXIST %outname% GOTO FoundNewFile
	ECHO Something went wrong with the patching process!
	ECHO Could not find patched file: %outname%
	GOTO End
	
:FoundNewFile
	%md5% %outname% %hashpost%

IF %ERRORLEVEL% == 0 GOTO SkipMD5Del
	ECHO.
	ECHO Something went wrong with the patching process!
	ECHO Output file: %outname%
	ECHO Did not match the expected MD5 hash: %hashpost%
	ECHO.
IF NOT EXIST "%outname%" GOTO End
	DEL /F "%outname%"
	GOTO End

:SkipMD5Del
	ECHO.
	ECHO Patched file: %outname%
	ECHO Enjoy!
	ECHO.
	
:End	
	PAUSE