#ifndef __NF_SPRITE3D_H__
#define __NF_SPRITE3D_H__

#ifdef __cplusplus
extern "C" {
#endif





	// NightFox LIB - Include de funciones 3D
	// Requiere DevkitARM R30
	// Codigo por NightFox
	// http://www.nightfoxandco.com/
	// Version 20100505



	// Includes devKitPro
	#include <nds.h>



	//////////////////////////////////
	// Defines y variables globales //
	//////////////////////////////////

	// Numero maximo de sprites en pantalla
	#define NF_3DSPRITES 256

	// Estructura de control de los sprites 3d
	typedef struct {
		s16 x;					// Coordenada X
		s16 y;					// Coordenada Y
		s16 rx;					// Rotacion Eje X (-512/0/512) << 6
		s16 ry;					// Rotacion Eje Y (-512/0/512) << 6
		s16 rz;					// Rotacion Eje Z (-512/0/512) << 6
		bool rot;				// Rotacion en uso
		u16 sx;					// Escala X (0/64/512) << 6
		u16 sy;					// Escala Y (0/64/512) << 6
		bool scale;				// Escalado en uso
		s16 width;				// Ancho del sprite
		s16 height;				// Alto del sprite
		bool inuse;				// Esta en uso?
		bool show;				// Debe mostrarse el sprite?
		u32 gfx_tex_format;		// Guarda el formato de la textura
		u32 gfx;				// Direccion donde esta almacenado el grafico en VRAM
		u16 gfxid;				// Id de Gfx usado
		u16 frame;				// Frame actual
		u16 newframe;			// Frame al que cambiar
		u16 framesize;			// Tamao del frame (en bytes)
		u16 lastframe;			// Ultimo frame
		u32 gfx_pal_format;		// Guarda el formato de la paleta
		u32 pal;				// Direccion donde esta almacenada la paleta en VRAM
		u16 palid;				// Id de la paleta usada
		u16 prio;				// Prioridad de dibujado del sprite
	} NF_TYPE_3DSPRITE_INFO;
	extern NF_TYPE_3DSPRITE_INFO NF_3DSPRITE[NF_3DSPRITES];


	// Define la esturctura de control de la VRAM para Sprites 3d
	typedef struct {
		s32 free;					// Memoria VRAM libre
		u32 next;					// Siguiente posicion libre
		u32 last;					// Ultima posicion usada
		u32 pos[NF_3DSPRITES];		// Posicion en VRAM para reusar despues de un borrado
		u32 size[NF_3DSPRITES];		// Tamao del bloque libre para reusar
		u16 deleted;				// Numero de bloques borrados
		s32 lost;					// Memoria VRAM irrecuperable (perdidas por fragmentacion)
		s32 fragmented;				// Memoria VRAM fragmentada
		s32 inarow;					// Memoria VRAM contigua
	} NF_TYPE_TEXVRAM_INFO;
	extern NF_TYPE_TEXVRAM_INFO NF_TEXVRAM;		// Informacion VRAM de texturas


	// Define la estructura de control de los sprites 3d creados
	typedef struct {
		s16 total;					// Numero de sprites creados
		u16 id[NF_3DSPRITES];		// ID del Sprite
		u16 bck[NF_3DSPRITES];		// Backup del ID
	} NF_TYPE_CREATED_3DSPRITE_INFO;
	extern NF_TYPE_CREATED_3DSPRITE_INFO NF_CREATED_3DSPRITE;





	// Funcion NF_Init3dSpriteSys();
	void NF_Init3dSpriteSys(void);
	// Inicializa el sistema de Sprites en 3D


	// Funcion NF_Vram3dSpriteGfx();
	void NF_Vram3dSpriteGfx(u16 ram, u16 vram, bool keepframes);
	// Transfiere un grafico de la RAM a la VRAM


	// Funcion NF_Free3dSpriteGfx();
	void NF_Free3dSpriteGfx(u16 id);
	// Elimina de la VRAM un grafico de texturas y desfragmenta la VRAM si es necesario


	// Funcion NF_Vram3dSpriteGfxDefrag();
	void NF_Vram3dSpriteGfxDefrag(void);
	// Desfragmenta la VRAM usada para texturas


	// Funcion NF_Vram3dSpritePal();
	void NF_Vram3dSpritePal(u8 id, u8 slot);
	// Copia una paleta a la VRAM


	// Funcion NF_Create3dSprite();
	void NF_Create3dSprite(u16 id, u16 gfx, u16 pal, s16 x, s16 y);
	// Crea un Sprite 3D en las coordenadas indicadas


	// Funcion NF_Delete3dSprite();
	void NF_Delete3dSprite(u16 id);
	// Borra el Sprite con la ID indicada


	// Funcion NF_Sort3dSprites();
	void NF_Sort3dSprites(void);
	// Reordena la cola de Sprites 3D creados de menor a mayor segun su ID
	// Los Sprites con numeros mas bajos tienen prioridad.


	// Funcion NF_Set3dSpritePriority();
	void NF_Set3dSpritePriority(u16 id, u16 prio);
	// Cambia la prioridad del Sprite


	// Funcion NF_Swap3dSpritePriority();
	void NF_Swap3dSpritePriority(u16 id_a, u16 id_b);
	// Intercambia la prioridad de dos Sprites


	// Funcion NF_Move3dSprite();
	void NF_Move3dSprite(u16 id, s16 x, s16 y);
	// Mueve el Sprite seleccionado a las coordenadas dadas


	// Funcion NF_Show3dSprite();
	void NF_Show3dSprite(u16 id, bool show);
	// Muestra u oculta el sprite con la id indicada


	// Funcion NF_Set3dSpriteFrame();
	void NF_Set3dSpriteFrame(u16 id, u16 frame);
	// Cambia el frame visible del sprite indicado


	// Funcion NF_Draw3dSprites();
	void NF_Draw3dSprites(void);
	// Dibuja en pantalla todos los sprites creados


	// Funcion NF_Update3dSpritesGfx();
	void NF_Update3dSpritesGfx(void);
	// Actualiza si es necesario las texturas de los sprites animados


	// Funcion NF_Rotate3dSprite();
	void NF_Rotate3dSprite(u16 id, s16 x, s16 y, s16 z);
	// Rota el Sprite sobre los ejes indicados (-512/0/512)


	// Funcion NF_Scale3dSprite();
	void NF_Scale3dSprite(u16 id, u16 x, u16 y);
	// Scala el sprite al tamao indicado (0/64/512)





#ifdef __cplusplus
}
#endif


#endif