/**
 * DLDI GUI Patcher for Linux
 *
 * This program is an easy to use GUI to patch multiple files at once,
 * created with GTKmm and intended voor Linux users
 *
 * Created by Lucas van Dijk, using an modified version of dldi source,
 * by Michael Chisholm (Chishm)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @author Lucas van Dijk
 * @version $Id$
 * @license http://www.opensource.org/licenses/gpl-license.php
 */

#include "../include/textviewstream.h"

TextViewStreamBuffer::TextViewStreamBuffer(Glib::RefPtr<Gtk::TextBuffer> textview, size_t buffer_size) : textview_buf(textview), buffer(buffer_size + 1)
{
	char * base = &this -> buffer.front();
	this -> setp(base, base + this -> buffer.size() - 1);
}

TextViewStreamBuffer::int_type TextViewStreamBuffer::overflow(int_type character)
{
	if(character != traits_type::eof())
	{
		if(this -> pptr() < this -> epptr())
		{
			*(this -> pptr()) = character;
			this -> pbump(1);

			if(this -> write_to_buffer())
			{
				return character;
			}
		}
	}

	return traits_type::eof();
}

int TextViewStreamBuffer::sync()
{
	return this -> write_to_buffer() ? 0 : -1;
}

bool TextViewStreamBuffer::write_to_buffer()
{
	this -> textview_buf -> insert(this -> textview_buf -> end(), pbase(), pptr());

	this -> pbump(-(this -> pptr() - this -> pbase()));
	return true;
}



