/**
 * DLDI GUI Patcher for Linux
 *
 * This program is an easy to use GUI to patch multiple files at once,
 * created with GTKmm and intended voor Linux users
 *
 * Created by Lucas van Dijk, using an modified version of dldi source,
 * by Michael Chisholm (Chishm)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @author Lucas van Dijk
 * @version $Id$
 * @license http://www.opensource.org/licenses/gpl-license.php
 */

#include "../include/stdinc.h"
#include "../include/uimain.h"

int main(int argc, char * argv[])
{
	Gtk::Main main(argc, argv);

	// Load Glade file
	Glib::RefPtr<Gnome::Glade::Xml> glade_ref = Gnome::Glade::Xml::create("dldi-linux-gui.glade", "wndMain");

	// Get the window object
	DLDIWindow * window = 0;
	glade_ref -> get_widget_derived("wndMain", window);

	// Start GTK main loop
	Gtk::Main::run(*window);

	if(window)
	{
		delete window;
		window = 0;
	}

	return 0;
}
