/**
 * DLDI GUI Patcher for Linux
 *
 * This program is an easy to use GUI to patch multiple files at once,
 * created with GTKmm and intended voor Linux users
 *
 * Created by Lucas van Dijk, using an modified version of dldi source,
 * by Michael Chisholm (Chishm)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @author Lucas van Dijk
 * @version $Id$
 * @license http://www.opensource.org/licenses/gpl-license.php
 */

#ifndef DLDIWINDOW_H_INCLUDED
#define DLDIWINDOW_H_INCLUDED

#include "stdinc.h"
#include "dldifile.h"
#include "ndsfile.h"
#include "textviewstream.h"
#include "xmlParser.h"

class DLDIWindow : public Gtk::Window
{
	public:
		// Button Enum
		enum Buttons
		{
			BUTTON_ADD,
			BUTTON_PATCH,
			BUTTON_REMOVE,
			BUTTON_CLEAR,
			BUTTON_BROWSE
		};

		// Menu entries enum
		enum Menus
		{
			MENU_ADD,
			MENU_PATCH,
			MENU_QUIT,
			MENU_INFO,
			MENU_WEBSITE
		};

		// Methods
		DLDIWindow(GtkWindow*& window_obj, const Glib::RefPtr<Gnome::Glade::Xml>& ui_xml);
		virtual ~DLDIWindow();

		void connect_button(std::string button_name, Buttons id);
		void connect_menu(std::string menu_name, Menus id);

		void append_text(std::string message);

		// Signal handlers
		void OnButtonClick(Buttons id);
		void OnMenuClick(Menus id);
		void OnAboutDlgResponse(int response);

	protected:
		// Combo Box model
		class SingleColumn : public Gtk::TreeModel::ColumnRecord
		{
			public:
				Gtk::TreeModelColumn<std::string> text;

				SingleColumn()
				{
					this -> add(this -> text);
				}
		};

		class DoubleColumn : public Gtk::TreeModel::ColumnRecord
		{
			public:
				Gtk::TreeModelColumn<std::string> text;
				Gtk::TreeModelColumn<std::string> driver;
				Gtk::TreeModelColumn<std::string> row_data;

				DoubleColumn()
				{
					this -> add(this -> text);
					this -> add(this -> driver);
					this -> add(this -> row_data);
				}
		};

		/// Holds the columns for the driver combobox
		SingleColumn columns;

		/// Holds the columns for the nds file listview
		DoubleColumn listview_columns;

		/// The combobox model, which holds all data
		Glib::RefPtr<Gtk::ListStore> combo_model;

		/// The files list view model
		Glib::RefPtr<Gtk::ListStore> listview_model;

		/// A vector containing all DLDI drivers loaded
		std::vector<DLDIFile *> dldi_files;

		/// A vector containing all Nds drivers loaded
		std::vector<NdsFile *> nds_files;

		/// Reference to our glade file, for the UI
		Glib::RefPtr<Gnome::Glade::Xml> glade_ref;

		/// Our cout redirector buffer
		TextViewStreamBuffer * stream_buffer;

		/// Last folder from Nds File Chooser dialog
		std::string last_nds_folder;

		/// Last folder from DLDI Folder Chooser dialog
		std::string last_dldi_folder;

		/// The pointer to the About Dialog
		Gtk::AboutDialog * about_dlg;

		//
		// Protected methods
		//
		void load_dldi_files(std::string dir = ".");
		void initialize_combo();
		void initialize_list();
		void add_nds_file();
		void patch();
		void show_dialog(Glib::ustring text);
		void clear_dldi_files();
		void clear_nds_files();

};

#endif // DLDIWINDOW_H_INCLUDED



