/**
 * DLDI GUI Patcher for Linux
 *
 * This program is an easy to use GUI to patch multiple files at once,
 * created with GTKmm and intended voor Linux users
 *
 * Created by Lucas van Dijk, using an modified version of dldi source,
 * by Michael Chisholm (Chishm)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @author Lucas van Dijk
 * @version $Id$
 * @license http://www.opensource.org/licenses/gpl-license.php
 */

#ifndef TEXTVIEWSTREAM_H_INCLUDED
#define TEXTVIEWSTREAM_H_INCLUDED

#include "stdinc.h"
#include <streambuf>

using std::size_t;

class TextViewStreamBuffer : public std::streambuf
{
	protected:
		Glib::RefPtr<Gtk::TextBuffer> textview_buf;
		std::vector<char> buffer;

	public:
		explicit TextViewStreamBuffer(Glib::RefPtr<Gtk::TextBuffer> textview, size_t buffer_size = 256);

	protected:
		virtual int_type overflow(int_type character);
		virtual int sync();

		virtual bool write_to_buffer();
};

#endif
