/**
 * DLDI GUI Patcher for Linux
 *
 * This program is an easy to use GUI to patch multiple files at once,
 * created with GTKmm and intended voor Linux users
 *
 * Created by Lucas van Dijk, using an modified version of dldi source,
 * by Michael Chisholm (Chishm)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @author Lucas van Dijk
 * @version $Id$
 * @license http://www.opensource.org/licenses/gpl-license.php
 */

#ifndef DLDIPATCHER_H_INCLUDED
#define DLDIPATCHER_H_INCLUDED

#include "stdinc.h"
#include "dldi.h"
#include "dldifile.h"

class NdsFile
{
	// Members
	protected:
		/// The filename op the NDS file
		std::string filename;

		/// The current driver name
		std::string driver_name;

		/// Holds the filesize of the NDS File
		ifstream::pos_type filesize;

		/// Holds the fstream object of our nds file
		fstream file;

		/// File data of the app we're going to patch
		data_t * app_file_data;

		/// Position where the dldi section begins
		addr_t patch_offset;

		/// Holds all DLDI data
		data_t * dldi_section;

	// Methods
	public:
		NdsFile(std::string filename);
		virtual ~NdsFile();

		void patch(DLDIFile &dldi_file);
		data_t &operator[](addr_t index);

		std::string get_driver_name();
		std::string get_filename();

	protected:
		void open();
		addr_t read_address(addr_t offset);
		void write_address(addr_t position, addr_t value);
		addr_t quick_find(const data_t * search, size_t length);
		void parse_info();
};

#endif // DLDIPATCHER_H_INCLUDED
