/**
 * DLDI GUI Patcher for Linux
 *
 * This program is an easy to use GUI to patch multiple files at once,
 * created with GTKmm and intended voor Linux users
 *
 * Created by Lucas van Dijk, using an modified version of dldi source,
 * by Michael Chisholm (Chishm)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @author Lucas van Dijk
 * @version $Id$
 * @license http://www.opensource.org/licenses/gpl-license.php
 */

#ifndef DLDIFILE_H_INCLUDED
#define DLDIFILE_H_INCLUDED

#include <fstream>
#include "stdinc.h"
#include "dldi.h"

using namespace std;

class DLDIFile
{
	protected:
		/// Holds the file data of the DLDI file
		data_t * file_data;

		/// Holds the path to the .dldi file
		string filename;

		/// Holds the friendly driver name of the DLDI file
		string driver_name;

		/// Holds the filesize of the file
		ifstream::pos_type filesize;

	public:
		DLDIFile(std::string filename);
		virtual ~DLDIFile();

		string get_driver_name();
		string get_path();

		addr_t read_address(addr_t offset);
		data_t &operator[](addr_t index);
		data_t * get_data();
		fstream::pos_type get_filesize();

	protected:
		void open_file();
		void parse_info();

};

#endif // DLDIFILE_H_INCLUDED

