/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.vnds.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import nl.weeaboo.vnds.tools.SoundConverter;
import timon.common.Log;
import timon.common.components.FileBrowseField;
import timon.common.components.GuiUtil;
import timon.common.components.Sash;
import timon.common.components.Skin;
import timon.common.components.progress.ProgressDialog;
import timon.common.components.progress.ProgressListener;
import timon.common.components.progress.ProgressRunnable;

public class SoundConverterGUI
extends JFrame {
    private SoundConverter encoder = new SoundConverter();
    private JComboBox modeCombo;
    private JSpinner aacQualitySpinner;
    private JSpinner mp3QualitySpinner;
    private JSpinner volumeSpinner;
    private JCheckBox toUpperCheck;
    private JCheckBox loggingCheck;
    private JSpinner threadsSpinner;
    private FileBrowseField browseField;
    private JButton convertButton;

    public SoundConverterGUI() {
        this.setTitle("VNDS Sound Converter v1.4.2");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createCenterPanel(), "Center");
        this.reset();
        this.setMinimumSize(new Dimension(300, 100));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            GuiUtil.setSkin((Skin)Skin.NATIVE);
        }
        catch (Exception exception) {
            Log.warning((Exception)exception);
        }
        new SoundConverterGUI();
    }

    protected JPanel createCenterPanel() {
        JLabel jLabel = new JLabel("Output Type");
        this.modeCombo = new JComboBox<Object>(new Object[]{SoundConverter.ConvertType.TYPE_AAC, SoundConverter.ConvertType.TYPE_ADPCM, SoundConverter.ConvertType.TYPE_MP3});
        this.modeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundConverter.ConvertType convertType = (SoundConverter.ConvertType)((Object)SoundConverterGUI.this.modeCombo.getSelectedItem());
                SoundConverterGUI.this.encoder.setMode(convertType);
                SoundConverterGUI.this.aacQualitySpinner.setEnabled(convertType == SoundConverter.ConvertType.TYPE_AAC);
                SoundConverterGUI.this.mp3QualitySpinner.setEnabled(convertType == SoundConverter.ConvertType.TYPE_MP3);
            }
        });
        JLabel jLabel2 = new JLabel("AAC Quality");
        this.aacQualitySpinner = new JSpinner(new SpinnerNumberModel(70, 5, 995, 5));
        JLabel jLabel3 = new JLabel("MP3 Bitrate");
        this.mp3QualitySpinner = new JSpinner(new SpinnerNumberModel(96, 8, 128, 16));
        JLabel jLabel4 = new JLabel("Volume (%)");
        this.volumeSpinner = new JSpinner(new SpinnerNumberModel(100, 10, 990, 10));
        JLabel jLabel5 = new JLabel("Filenames to uppercase?");
        this.toUpperCheck = new JCheckBox();
        JLabel jLabel6 = new JLabel("Write logfile");
        this.loggingCheck = new JCheckBox();
        JLabel jLabel7 = new JLabel("Threads");
        this.threadsSpinner = new JSpinner(new SpinnerNumberModel(8, 1, 128, 1));
        JPanel jPanel = new JPanel(new GridLayout(-1, 2, 15, 5));
        jPanel.add(jLabel);
        jPanel.add(this.modeCombo);
        jPanel.add(jLabel2);
        jPanel.add(this.aacQualitySpinner);
        jPanel.add(jLabel3);
        jPanel.add(this.mp3QualitySpinner);
        jPanel.add(jLabel4);
        jPanel.add(this.volumeSpinner);
        jPanel.add(jLabel5);
        jPanel.add(this.toUpperCheck);
        jPanel.add(jLabel6);
        jPanel.add(this.loggingCheck);
        jPanel.add(jLabel7);
        jPanel.add(this.threadsSpinner);
        this.browseField = new FileBrowseField("Folder", "");
        this.convertButton = new JButton("Convert");
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SoundConverterGUI.this.convert();
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)new Sash(0), "North");
        jPanel2.add((Component)this.browseField, "Center");
        jPanel2.add((Component)this.convertButton, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 10));
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        return jPanel3;
    }

    public void convert() {
        final String string = this.browseField.getSelectedPath();
        File file = new File(string);
        if (string.equals("") || !file.exists() || !file.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Invalid directory: \"" + string + "\"", "Error", 0);
            return;
        }
        int n = (Integer)this.aacQualitySpinner.getValue() / 16 * 16;
        int n2 = this.encoder.getMp3MinBitrate();
        int n3 = (n + 15) / 16 * 16;
        n = Math.min(128, n);
        n3 = Math.min(128, n3);
        this.encoder.setAacQuality((Integer)this.aacQualitySpinner.getValue());
        this.encoder.setMp3Quality(n2, n3, n);
        this.encoder.setVolume((Integer)this.volumeSpinner.getValue());
        this.encoder.setConvertNameToUpperCase(this.toUpperCheck.isSelected());
        this.encoder.setLogging(this.loggingCheck.isSelected());
        this.encoder.setMaxThreads((Integer)this.threadsSpinner.getValue());
        ProgressListener progressListener = new ProgressListener(){

            public void onFinished(String string) {
                String string2 = "";
                String string3 = "";
                try {
                    if (SoundConverterGUI.this.encoder.isLogging()) {
                        string2 = SoundConverterGUI.this.encoder.dumpLog("conversion.log").getAbsolutePath();
                        string3 = String.format("<br><br> Log dumped to %s", string2);
                    }
                    JOptionPane.showMessageDialog(null, String.format("<html>Conversion finished.%s</html>", string3), "Finished", -1);
                }
                catch (IOException iOException) {
                    Log.showError((Exception)iOException);
                }
            }

            public void onProgress(int n, int n2, String string) {
            }
        };
        ProgressRunnable progressRunnable = new ProgressRunnable(){

            public void run(ProgressListener progressListener) {
                SoundConverterGUI.this.encoder.convertFolder(string, progressListener);
            }
        };
        ProgressDialog progressDialog = new ProgressDialog();
        progressDialog.showDialog(progressRunnable, progressListener);
    }

    public void reset() {
        this.aacQualitySpinner.setValue(this.encoder.getAacQuality());
        this.mp3QualitySpinner.setValue(this.encoder.getMp3AvgBitrate());
        this.volumeSpinner.setValue(this.encoder.getVolume());
        this.toUpperCheck.setSelected(this.encoder.getConvertNameToUpperCase());
        this.threadsSpinner.setValue(this.encoder.getMaxThreads());
    }
}

