/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.vnds.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import timon.common.SystemUtil;
import timon.common.components.progress.ProgressListener;
import timon.common.io.BatchProcess;
import timon.common.io.FileTask;
import timon.common.io.FileUtil;

public class SoundConverter {
    public static final int Q_LOW = 35;
    public static final int Q_MED = 50;
    public static final int Q_HIGH = 70;
    private String workingDir = "tools/";
    private int maxThreads = 8;
    private ConvertType mode = ConvertType.TYPE_AAC;
    private int quality = 70;
    private int mp3_minb = 8;
    private int mp3_maxb = 128;
    private int mp3_avgb = 96;
    private int volume = 100;
    private boolean nameToUpperCase;
    private boolean log;
    private Map<File, StringBuilder> processLogs = new HashMap<File, StringBuilder>();

    public static void main(String[] stringArray) {
        SoundConverter soundConverter = new SoundConverter();
        soundConverter.setVolume(800);
        soundConverter.setConvertNameToUpperCase(true);
        soundConverter.convertFolder("foldername/", null);
    }

    public void convertFolder(String string, ProgressListener progressListener) {
        this.processLogs = new HashMap<File, StringBuilder>();
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (File file : new File(string).listFiles()) {
            if (file.isDirectory()) continue;
            hashMap.put(file.getName(), file);
        }
        BatchProcess batchProcess = new BatchProcess();
        batchProcess.setTaskSize(32);
        batchProcess.setThreads(this.maxThreads);
        batchProcess.setThreadPriority(1);
        batchProcess.addProgressListener(progressListener);
        try {
            batchProcess.run(hashMap, new FileTask(){

                public void processFile(String string, File file) throws IOException {
                    SoundConverter.this.convertFile(file);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected static void collectFiles(Set<File> set, File file, int n) {
        if (file.isDirectory()) {
            if (n == 0 && !file.getName().equals("special")) {
                for (File file2 : file.listFiles()) {
                    SoundConverter.collectFiles(set, file2, n + 1);
                }
            }
        } else if (!file.getName().endsWith(".aac")) {
            set.add(file);
        }
    }

    public void convertFile(File file) {
        this.convertFile(file, null);
    }

    public void convertFile(File file, String string) {
        String string2 = file.getName();
        if (string2.lastIndexOf(46) > 0) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        if (this.mode == ConvertType.TYPE_AAC) {
            this.convertAAC(string, file, string2);
        } else if (this.mode == ConvertType.TYPE_ADPCM) {
            this.convertADPCM(string, file, string2);
        } else if (this.mode == ConvertType.TYPE_MP3) {
            this.convertMP3(string, file, string2);
        } else {
            throw new IllegalArgumentException("Invalid conversion mode: " + (Object)((Object)this.mode));
        }
    }

    public void convertAAC(String string, File file, String string2) {
        if (string == null) {
            string = file.getParent();
        }
        File file2 = new File(string);
        file2.mkdirs();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isLogging()) {
            this.processLogs.put(file, stringBuilder);
        }
        try {
            String string3 = String.valueOf(this.hashCode() ^ Thread.currentThread().hashCode());
            String string4 = String.format("%s/__%s.%s", string, string3, FileUtil.getExtension((String)file.getName()));
            File file3 = new File(string4);
            if (file2.equals(file.getParentFile())) {
                file.renameTo(file3);
            } else {
                FileUtil.copyFile((File)file, (File)file3);
            }
            String string5 = FileUtil.stripExtension((String)file3.getName());
            String string6 = this.volume != 100 ? "-vol " + this.volume : "";
            Process process = SystemUtil.execInDir((String)String.format("ffmpeg -y -i \"%s\" -ac 1 -ar 22050 %s \"%s.2.wav\"", string4, string6, string + '/' + string5), (String)this.workingDir);
            stringBuilder.append("\r\n[FFMPEG]\r\n");
            SoundConverter.doWaitFor(process, stringBuilder);
            file3.delete();
            process = SystemUtil.execInDir((String)String.format("faac -q %d \"%s.2.wav\" -o \"%s.aac\"", this.quality, string + '/' + string5, string + '/' + string5), (String)this.workingDir);
            stringBuilder.append("\r\n[FAAC]\r\n");
            SoundConverter.doWaitFor(process, stringBuilder);
            if (file2.equals(file.getParentFile())) {
                file.delete();
            }
            new File(string + '/' + string5 + ".2.wav").delete();
            string2 = this.nameToUpperCase ? string2.toUpperCase() : string2;
            File file4 = new File(string + "/" + string5 + ".aac");
            File file5 = new File(string + "/" + string2 + ".aac");
            file5.delete();
            file4.renameTo(file5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void convertADPCM(String string, File file, String string2) {
        if (string == null) {
            string = file.getParent();
        }
        File file2 = new File(string);
        file2.mkdirs();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isLogging()) {
            this.processLogs.put(file, stringBuilder);
        }
        try {
            String string3 = String.valueOf(this.hashCode() ^ Thread.currentThread().hashCode());
            String string4 = String.format("%s/__%s.%s", string, string3, FileUtil.getExtension((String)file.getName()));
            File file3 = new File(string4);
            if (file2.equals(file.getParentFile())) {
                file.renameTo(file3);
            } else {
                FileUtil.copyFile((File)file, (File)file3);
            }
            String string5 = FileUtil.stripExtension((String)file3.getName());
            String string6 = this.volume != 100 ? "-vol " + this.volume : "";
            Process process = SystemUtil.execInDir((String)String.format("ffmpeg -y -i \"%s\" -acodec adpcm_ima_wav -ac 1 -ar 22050 %s \"%s.adpcm.wav\"", string4, string6, string + '/' + string5), (String)this.workingDir);
            stringBuilder.append("\r\n[FFMPEG]\r\n");
            SoundConverter.doWaitFor(process, stringBuilder);
            file3.delete();
            process = SystemUtil.execInDir((String)String.format("ima2raw \"%s.adpcm.wav\"", string + '/' + string5), (String)this.workingDir);
            stringBuilder.append("\r\n[IMA2RAW]\r\n");
            SoundConverter.doWaitFor(process, stringBuilder);
            new File(string + '/' + string5 + ".adpcm.wav").delete();
            File file4 = new File(string + '/' + string5 + ".adpcm.wav.raw");
            File file5 = new File(string + '/' + (this.nameToUpperCase ? string2.toUpperCase() : string2) + ".wav");
            file5.delete();
            file4.renameTo(file5);
            file4.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void convertMP3(String string, File file, String string2) {
        this.convertMP3(string, file, string2, this.mp3_avgb, this.mp3_minb, this.mp3_avgb);
    }

    public void convertMP3(String string, File file, String string2, int n, int n2, int n3) {
        if (string == null) {
            string = file.getParent();
        }
        File file2 = new File(string);
        file2.mkdirs();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isLogging()) {
            this.processLogs.put(file, stringBuilder);
        }
        try {
            String string3 = String.valueOf(this.hashCode() ^ Thread.currentThread().hashCode());
            String string4 = String.format("%s/__%s.%s", string, string3, FileUtil.getExtension((String)file.getName()));
            File file3 = new File(string4);
            if (file2.equals(file.getParentFile())) {
                file.renameTo(file3);
            } else {
                FileUtil.copyFile((File)file, (File)file3);
            }
            String string5 = FileUtil.stripExtension((String)file3.getName());
            String string6 = this.volume != 100 ? "-vol " + this.volume : "";
            Process process = SystemUtil.execInDir((String)String.format("ffmpeg -y -i \"%s\" -ac 2 -ar 32000 %s \"%s.2.wav\"", string4, string6, string + '/' + string5), (String)this.workingDir);
            stringBuilder.append("\r\n[FFMPEG]\r\n");
            SoundConverter.doWaitFor(process, stringBuilder);
            file3.delete();
            String string7 = String.format("--abr %d -b %d -B %d", n, n2, n3);
            process = SystemUtil.execInDir((String)String.format("lame --resample 32 %s \"%s.2.wav\" \"%s.mp3\"", string7, string + '/' + string5, string + '/' + string5), (String)this.workingDir);
            stringBuilder.append("\r\n[LAME]\r\n");
            SoundConverter.doWaitFor(process, stringBuilder);
            File file4 = new File(string + '/' + string5 + ".mp3");
            new File(string + '/' + string5 + ".2.wav").delete();
            string2 = this.nameToUpperCase ? string2.toUpperCase() : string2;
            File file5 = new File(string + "/" + string2 + ".mp3");
            file5.delete();
            file4.renameTo(file5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int doWaitFor(Process process, StringBuilder stringBuilder) {
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        boolean bl = false;
        while (!bl) {
            try {
                while (inputStream.available() > 0) {
                    stringBuilder.append((char)inputStream.read());
                }
                while (inputStream2.available() > 0) {
                    stringBuilder.append((char)inputStream2.read());
                }
                return process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                stringBuilder.append("IOException: " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return -1;
    }

    public File dumpLog(String string) throws IOException {
        File file = new File(string);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("----------------------------------------");
        printWriter.println("----------------------------------------");
        for (Map.Entry<File, StringBuilder> entry : this.getLogs().entrySet()) {
            printWriter.println();
            printWriter.println("Log for file:" + entry.getKey().getAbsolutePath());
            printWriter.println();
            printWriter.println(entry.getValue().toString());
            printWriter.println("----------------------------------------");
            printWriter.println("----------------------------------------");
        }
        printWriter.close();
        return file;
    }

    public Map<File, StringBuilder> getLogs() {
        return this.processLogs;
    }

    public boolean isLogging() {
        return this.log;
    }

    public ConvertType getMode() {
        return this.mode;
    }

    public int getAacQuality() {
        return this.quality;
    }

    public int getMp3MinBitrate() {
        return this.mp3_minb;
    }

    public int getMp3MaxBitrate() {
        return this.mp3_maxb;
    }

    public int getMp3AvgBitrate() {
        return this.mp3_avgb;
    }

    public int getVolume() {
        return this.volume;
    }

    public boolean getConvertNameToUpperCase() {
        return this.nameToUpperCase;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setMode(ConvertType convertType) {
        this.mode = convertType;
    }

    public void setLogging(boolean bl) {
        this.log = bl;
    }

    public void setAacQuality(int n) {
        this.quality = n;
    }

    public void setMp3Quality(int n, int n2, int n3) {
        this.mp3_minb = n;
        this.mp3_maxb = n2;
        this.mp3_avgb = n3;
    }

    public void setVolume(int n) {
        this.volume = n;
    }

    public void setConvertNameToUpperCase(boolean bl) {
        this.nameToUpperCase = bl;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    public void setWorkingDir(String string) {
        this.workingDir = string;
    }

    public static enum ConvertType {
        TYPE_AAC("AAC"),
        TYPE_ADPCM("ADPCM"),
        TYPE_MP3("MP3");

        private String label;

        private ConvertType(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }
}

