/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.vnds.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import nl.weeaboo.vnds.tools.TextureConverter;
import timon.common.Log;
import timon.common.components.FileBrowseField;
import timon.common.components.GuiUtil;
import timon.common.components.Sash;
import timon.common.components.Skin;
import timon.common.components.progress.ProgressDialog;
import timon.common.components.progress.ProgressListener;
import timon.common.components.progress.ProgressRunnable;

public class TextureConverterGUI
extends JFrame {
    private TextureConverter converter = new TextureConverter();
    private JComboBox modeCombo;
    private JCheckBox ditheringCheck;
    private JSpinner threadsSpinner;
    private FileBrowseField browseField;
    private JButton convertButton;

    public TextureConverterGUI() {
        this.setTitle("NDS Texture Converter v1.0");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createCenterPanel(), "Center");
        this.setMinimumSize(new Dimension(300, 100));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            GuiUtil.setSkin((Skin)Skin.NATIVE);
        }
        catch (Exception exception) {
            Log.warning((Exception)exception);
        }
        if (stringArray.length > 0) {
            TextureConverter.main(stringArray);
        } else {
            new TextureConverterGUI();
        }
    }

    protected JPanel createCenterPanel() {
        JLabel jLabel = new JLabel("Format");
        this.modeCombo = new JComboBox<TextureConverter.Mode>(TextureConverter.Mode.values());
        this.modeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextureConverter.Mode mode = (TextureConverter.Mode)((Object)TextureConverterGUI.this.modeCombo.getSelectedItem());
                TextureConverterGUI.this.converter.setMode(mode);
            }
        });
        this.modeCombo.setSelectedItem((Object)this.converter.getMode());
        JLabel jLabel2 = new JLabel("Dithering");
        this.ditheringCheck = new JCheckBox();
        this.ditheringCheck.setSelected(this.converter.isDithering());
        JLabel jLabel3 = new JLabel("Threads");
        this.threadsSpinner = new JSpinner(new SpinnerNumberModel(this.converter.getThreads(), 1, 128, 1));
        JPanel jPanel = new JPanel(new GridLayout(-1, 2, 15, 5));
        jPanel.add(jLabel);
        jPanel.add(this.modeCombo);
        jPanel.add(jLabel2);
        jPanel.add(this.ditheringCheck);
        jPanel.add(jLabel3);
        jPanel.add(this.threadsSpinner);
        this.browseField = new FileBrowseField("Folder", "");
        this.convertButton = new JButton("Convert");
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextureConverterGUI.this.convert();
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)new Sash(0), "North");
        jPanel2.add((Component)this.browseField, "Center");
        jPanel2.add((Component)this.convertButton, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 10));
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        new DropTarget(jPanel3, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            @Override
            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                for (DataFlavor dataFlavor : dropTargetDragEvent.getCurrentDataFlavorsAsList()) {
                    if (!dataFlavor.isFlavorJavaFileListType()) continue;
                    dropTargetDragEvent.acceptDrag(3);
                    break;
                }
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                dropTargetDropEvent.acceptDrop(3);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
                    if (!dataFlavor.isFlavorJavaFileListType()) continue;
                    try {
                        List list = (List)transferable.getTransferData(dataFlavor);
                        TextureConverterGUI.this.convert(list);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        Log.warning((Exception)unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        Log.warning((Exception)iOException);
                    }
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }
        });
        return jPanel3;
    }

    public void convert() {
        this.convert(null);
    }

    public void convert(final List<File> list) {
        Object object;
        final String string = this.browseField.getSelectedPath();
        if (list == null) {
            object = new File(string);
            if (string.equals("") || !((File)object).exists() || !((File)object).isDirectory()) {
                JOptionPane.showMessageDialog(null, "Invalid directory: \"" + string + "\"", "Error", 0);
                return;
            }
        }
        this.converter.setMode((TextureConverter.Mode)((Object)this.modeCombo.getSelectedItem()));
        this.converter.setDithering(this.ditheringCheck.isSelected());
        this.converter.setThreads((Integer)this.threadsSpinner.getValue());
        object = new ProgressListener(){

            public void onFinished(String string) {
                JOptionPane.showMessageDialog(null, "<html>Conversion finished.", "Finished", -1);
            }

            public void onProgress(int n, int n2, String string) {
            }
        };
        ProgressRunnable progressRunnable = new ProgressRunnable(){

            public void run(ProgressListener progressListener) {
                try {
                    if (list == null) {
                        TextureConverterGUI.this.converter.convertFolder(string, progressListener);
                    } else {
                        for (Serializable serializable : list) {
                            TextureConverterGUI.this.converter.convertFile((File)serializable);
                        }
                        if (list.size() == 1) {
                            Serializable serializable;
                            Image image = TextureConverterGUI.this.converter.readImage(((File)list.get(0)).getAbsolutePath());
                            serializable = new JLabel(new ImageIcon(image));
                            JFrame jFrame = new JFrame();
                            jFrame.getContentPane().add((Component)serializable);
                            jFrame.pack();
                            jFrame.setLocationRelativeTo(null);
                            jFrame.setVisible(true);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        ProgressDialog progressDialog = new ProgressDialog();
        progressDialog.showDialog(progressRunnable, (ProgressListener)object);
    }
}

