/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.vnds.tools;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import nl.weeaboo.vnds.tools.Octree;
import timon.common.SystemUtil;
import timon.common.collections.Tuple2;
import timon.common.components.progress.ProgressListener;
import timon.common.io.BatchProcess;
import timon.common.io.FileTask;
import timon.common.io.FileUtil;

public class TextureConverter {
    private Mode mode = Mode.RGB256;
    private Quant quant = Quant.OCTREE;
    private boolean dithering = true;
    private int threads = Runtime.getRuntime().availableProcessors();

    protected static void printUsage() {
        System.err.printf("Usage: java -jar TextureConverter.jar <mode> <flags> file [out-folder]\n\n\tmode:\n\t-1 => A3I5\n\t-4 => RGB256\n\t-6 => A5I3\n\t-7 => RGBA\n\tflags:\n\t-nodither => No dithering\n\t-quant <octree|neuquant>\n\t-threads <num>\n", new Object[0]);
    }

    public static void main(String[] stringArray) {
        TextureConverter textureConverter = new TextureConverter();
        String string = null;
        String string2 = null;
        try {
            textureConverter.setMode(Mode.fromInt(Integer.parseInt(stringArray[0].substring(1))));
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("-nodither")) {
                    textureConverter.setDithering(false);
                    continue;
                }
                if (stringArray[i].startsWith("-quant")) {
                    if (!stringArray[++i].equals("neuquant")) {
                        textureConverter.setQuant(Quant.NEUQUANT);
                        continue;
                    }
                    textureConverter.setQuant(Quant.OCTREE);
                    continue;
                }
                if (stringArray[i].startsWith("-threads")) {
                    textureConverter.setThreads(Integer.parseInt(stringArray[++i]));
                    continue;
                }
                if (string == null) {
                    string = stringArray[i];
                    continue;
                }
                if (string2 == null) {
                    string2 = stringArray[i];
                    continue;
                }
                throw new IllegalArgumentException("Error parsing arg: " + stringArray[i]);
            }
        }
        catch (RuntimeException runtimeException) {
            TextureConverter.printUsage();
            return;
        }
        if (string == null) {
            TextureConverter.printUsage();
            return;
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            textureConverter.convertFile(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void convertFolder(String string, ProgressListener progressListener) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        final File file = new File(string).getCanonicalFile();
        if (file.isDirectory()) {
            for (BatchProcess batchProcess : file.listFiles()) {
                if (batchProcess.isDirectory()) continue;
                hashMap.put(batchProcess.getName(), batchProcess);
            }
        } else {
            hashMap.put(file.getName(), file);
        }
        BatchProcess batchProcess = new BatchProcess();
        batchProcess.setTaskSize(32);
        batchProcess.setThreads(this.threads);
        batchProcess.setThreadPriority(1);
        batchProcess.addProgressListener(progressListener);
        try {
            batchProcess.run(hashMap, new FileTask(){

                public void processFile(String string, File file2) throws IOException {
                    TextureConverter.this.convertFile(file2.getAbsolutePath(), file.getAbsolutePath());
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void convertFile(File file) throws IOException {
        this.convertFile(file.getAbsolutePath(), file.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertFile(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            throw new FileNotFoundException(file.getPath());
        }
        if (file2.exists() && !file2.isDirectory()) {
            file2 = file2.getParentFile();
        } else {
            string2 = file2.getAbsolutePath() + File.separator + file.getName();
        }
        file2.mkdirs();
        File file3 = File.createTempFile("_tc" + Thread.currentThread().hashCode(), ".png", file2);
        try {
            FileUtil.copyFile((File)file, (File)file3);
            String string3 = file3.getAbsolutePath();
            if (this.mode == Mode.A3I5) {
                this.quantize(string3, 32);
                this.convertToPalette(string3, 3, 5);
            } else if (this.mode == Mode.RGB256) {
                this.quantize(string3, 256);
                this.convertToPalette(string3, 0, 8);
            } else if (this.mode == Mode.A5I3) {
                this.quantize(string3, 8);
                this.convertToPalette(string3, 5, 3);
            } else if (this.mode == Mode.RGBA) {
                this.quantize(string3, 256);
                this.convertToRAW(string3);
            } else {
                throw new IllegalArgumentException("Invalid mode: " + (Object)((Object)this.mode));
            }
            String string4 = FileUtil.stripExtension((String)string3);
            String string5 = FileUtil.stripExtension((String)string2);
            File file4 = new File(string5 + ".dta");
            File file5 = new File(string5 + ".pal");
            File file6 = new File(string4 + ".dta");
            File file7 = new File(string4 + ".pal");
            file4.delete();
            file6.renameTo(file4);
            file6.delete();
            file5.delete();
            file7.renameTo(file5);
            file7.delete();
        }
        finally {
            file3.delete();
        }
    }

    protected void quantize(String string, int n) throws IOException {
        File file = new File(string).getCanonicalFile();
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            throw new FileNotFoundException(string);
        }
        string = file.getAbsolutePath();
        BufferedImage bufferedImage = ImageIO.read(file);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int[] nArray = bufferedImage.getRGB(0, 0, n2, n3, null, 0, n2);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] >>> 24;
            nArray[i] = 0xFF000000 | nArray[i] & 0xFFFFFF;
        }
        if (this.dithering) {
            TextureConverter.floydSteinberg(nArray, n2, n3);
        }
        if (this.quant == Quant.NEUQUANT) {
            bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            Process process = SystemUtil.execInDir((String)String.format("pngnq \"%s\" -n %d", string, n), (String)"tools/pngnq-0.5-i386/");
            SystemUtil.waitFor((Process)process);
            file.delete();
            new File(FileUtil.stripExtension((String)string) + "-nq8.png").renameTo(file);
            bufferedImage = ImageIO.read(file);
            bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        } else if (this.quant == Quant.OCTREE) {
            Octree octree = new Octree();
            octree.quantize(nArray, n2, n);
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] & 0xFFFFFF | nArray2[i] << 24;
        }
        bufferedImage = new BufferedImage(n2, n3, 2);
        bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
    }

    protected void convertToPalette(String string, int n, int n2) throws IOException {
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(file);
        int[] nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        file.delete();
        int n3 = (1 << n) - 1;
        int[] nArray2 = this.createPalette(nArray, 1 << n2);
        File file2 = new File(FileUtil.stripExtension((String)string) + ".dta");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        for (int n4 : nArray) {
            int n5 = n4 >> 24 & 0xFF;
            int n6 = this.lookupPalette(nArray2, this.A8R8G8B8_to_A1B5G5R5(n4));
            if (n5 == 0) {
                n6 = 0;
            }
            n4 = (Math.round((float)(n3 * n5) / 255.0f) & n3) << n2 | n6;
            bufferedOutputStream.write(n4 & 0xFF);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        File file3 = new File(FileUtil.stripExtension((String)string) + ".pal");
        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
        for (int n5 : nArray2) {
            bufferedOutputStream.write(n5 & 0xFF);
            bufferedOutputStream.write(n5 >> 8 & 0xFF);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    protected void convertToRAW(String string) throws IOException {
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(file);
        int[] nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        this.A8R8G8B8_to_A1B5G5R5(nArray);
        file.delete();
        File file2 = new File(FileUtil.stripExtension((String)string) + ".dta");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        for (int n : nArray) {
            bufferedOutputStream.write(n & 0xFF);
            bufferedOutputStream.write(n >> 8 & 0xFF);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    protected int A8R8G8B8_to_A1B5G5R5(int n) {
        int n2 = n >>> 24 >= 127 ? 32768 : 0;
        int n3 = Math.round((float)(n >> 16 & 0xFF) / 8.0f);
        n3 = Math.max(0, Math.min(31, n3));
        int n4 = Math.round((float)(n >> 8 & 0xFF) / 8.0f);
        n4 = Math.max(0, Math.min(31, n4));
        int n5 = Math.round((float)(n & 0xFF) / 8.0f);
        n5 = Math.max(0, Math.min(31, n5));
        return n2 | n5 << 10 | n4 << 5 | n3;
    }

    protected void A8R8G8B8_to_A1B5G5R5(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.A8R8G8B8_to_A1B5G5R5(nArray[i]);
        }
    }

    protected int[] createPalette(int[] nArray, int n) {
        int[] nArray2 = new int[32768];
        for (int n2 : nArray) {
            int n3 = this.A8R8G8B8_to_A1B5G5R5(n2) & Short.MAX_VALUE;
            nArray2[n3] = nArray2[n3] + 1;
        }
        Object object = new TreeSet<Tuple2<Integer, Integer>>(new Comparator<Tuple2<Integer, Integer>>(){

            @Override
            public int compare(Tuple2<Integer, Integer> tuple2, Tuple2<Integer, Integer> tuple22) {
                int n = ((Integer)tuple2.y).compareTo((Integer)tuple22.y);
                if (n == 0) {
                    n = ((Integer)tuple2.x).compareTo((Integer)tuple22.x);
                }
                return -n;
            }
        });
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] <= 0) continue;
            ((TreeSet)object).add(new Tuple2((Object)i, (Object)nArray2[i]));
        }
        int[] nArray3 = new int[n];
        int n4 = 1;
        Iterator iterator = ((TreeSet)object).iterator();
        while (iterator.hasNext()) {
            Tuple2 tuple2 = (Tuple2)iterator.next();
            if (n4 >= nArray3.length) break;
            nArray3[n4++] = (Integer)tuple2.x;
        }
        return nArray3;
    }

    protected int lookupPalette(int[] nArray, int n) {
        int n2 = n >> 10 & 0x1F;
        int n3 = n >> 5 & 0x1F;
        int n4 = n & 0x1F;
        int n5 = 0;
        int n6 = Integer.MAX_VALUE;
        for (int i = 1; i < nArray.length; ++i) {
            int n7 = nArray[i];
            int n8 = n7 >> 10 & 0x1F;
            int n9 = n7 >> 5 & 0x1F;
            int n10 = n7 & 0x1F;
            int n11 = Math.abs(n10 - n4) + Math.abs(n9 - n3) + Math.abs(n8 - n2);
            if (n11 >= n6) continue;
            n5 = i;
            n6 = n11;
        }
        return n5;
    }

    private static void floydSteinberg(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        double[][][] dArray = new double[n][n2][4];
        int n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                dArray[n4][n5][0] = nArray[n6] >>> 16 & 0xFF;
                dArray[n4][n5][1] = nArray[n6] >>> 8 & 0xFF;
                dArray[n4][n5][2] = nArray[n6] & 0xFF;
                dArray[n4][n5][3] = nArray[n6] >>> 24 & 0xFF;
                ++n6;
            }
        }
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                for (n3 = 0; n3 < 3; ++n3) {
                    double d = dArray[n5][n4][n3];
                    double d2 = (double)Math.round(d / 8.0) * 8.0;
                    dArray[n5][n4][n3] = d2;
                    double d3 = d2;
                    double d4 = d - d3;
                    if (n5 + 1 < n) {
                        double[] dArray2 = dArray[n5 + 1][n4];
                        int n7 = n3;
                        dArray2[n7] = dArray2[n7] + 7.0 * d4 / 16.0;
                        dArray[n5 + 1][n4][n3] = Math.min(255.0, Math.max(0.0, dArray[n5 + 1][n4][n3]));
                    }
                    if (n4 + 1 >= n2) continue;
                    if (n5 - 1 >= 0) {
                        double[] dArray3 = dArray[n5 - 1][n4 + 1];
                        int n8 = n3;
                        dArray3[n8] = dArray3[n8] + 3.0 * d4 / 16.0;
                        dArray[n5 - 1][n4 + 1][n3] = Math.min(255.0, Math.max(0.0, dArray[n5 - 1][n4 + 1][n3]));
                    }
                    double[] dArray4 = dArray[n5][n4 + 1];
                    int n9 = n3;
                    dArray4[n9] = dArray4[n9] + 5.0 * d4 / 16.0;
                    dArray[n5][n4 + 1][n3] = Math.min(255.0, Math.max(0.0, dArray[n5][n4 + 1][n3]));
                    if (n5 + 1 >= n) continue;
                    double[] dArray5 = dArray[n5 + 1][n4 + 1];
                    int n10 = n3;
                    dArray5[n10] = dArray5[n10] + 1.0 * d4 / 16.0;
                    dArray[n5 + 1][n4 + 1][n3] = Math.min(255.0, Math.max(0.0, dArray[n5 + 1][n4 + 1][n3]));
                }
            }
        }
        n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = Math.min(255, Math.max(0, (int)Math.round(dArray[n4][n5][3])));
                int n11 = Math.min(255, Math.max(0, (int)Math.round(dArray[n4][n5][0])));
                int n12 = Math.min(255, Math.max(0, (int)Math.round(dArray[n4][n5][1])));
                int n13 = Math.min(255, Math.max(0, (int)Math.round(dArray[n4][n5][2])));
                nArray[n6] = n3 << 24 | n11 << 16 | n12 << 8 | n13;
                ++n6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image readImage(String string) throws IOException {
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(file);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        String string2 = FileUtil.stripExtension((String)string);
        File file2 = new File(string2 + ".dta");
        FileInputStream fileInputStream = new FileInputStream(file2);
        try {
            int n3;
            MappedByteBuffer mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file2.length());
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n4 = this.mode == Mode.RGBA ? 2 : 1;
            int[] nArray = new int[(int)file2.length() / n4];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = n4 == 2 ? (int)mappedByteBuffer.getShort() : (int)mappedByteBuffer.get();
            }
            fileInputStream.close();
            if (this.mode != Mode.RGBA) {
                File file3 = new File(string2 + ".pal");
                FileInputStream fileInputStream2 = new FileInputStream(file3);
                try {
                    int n5;
                    MappedByteBuffer mappedByteBuffer2 = fileInputStream2.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file3.length());
                    mappedByteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                    int[] nArray2 = new int[(int)file3.length() / 2];
                    for (n5 = 0; n5 < nArray2.length; ++n5) {
                        nArray2[n5] = mappedByteBuffer2.getShort();
                    }
                    n5 = 255;
                    if (this.mode == Mode.A3I5) {
                        n5 = 31;
                    } else if (this.mode == Mode.A5I3) {
                        n5 = 7;
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        int n6 = nArray[i];
                        int n7 = 255;
                        if (this.mode == Mode.A3I5) {
                            n7 = (n6 >> 5) * 32 + 16;
                        } else if (this.mode == Mode.A5I3) {
                            n7 = (n6 >> 3) * 8 + 4;
                        } else if (this.mode == Mode.RGB256) {
                            n7 = n6 == 0 ? 0 : 255;
                        }
                        n6 = nArray2[n6 & n5];
                        n6 = (n6 & 0x1F) * 8 + 4 << 16 | (n6 >> 5 & 0x1F) * 8 + 4 << 8 | (n6 >> 10 & 0x1F) * 8 + 4;
                        nArray[i] = n7 << 24 | n6;
                    }
                }
                finally {
                    fileInputStream2.close();
                }
            } else {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    int n8 = nArray[n3];
                    int n9 = n8 >> 15 != 0 ? 255 : 0;
                    n8 = (n8 & 0x1F) * 8 + 4 << 16 | (n8 >> 5 & 0x1F) * 8 + 4 << 8 | (n8 >> 10 & 0x1F) * 8 + 4;
                    nArray[n3] = n9 << 24 | n8;
                }
            }
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
            bufferedImage2.setRGB(0, 0, n, n2, nArray, 0, n);
            BufferedImage bufferedImage3 = bufferedImage2;
            return bufferedImage3;
        }
        finally {
            fileInputStream.close();
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public Quant getQuant() {
        return this.quant;
    }

    public boolean isDithering() {
        return this.dithering;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setQuant(Quant quant) {
        this.quant = quant;
    }

    public void setDithering(boolean bl) {
        this.dithering = bl;
    }

    public void setThreads(int n) {
        this.threads = n;
    }

    public static enum Quant {
        NEUQUANT,
        OCTREE;

    }

    public static enum Mode {
        A3I5(1, "A3I5"),
        RGB256(4, "RGB256"),
        A5I3(6, "A5I3"),
        RGBA(7, "RGBA");

        private int num;
        private String label;

        private Mode(int n2, String string2) {
            this.num = n2;
            this.label = string2;
        }

        public static Mode fromInt(int n) {
            for (Mode mode : Mode.values()) {
                if (mode.num != n) continue;
                return mode;
            }
            return null;
        }

        public String toString() {
            return this.num + ". " + this.label;
        }
    }
}

