/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.vnds.tools;

public class Octree {
    Node root;
    public static final int MAX_TREE_DEPTH = 8;
    public static final int MAX_NODES = 266817;
    public static final int MAX_RGB = 255;
    public static final int[] SQUARES = new int[511];
    public int[] shift = new int[9];
    int depth;
    int nodes;
    int colors;
    int pruningTreshold;
    int nextPruningTreshold;
    int[] colormap;
    int cdistance;
    int cred;
    int cgreen;
    int cblue;
    int colorNumber;

    public Octree() {
        this.root.parent = this.root = new Node(128, 128, 128, null, 0);
        this.root.numberColors = Integer.MAX_VALUE;
    }

    public void quantize(int[] nArray, int n, int n2) {
        this.depth = 1;
        int n3 = n2;
        while (n3 != 0) {
            n3 >>= 2;
            ++this.depth;
        }
        n3 = nArray.length;
        int n4 = 32;
        while (n3 != 0) {
            n3 >>= 1;
            --n4;
        }
        for (int i = 0; i <= this.depth; ++i) {
            this.shift[i] = n4;
            if (n4 == 0) continue;
            --n4;
        }
        this.sortInImage(nArray);
        this.reduction(n2);
        this.assignment(nArray, n2);
    }

    void sortInImage(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = n >> 16 & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = n & 0xFF;
            this.sortInRGB(n2, n3, n4);
        }
    }

    void sortInRGB(int n, int n2, int n3) {
        if (this.nodes > 266817) {
            this.pruneLevel(this.root);
            --this.depth;
        }
        Node node = this.root;
        for (int i = 1; i <= this.depth; ++i) {
            int n4 = (n > node.midRed ? 1 : 0) | (n2 > node.midGreen ? 2 : 0) | (n3 > node.midBlue ? 4 : 0);
            if (node.children[n4] == null) {
                int n5 = 1 << 8 - i >> 1;
                Node node2 = new Node(node.midRed + ((n4 & 1) != 0 ? n5 : -n5), node.midGreen + ((n4 & 2) != 0 ? n5 : -n5), node.midBlue + ((n4 & 4) != 0 ? n5 : -n5), node, (byte)n4);
                ++this.nodes;
                node.census = (byte)(node.census | 1 << n4);
                node.children[n4] = node2;
                if (i == this.depth) {
                    ++this.colors;
                }
            }
            node = node.children[n4];
            node.numberColors += 1 << this.shift[i];
        }
        ++node.numberUnique;
        node.totalRed += n;
        node.totalGreen += n2;
        node.totalBlue += n3;
    }

    void pruneLevel(Node node) {
        if (node.census != 0) {
            for (int i = 0; i < node.children.length; ++i) {
                if ((node.census & 1 << i) == 0) continue;
                this.pruneLevel(node.children[i]);
            }
        }
        if (node.level == this.depth) {
            this.pruneChild(node);
        }
    }

    void reduction(int n) {
        this.nextPruningTreshold = 1;
        while (this.colors > n) {
            this.pruningTreshold = this.nextPruningTreshold;
            this.nextPruningTreshold = this.root.numberColors;
            this.colors = 0;
            this.reduce(this.root);
        }
    }

    void reduce(Node node) {
        if (node.census != 0) {
            for (int i = 0; i < node.children.length; ++i) {
                if ((node.census & 1 << i) == 0) continue;
                this.reduce(node.children[i]);
            }
        }
        if (node.numberColors <= this.pruningTreshold) {
            this.pruneChild(node);
        } else {
            if (node.numberUnique > 0) {
                ++this.colors;
            }
            if (node.numberColors < this.nextPruningTreshold) {
                this.nextPruningTreshold = node.numberColors;
            }
        }
    }

    void pruneChild(Node node) {
        Node node2 = node.parent;
        node2.census = (byte)(node2.census & ~(1 << node.id));
        node2.numberUnique += node.numberUnique;
        node2.totalRed += node.totalRed;
        node2.totalGreen += node.totalGreen;
        node2.totalBlue += node.totalBlue;
        --this.nodes;
    }

    void assignment(int[] nArray, int n) {
        this.colormap = new int[n];
        this.colors = 0;
        this.colorMap(this.root);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            nArray[i] = this.colormap[this.rgb2idx(n3, n4, n5)];
        }
    }

    void colorMap(Node node) {
        int n;
        if (node.census != 0) {
            for (n = 0; n < node.children.length; ++n) {
                if ((node.census & 1 << n) == 0) continue;
                this.colorMap(node.children[n]);
            }
        }
        if (node.numberUnique != 0) {
            n = node.numberUnique >> 1;
            int n2 = (node.totalRed + n) / node.numberUnique;
            int n3 = (node.totalGreen + n) / node.numberUnique;
            int n4 = (node.totalBlue + n) / node.numberUnique;
            node.colorNumber = this.colors;
            this.colormap[this.colors++] = n2 << 16 | n3 << 8 | n4;
        }
    }

    int rgb2idx(int n, int n2, int n3) {
        byte by;
        Node node = this.root;
        while ((node.census & 1 << (by = (byte)((n > node.midRed ? 1 : 0) | (n2 > node.midGreen ? 2 : 0) | (n3 > node.midBlue ? 4 : 0)))) != 0) {
            node = node.children[by];
        }
        this.cdistance = Integer.MAX_VALUE;
        this.cred = n;
        this.cgreen = n2;
        this.cblue = n3;
        this.closestColor(node.parent);
        return this.colorNumber;
    }

    void closestColor(Node node) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (node.census != 0) {
            for (n8 = 0; n8 < node.children.length; ++n8) {
                if ((node.census & 1 << n8) == 0) continue;
                this.closestColor(node.children[n8]);
            }
        }
        if (node.numberUnique != 0 && (n7 = SQUARES[n6 = (n5 = (n8 = this.colormap[node.colorNumber]) >> 16 & 0xFF) - this.cred + 255] + SQUARES[n4 = (n3 = n8 >> 8 & 0xFF) - this.cgreen + 255] + SQUARES[n2 = (n = n8 & 0xFF) - this.cblue + 255]) < this.cdistance) {
            this.cdistance = n7;
            this.colorNumber = node.colorNumber;
        }
    }

    static {
        for (int i = -255; i <= 255; ++i) {
            Octree.SQUARES[i + 255] = i * i;
        }
    }

    public static class Node {
        Node parent;
        Node[] children = new Node[8];
        int midRed;
        int midGreen;
        int midBlue;
        int totalRed;
        int totalGreen;
        int totalBlue;
        byte id;
        byte census;
        byte level;
        int colorNumber;
        int numberUnique;
        int numberColors;

        public Node() {
        }

        public Node(int n, int n2, int n3, Node node, byte by) {
            this.midRed = n;
            this.midGreen = n2;
            this.midBlue = n3;
            this.parent = node;
            this.level = (byte)(node == null ? 0 : node.level + 1);
            this.id = by;
        }
    }
}

