/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.vnds.tools;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import nl.weeaboo.vnds.tools.ImageConverter;

public class MaskConvertor {
    public static void main(String[] stringArray) throws IOException {
        File file = new File("C:/Users/Timon/Desktop/sprites");
        MaskConvertor.process(file);
        ImageConverter imageConverter = new ImageConverter();
        imageConverter.setBackgroundSize(640, 480);
        imageConverter.setDitheringType(ImageConverter.DitheringType.NONE);
        imageConverter.setMode(ImageConverter.ConvertType.TYPE_PNG);
        imageConverter.setScalingType(ImageConverter.ScalingType.SPRITE);
        imageConverter.convertFolder(file.getAbsolutePath(), null, 8);
    }

    private static void process(File file) {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                for (File file2 : file.listFiles()) {
                    MaskConvertor.process(file2);
                }
                break block6;
            }
            if (!file.getName().toLowerCase().endsWith("jpg") && !file.getName().toLowerCase().endsWith("bmp")) break block6;
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                int n = bufferedImage.getWidth();
                int n2 = n / 2;
                int n3 = bufferedImage.getHeight();
                int[] nArray = bufferedImage.getRGB(0, 0, n, n3, new int[n * n3], 0, n);
                for (int i = 0; i < n3; ++i) {
                    int n4 = i * n;
                    for (int j = 0; j < n2; ++j) {
                        int n5 = nArray[n4];
                        int n6 = nArray[n4 + n2];
                        n6 = 255 - (int)(0.3f * (float)(n6 >> 16 & 0xFF) + 0.59f * (float)(n6 >> 8 & 0xFF) + 0.11f * (float)(n6 & 0xFF));
                        n6 = Math.max(0, Math.min(255, n6));
                        nArray[n4] = n6 << 24 | n5 & 0xFFFFFF;
                        ++n4;
                    }
                }
                BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 2);
                bufferedImage2.setRGB(0, 0, n2, n3, nArray, 0, n);
                String string = file.getAbsolutePath();
                string = string.substring(0, string.length() - 3) + "png";
                ImageIO.write((RenderedImage)bufferedImage2, "png", new File(string));
                file.delete();
                System.out.println("Writing: " + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

