/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.vnds.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import nl.weeaboo.vnds.tools.ImageConverter;
import timon.common.Log;
import timon.common.components.DirectValidationField;
import timon.common.components.FileBrowseField;
import timon.common.components.GuiUtil;
import timon.common.components.Sash;
import timon.common.components.Skin;
import timon.common.components.progress.ProgressDialog;
import timon.common.components.progress.ProgressListener;
import timon.common.components.progress.ProgressRunnable;

public class ImageConverterGUI
extends JFrame {
    private ImageConverter converter = new ImageConverter();
    private JComboBox modeCombo;
    private JComboBox scalingCombo;
    private JTextField widthField;
    private JTextField heightField;
    private JSpinner qualitySpinner;
    private JComboBox ditheringCombo;
    private JCheckBox loggingCheck;
    private JSpinner threadsSpinner;
    private FileBrowseField browseField;
    private JButton convertButton;

    public ImageConverterGUI() {
        this.setTitle("VNDS Image Converter v1.0.5");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createCenterPanel(), "Center");
        this.reset();
        this.setMinimumSize(new Dimension(300, 100));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            GuiUtil.setSkin((Skin)Skin.NATIVE);
        }
        catch (Exception exception) {
            Log.warning((Exception)exception);
        }
        if (stringArray.length > 0) {
            try {
                ImageConverter.main(stringArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            new ImageConverterGUI();
        }
    }

    protected JPanel createCenterPanel() {
        JLabel jLabel = new JLabel("Output Type");
        this.modeCombo = new JComboBox<ImageConverter.ConvertType>(ImageConverter.ConvertType.values());
        this.modeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageConverter.ConvertType convertType = (ImageConverter.ConvertType)((Object)ImageConverterGUI.this.modeCombo.getSelectedItem());
                ImageConverterGUI.this.converter.setMode(convertType);
                ImageConverterGUI.this.qualitySpinner.setEnabled(convertType == ImageConverter.ConvertType.TYPE_JPG);
            }
        });
        JLabel jLabel2 = new JLabel("Scaling Mode");
        this.scalingCombo = new JComboBox<ImageConverter.ScalingType>(ImageConverter.ScalingType.values());
        this.scalingCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageConverter.ScalingType scalingType = (ImageConverter.ScalingType)((Object)ImageConverterGUI.this.scalingCombo.getSelectedItem());
                ImageConverterGUI.this.converter.setScalingType(scalingType);
            }
        });
        JLabel jLabel3 = new JLabel("Scaling Mode Size");
        this.widthField = new DirectValidationField(){

            protected boolean isValid(String string) {
                try {
                    int n = Integer.parseInt(string);
                    return n > 0 && n <= 2048;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            protected void onValidTextEntered(String string) {
                int n = Integer.parseInt(string);
                ImageConverterGUI.this.converter.setBackgroundSize(n, ((ImageConverterGUI)ImageConverterGUI.this).converter.getBackgroundSize().height);
            }
        };
        this.heightField = new DirectValidationField(){

            protected boolean isValid(String string) {
                try {
                    int n = Integer.parseInt(string);
                    return n > 0 && n <= 2048;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            protected void onValidTextEntered(String string) {
                int n = Integer.parseInt(string);
                ImageConverterGUI.this.converter.setBackgroundSize(((ImageConverterGUI)ImageConverterGUI.this).converter.getBackgroundSize().width, n);
            }
        };
        JLabel jLabel4 = new JLabel("JPEG Quality");
        this.qualitySpinner = new JSpinner(new SpinnerNumberModel(98, 0, 100, 1));
        this.qualitySpinner.setEnabled(false);
        JLabel jLabel5 = new JLabel("Dithering");
        this.ditheringCombo = new JComboBox<Object>(new Object[]{ImageConverter.DitheringType.NONE, ImageConverter.DitheringType.FLOYD_STEINBERG, ImageConverter.DitheringType.RANDOM});
        this.ditheringCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageConverter.DitheringType ditheringType = (ImageConverter.DitheringType)((Object)ImageConverterGUI.this.ditheringCombo.getSelectedItem());
                ImageConverterGUI.this.converter.setDitheringType(ditheringType);
            }
        });
        JLabel jLabel6 = new JLabel("Write logfile");
        this.loggingCheck = new JCheckBox();
        JLabel jLabel7 = new JLabel("Threads");
        this.threadsSpinner = new JSpinner(new SpinnerNumberModel(8, 1, 128, 1));
        JPanel jPanel = new JPanel(new GridLayout(-1, 3, 5, 5));
        jPanel.add(this.widthField);
        jPanel.add(new JLabel(" x ", 0));
        jPanel.add(this.heightField);
        JPanel jPanel2 = new JPanel(new GridLayout(-1, 2, 15, 5));
        jPanel2.add(jLabel);
        jPanel2.add(this.modeCombo);
        jPanel2.add(jLabel2);
        jPanel2.add(this.scalingCombo);
        jPanel2.add(jLabel3);
        jPanel2.add(jPanel);
        jPanel2.add(jLabel4);
        jPanel2.add(this.qualitySpinner);
        jPanel2.add(jLabel5);
        jPanel2.add(this.ditheringCombo);
        jPanel2.add(jLabel6);
        jPanel2.add(this.loggingCheck);
        jPanel2.add(jLabel7);
        jPanel2.add(this.threadsSpinner);
        this.browseField = new FileBrowseField("Folder", "");
        this.convertButton = new JButton("Convert");
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageConverterGUI.this.convert();
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        jPanel3.add((Component)new Sash(0), "North");
        jPanel3.add((Component)this.browseField, "Center");
        jPanel3.add((Component)this.convertButton, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 10));
        jPanel4.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "South");
        new DropTarget(jPanel4, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            @Override
            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                for (DataFlavor dataFlavor : dropTargetDragEvent.getCurrentDataFlavorsAsList()) {
                    if (!dataFlavor.isFlavorJavaFileListType()) continue;
                    dropTargetDragEvent.acceptDrag(3);
                    break;
                }
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                dropTargetDropEvent.acceptDrop(3);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
                    if (!dataFlavor.isFlavorJavaFileListType()) continue;
                    try {
                        List list = (List)transferable.getTransferData(dataFlavor);
                        ImageConverterGUI.this.convert(list);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        Log.warning((Exception)unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        Log.warning((Exception)iOException);
                    }
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }
        });
        return jPanel4;
    }

    public void convert() {
        this.convert(null);
    }

    public void convert(final List<File> list) {
        Object object;
        final String string = this.browseField.getSelectedPath();
        if (list == null) {
            object = new File(string);
            if (string.equals("") || !((File)object).exists() || !((File)object).isDirectory()) {
                JOptionPane.showMessageDialog(null, "Invalid directory: \"" + string + "\"", "Error", 0);
                return;
            }
        }
        this.converter.setMode((ImageConverter.ConvertType)((Object)this.modeCombo.getSelectedItem()));
        this.converter.setScalingType((ImageConverter.ScalingType)((Object)this.scalingCombo.getSelectedItem()));
        this.converter.setQuality((Integer)this.qualitySpinner.getValue());
        this.converter.setLogging(this.loggingCheck.isSelected());
        this.converter.setMaxThreads((Integer)this.threadsSpinner.getValue());
        object = new ProgressListener(){

            public void onFinished(String string) {
                String string2 = "";
                String string3 = "";
                try {
                    if (ImageConverterGUI.this.converter.isLogging()) {
                        string2 = ImageConverterGUI.this.converter.dumpLog("conversion.log").getAbsolutePath();
                        string3 = String.format("<br><br> Log dumped to %s", string2);
                    }
                    JOptionPane.showMessageDialog(null, String.format("<html>Conversion finished.%s</html>", string3), "Finished", -1);
                }
                catch (IOException iOException) {
                    Log.showError((Exception)iOException);
                }
            }

            public void onProgress(int n, int n2, String string) {
            }
        };
        ProgressRunnable progressRunnable = new ProgressRunnable(){

            public void run(ProgressListener progressListener) {
                if (list == null) {
                    try {
                        ImageConverterGUI.this.converter.convertFolder(string, progressListener);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    for (File file : list) {
                        ImageConverterGUI.this.converter.convertFile(file);
                    }
                }
            }
        };
        ProgressDialog progressDialog = new ProgressDialog();
        progressDialog.showDialog(progressRunnable, (ProgressListener)object);
    }

    public void reset() {
        this.widthField.setText("800");
        this.heightField.setText("600");
        this.qualitySpinner.setValue(this.converter.getQuality());
        this.threadsSpinner.setValue(this.converter.getMaxThreads());
    }
}

