/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.vnds.tools;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import timon.common.Log;
import timon.common.SystemUtil;
import timon.common.components.progress.ProgressListener;
import timon.common.io.BatchProcess;
import timon.common.io.FileTask;
import timon.common.io.FileUtil;

public class ImageConverter {
    private int maxThreads = 8;
    private ConvertType mode = ConvertType.TYPE_RAW_RGBA;
    private ScalingType scaling = ScalingType.NONE;
    private Dimension backgroundSize = new Dimension(800, 600);
    private int quality = 98;
    private DitheringType dithering = DitheringType.NONE;
    private boolean log;
    private Map<File, StringBuilder> processLogs;

    protected static void printUsage() {
        System.err.printf("Usage: java -jar ImageConverter.jar <flags> <file>\nflags:\n\t-threads <num>\n\t-raw <RGBA|256>\n\t-png <RGBA|256>\n\t-jpg <quality (0-100)>\n", new Object[0]);
    }

    public static void main(String[] stringArray) throws IOException {
        ImageConverter imageConverter = new ImageConverter();
        String string = null;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("-jpg")) {
                    imageConverter.setMode(ConvertType.TYPE_JPG);
                    imageConverter.quality = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].startsWith("-png")) {
                    if (!stringArray[++i].equals("256")) {
                        imageConverter.setMode(ConvertType.TYPE_PNG);
                        continue;
                    }
                    imageConverter.setDitheringType(DitheringType.FLOYD_STEINBERG);
                    imageConverter.setMode(ConvertType.TYPE_PNG_256_NEUQUANT);
                    continue;
                }
                if (stringArray[i].startsWith("-raw")) {
                    if (!stringArray[++i].equals("256")) {
                        imageConverter.setMode(ConvertType.TYPE_RAW_RGBA);
                        continue;
                    }
                    imageConverter.setDitheringType(DitheringType.FLOYD_STEINBERG);
                    imageConverter.setMode(ConvertType.TYPE_RAW_RGB256);
                    continue;
                }
                if (stringArray[i].startsWith("-threads")) {
                    imageConverter.maxThreads = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (string == null) {
                    string = stringArray[i];
                    continue;
                }
                throw new IllegalArgumentException("Error parsing arg: " + stringArray[i]);
            }
        }
        catch (RuntimeException runtimeException) {
            ImageConverter.printUsage();
            return;
        }
        if (string == null) {
            ImageConverter.printUsage();
            return;
        }
        imageConverter.convertFolder(string, new ProgressListener(){

            public void onFinished(String string) {
                System.out.printf("%s\n", string);
            }

            public void onProgress(int n, int n2, String string) {
                System.out.printf("Processing (%d/%d) %s...\n", n, n2, string);
            }
        });
    }

    public void convertFolder(String string, ProgressListener progressListener) throws IOException {
        this.convertFolder(string, progressListener, 1);
    }

    public void convertFolder(String string, ProgressListener progressListener, int n) throws IOException {
        this.processLogs = new HashMap<File, StringBuilder>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        File file = new File(string).getCanonicalFile();
        if (file.isDirectory()) {
            for (BatchProcess batchProcess : file.listFiles()) {
                if (batchProcess.isDirectory()) continue;
                hashMap.put(batchProcess.getName(), batchProcess);
            }
        } else {
            hashMap.put(file.getName(), file);
        }
        BatchProcess batchProcess = new BatchProcess();
        batchProcess.setTaskSize(32);
        batchProcess.setThreads(this.maxThreads);
        batchProcess.setThreadPriority(1);
        batchProcess.addProgressListener(progressListener);
        try {
            batchProcess.run(hashMap, new FileTask(){

                public void processFile(String string, File file) throws IOException {
                    ImageConverter.this.convertFile(file);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public File convertFile(File file) {
        return this.convertFile(file, null);
    }

    public File convertFile(File file, String string) {
        String string2 = file.getName();
        if (string2.lastIndexOf(46) > 0) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isLogging()) {
            this.processLogs.put(file, stringBuilder);
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(file);
            }
            catch (RuntimeException runtimeException) {
                Log.error((Exception)runtimeException);
            }
            if (bufferedImage == null) {
                Log.error((String)("Unreadable image: " + file.getAbsolutePath()));
                return null;
            }
            int n5 = bufferedImage.getWidth();
            int n6 = bufferedImage.getHeight();
            Dimension dimension = this.scaling == ScalingType.SPRITE ? new Dimension(n5 * 256 / this.backgroundSize.width, n6 * 192 / this.backgroundSize.height) : (this.scaling == ScalingType.BACKGROUND ? new Dimension(256, 192) : new Dimension(n5, n6));
            n5 = dimension.width;
            n6 = dimension.height;
            Image image = bufferedImage.getScaledInstance(dimension.width, dimension.height, 4);
            int n7 = 2;
            if (this.mode == ConvertType.TYPE_JPG) {
                n7 = 1;
            }
            bufferedImage = new BufferedImage(n5, n6, n7);
            bufferedImage.getGraphics().drawImage(image, (n5 - dimension.width) / 2, (n6 - dimension.height) / 2, null);
            int[] nArray = bufferedImage.getRGB(0, 0, n5, n6, new int[n5 * n6], 0, n5);
            if (this.mode == ConvertType.TYPE_JPG) {
                int n8 = 0;
                for (n4 = 0; n4 < n6; ++n4) {
                    n3 = n4 * n5;
                    for (n2 = 0; n2 < n5; ++n2) {
                        n = nArray[n3 + n2];
                        nArray[n3 + n2] = (n >> 24 & 0xFF) < 200 ? n8 | 0xFF000000 : n | 0xFF000000;
                    }
                }
            }
            if (this.dithering == DitheringType.RANDOM) {
                Random random = new Random(0x13371337L);
                n4 = 0;
                for (n3 = 0; n3 < n6; ++n3) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        n = nArray[n4];
                        double d = (double)(n >> 16 & 0xFF) * 31.0 / 255.0;
                        double d2 = (double)(n >> 8 & 0xFF) * 31.0 / 255.0;
                        double d3 = (double)(n & 0xFF) * 31.0 / 255.0;
                        boolean bl = (double)random.nextFloat() < (d - Math.floor(d) + d2 - Math.floor(d2) + d3 - Math.floor(d3)) / 3.0;
                        int n9 = (int)(bl ? Math.ceil(d) : Math.floor(d));
                        int n10 = (int)(bl ? Math.ceil(d2) : Math.floor(d2));
                        int n11 = (int)(bl ? Math.ceil(d3) : Math.floor(d3));
                        nArray[n4] = n & 0xFF000000 | (n9 << 3 & 0xFF) << 16 | (n10 << 3 & 0xFF) << 8 | n11 << 3 & 0xFF;
                        ++n4;
                    }
                }
            } else if (this.dithering == DitheringType.FLOYD_STEINBERG) {
                ImageConverter.floydSteinberg(nArray, n5, n6);
            }
            if (string == null) {
                string = file.getParent();
                file.delete();
            }
            String string3 = String.valueOf(this.hashCode() ^ Thread.currentThread().hashCode());
            file = new File(String.format("%s/%s.%s", string, string2, this.mode.getFileExt().toLowerCase()));
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (this.mode.getFileExt().equalsIgnoreCase("jpg")) {
                String string4 = String.format("%s/__%s.bmp", string, string3);
                String string5 = String.format("%s/__%s.png", string, string3);
                bufferedImage.setRGB(0, 0, n5, n6, nArray, 0, n5);
                ImageIO.write((RenderedImage)bufferedImage, "bmp", new File(string4));
                Process process = SystemUtil.execInDir((String)String.format("cjpeg -quality %d -optimize -dct fast \"%s\" \"%s\"", this.quality, string4, string5), (String)"tools/");
                SystemUtil.waitFor((Process)process);
                file.delete();
                new File(string4).delete();
                new File(string5).renameTo(file);
            } else if (this.mode.getFileExt().equalsIgnoreCase("png")) {
                String string6 = String.format("%s/__%s.png", string, string3);
                bufferedImage.setRGB(0, 0, n5, n6, nArray, 0, n5);
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string6));
                if (this.mode == ConvertType.TYPE_PNG_256_MEDIAN) {
                    Process process = SystemUtil.execInDir((String)String.format("pngquant 256 \"%s\"", string6), (String)"tools/pngquant-0.95/");
                    SystemUtil.waitFor((Process)process);
                    file.delete();
                    new File(FileUtil.stripExtension((String)string6) + "-fs8.png").renameTo(file);
                } else if (this.mode == ConvertType.TYPE_PNG_256_NEUQUANT) {
                    Process process = SystemUtil.execInDir((String)String.format("pngnq \"%s\"", string6), (String)"tools/pngnq-0.5-i386/");
                    SystemUtil.waitFor((Process)process);
                    file.delete();
                    new File(FileUtil.stripExtension((String)string6) + "-nq8.png").renameTo(file);
                } else {
                    String string7 = FileUtil.stripExtension((String)string6) + ".crushed.png";
                    Process process = SystemUtil.execInDir((String)String.format("pngcrush -fix \"%s\" \"%s\"", string6, string7), (String)"tools/pngcrush-1.6.10/");
                    SystemUtil.waitFor((Process)process);
                    file.delete();
                    new File(string7).renameTo(file);
                }
                new File(string6).delete();
            } else if (this.mode.getFileExt().equalsIgnoreCase("dta")) {
                if (this.mode == ConvertType.TYPE_RAW_RGBA) {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    for (int n12 : nArray) {
                        int n13 = n12 >>> 24 >= 127 ? 32768 : 0;
                        int n14 = n12 >> 19 & 0x1F;
                        int n15 = n12 >> 11 & 0x1F;
                        int n16 = n12 >> 3 & 0x1F;
                        n12 = n13 | n16 << 10 | n15 << 5 | n14;
                        bufferedOutputStream.write(n12 & 0xFF);
                        bufferedOutputStream.write(n12 >> 8 & 0xFF);
                    }
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                } else if (this.mode == ConvertType.TYPE_RAW_RGB256) {
                    int n17;
                    ImageConverter.floydSteinberg(nArray, n5, n6);
                    File file2 = new File(String.format("%s/__%s.png", string, string3));
                    bufferedImage.setRGB(0, 0, n5, n6, nArray, 0, n5);
                    ImageIO.write((RenderedImage)bufferedImage, "png", file2);
                    Process process = SystemUtil.execInDir((String)String.format("pngnq \"%s\"", file2.getAbsolutePath()), (String)"tools/pngnq-0.5-i386/");
                    SystemUtil.waitFor((Process)process);
                    file2.delete();
                    new File(FileUtil.stripExtension((String)file2.getAbsolutePath()) + "-nq8.png").renameTo(file2);
                    bufferedImage = ImageIO.read(file2);
                    IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(FileUtil.stripExtension((String)file.getAbsolutePath()) + ".pal"));
                    for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
                        n17 = 32768;
                        int n18 = indexColorModel.getRed(i) >> 3;
                        int n19 = indexColorModel.getGreen(i) >> 3;
                        int n20 = indexColorModel.getBlue(i) >> 3;
                        int n21 = n17 | n20 << 10 | n19 << 5 | n18;
                        bufferedOutputStream.write(n21 & 0xFF);
                        bufferedOutputStream.write(n21 >> 8 & 0xFF);
                    }
                    bufferedOutputStream.close();
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    int[] nArray2 = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
                    bufferedImage.getRaster().getPixels(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray2);
                    for (n17 = 0; n17 < nArray2.length; ++n17) {
                        bufferedOutputStream.write(nArray2[n17]);
                    }
                    bufferedOutputStream.close();
                    file2.delete();
                }
            } else {
                throw new IllegalArgumentException("Invalid file-ext: " + this.mode.getFileExt());
            }
            return file;
        }
        catch (Exception exception) {
            Log.error((String)(file.getName() + " " + exception));
            stringBuilder.append(exception.toString());
            return null;
        }
    }

    public File dumpLog(String string) throws IOException {
        File file = new File(string);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("----------------------------------------");
        printWriter.println("----------------------------------------");
        for (Map.Entry<File, StringBuilder> entry : this.getLogs().entrySet()) {
            printWriter.println();
            printWriter.println("Log for file:" + entry.getKey().getAbsolutePath());
            printWriter.println();
            printWriter.println(entry.getValue().toString());
            printWriter.println("----------------------------------------");
            printWriter.println("----------------------------------------");
        }
        printWriter.close();
        return file;
    }

    private static void floydSteinberg(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        double[][][] dArray = new double[n][n2][4];
        int n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                dArray[n4][n5][0] = nArray[n6] >>> 16 & 0xFF;
                dArray[n4][n5][1] = nArray[n6] >>> 8 & 0xFF;
                dArray[n4][n5][2] = nArray[n6] & 0xFF;
                dArray[n4][n5][3] = nArray[n6] >>> 24 & 0xFF;
                ++n6;
            }
        }
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                for (n3 = 0; n3 < 3; ++n3) {
                    double d = dArray[n5][n4][n3];
                    double d2 = (double)Math.round(d / 8.0) * 8.0;
                    dArray[n5][n4][n3] = d2;
                    double d3 = d2;
                    double d4 = d - d3;
                    if (n5 + 1 < n) {
                        double[] dArray2 = dArray[n5 + 1][n4];
                        int n7 = n3;
                        dArray2[n7] = dArray2[n7] + 7.0 * d4 / 16.0;
                        dArray[n5 + 1][n4][n3] = Math.min(255.0, Math.max(0.0, dArray[n5 + 1][n4][n3]));
                    }
                    if (n4 + 1 >= n2) continue;
                    if (n5 - 1 >= 0) {
                        double[] dArray3 = dArray[n5 - 1][n4 + 1];
                        int n8 = n3;
                        dArray3[n8] = dArray3[n8] + 3.0 * d4 / 16.0;
                        dArray[n5 - 1][n4 + 1][n3] = Math.min(255.0, Math.max(0.0, dArray[n5 - 1][n4 + 1][n3]));
                    }
                    double[] dArray4 = dArray[n5][n4 + 1];
                    int n9 = n3;
                    dArray4[n9] = dArray4[n9] + 5.0 * d4 / 16.0;
                    dArray[n5][n4 + 1][n3] = Math.min(255.0, Math.max(0.0, dArray[n5][n4 + 1][n3]));
                    if (n5 + 1 >= n) continue;
                    double[] dArray5 = dArray[n5 + 1][n4 + 1];
                    int n10 = n3;
                    dArray5[n10] = dArray5[n10] + 1.0 * d4 / 16.0;
                    dArray[n5 + 1][n4 + 1][n3] = Math.min(255.0, Math.max(0.0, dArray[n5 + 1][n4 + 1][n3]));
                }
            }
        }
        n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = Math.min(255, Math.max(0, (int)Math.round(dArray[n4][n5][3])));
                int n11 = Math.min(255, Math.max(0, (int)Math.round(dArray[n4][n5][0])));
                int n12 = Math.min(255, Math.max(0, (int)Math.round(dArray[n4][n5][1])));
                int n13 = Math.min(255, Math.max(0, (int)Math.round(dArray[n4][n5][2])));
                nArray[n6] = n3 << 24 | n11 << 16 | n12 << 8 | n13;
                ++n6;
            }
        }
    }

    public Map<File, StringBuilder> getLogs() {
        return this.processLogs;
    }

    public boolean isLogging() {
        return this.log;
    }

    public ConvertType getMode() {
        return this.mode;
    }

    public ScalingType getScaling() {
        return this.scaling;
    }

    public Dimension getBackgroundSize() {
        return new Dimension(this.backgroundSize);
    }

    public int getQuality() {
        return this.quality;
    }

    public DitheringType getDitheringType() {
        return this.dithering;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMode(ConvertType convertType) {
        this.mode = convertType;
    }

    public void setScalingType(ScalingType scalingType) {
        this.scaling = scalingType;
    }

    public void setLogging(boolean bl) {
        this.log = bl;
    }

    public void setBackgroundSize(int n, int n2) {
        this.backgroundSize.width = n;
        this.backgroundSize.height = n2;
    }

    public void setQuality(int n) {
        this.quality = n;
    }

    public void setDitheringType(DitheringType ditheringType) {
        this.dithering = ditheringType;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    public static enum DitheringType {
        NONE("None"),
        RANDOM("Random"),
        FLOYD_STEINBERG("Floyd-Steinberg");

        String label;

        private DitheringType(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum ScalingType {
        NONE("None"),
        BACKGROUND("Background"),
        SPRITE("Sprite");

        String label;

        private ScalingType(String string2) {
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum ConvertType {
        TYPE_RAW_RGBA("RAW RGBA", "dta"),
        TYPE_RAW_RGB256("RAW RGB256", "dta"),
        TYPE_JPG("JPG", "jpg"),
        TYPE_PNG("PNG", "png"),
        TYPE_PNG_256_NEUQUANT("PNG 256 (neuquant)", "png"),
        TYPE_PNG_256_MEDIAN("PNG 256 (median)", "png");

        private String label;
        private String fileExt;

        private ConvertType(String string2, String string3) {
            this.label = string2;
            this.fileExt = string3;
        }

        public String getFileExt() {
            return this.fileExt;
        }

        public String toString() {
            return this.label;
        }
    }
}

