/*
 * Decompiled with CFR 0.152.
 */
package timon.common.xml;

import timon.common.StringUtil;
import timon.common.xml.XmlElement;

public class XmlUtil {
    private static String level0Escape(String string) {
        string = StringUtil.replaceAllNoRegex(string, "&", "&amp;");
        string = StringUtil.replaceAllNoRegex(string, "\"", "&quot;");
        string = StringUtil.replaceAllNoRegex(string, "<", "&lt;");
        string = StringUtil.replaceAllNoRegex(string, ">", "&gt;");
        return string;
    }

    private static String level0Unescape(String string) {
        string = StringUtil.replaceAllNoRegex(string, "&gt;", ">");
        string = StringUtil.replaceAllNoRegex(string, "&lt;", "<");
        string = StringUtil.replaceAllNoRegex(string, "&quot;", "\"");
        string = StringUtil.replaceAllNoRegex(string, "&amp;", "&");
        return string;
    }

    private static String level1Escape(String string) {
        string = XmlUtil.level0Escape(string);
        StringBuilder sb = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            boolean ok;
            char c = string.charAt(n);
            boolean bl = ok = Character.isLetter(c) || c == '_' || c == ':';
            if (!ok && n > 0) {
                boolean bl2 = ok = Character.isDigit(c) || c == '.' || c == '-';
            }
            if (!ok) {
                sb.append('_');
            } else {
                sb.append(c);
            }
            ++n;
        }
        return sb.toString();
    }

    public static String tagEscape(String tag) {
        tag = XmlUtil.level0Escape(tag);
        return XmlUtil.escapeToASCII(tag);
    }

    public static String tagUnescape(String tag) {
        return XmlUtil.level0Unescape(tag);
    }

    public static String attributeNameEscape(String name) {
        name = XmlUtil.level1Escape(name);
        return XmlUtil.escapeToASCII(name);
    }

    public static String attributeValueEscape(String value) {
        value = XmlUtil.level0Escape(value);
        return XmlUtil.escapeToASCII(value);
    }

    public static String escapeToASCII(String string) {
        StringBuilder sb = new StringBuilder();
        int[] nArray = StringUtil.toUnicodeArray(string);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            if (c > 127) {
                sb.append("&#");
                sb.append(c);
                sb.append(';');
            } else {
                sb.append((char)c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String unescapeFromASCII(String string) {
        StringBuilder sb = new StringBuilder();
        int[] chars = StringUtil.toUnicodeArray(string);
        int n = 0;
        while (n < chars.length) {
            if (chars[n] == 38 && n + 1 < chars.length && chars[n + 1] == 35) {
                int start;
                int end = start = n + 2;
                while (end < chars.length && chars[end] != 59) {
                    ++end;
                }
                int c = Integer.parseInt(new String(chars, start, end - start));
                sb.append(Character.toChars(c));
            } else {
                sb.append((char)chars[n]);
            }
            ++n;
        }
        return sb.toString();
    }

    public static String stripTags(String text) {
        StringBuilder sb = new StringBuilder();
        boolean inTag = false;
        int n = 0;
        while (n < text.length()) {
            char c = text.charAt(n);
            if (c == '<') {
                inTag = true;
            }
            if (!inTag) {
                sb.append(c);
            }
            if (c == '>') {
                inTag = false;
            }
            ++n;
        }
        return sb.toString();
    }

    public static String encodeRGB(int[] data) {
        StringBuilder sb = new StringBuilder();
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            String s = Integer.toHexString(i);
            int t = s.length();
            while (t < 6) {
                sb.append('0');
                ++t;
            }
            sb.append(s.substring(Math.max(0, s.length() - 6), s.length()));
            ++n2;
        }
        return sb.toString();
    }

    public static int[] decodeRGB(String data) {
        int[] rgb = new int[data.length() / 6];
        int x = 0;
        int n = 0;
        while (n < data.length()) {
            int color = 0;
            int t = 0;
            while (t < 6) {
                int c = data.charAt(t);
                if (c >= 48 && c <= 57) {
                    c -= 48;
                } else if (c >= 97 && c <= 102) {
                    c = 10 + (c - 97);
                } else if (c >= 65 && c <= 70) {
                    c = 10 + (c - 65);
                } else {
                    throw new NumberFormatException("Unknown char: " + c);
                }
                color = color << 4 | c;
                ++t;
            }
            rgb[x] = color;
            ++x;
            n += 6;
        }
        return rgb;
    }

    public static String getString(XmlElement element, String childName) {
        XmlElement child = element.getChild(childName);
        if (child != null) {
            return child.getTextContent();
        }
        return null;
    }

    public static String getId(XmlElement element, String childName) {
        String s = XmlUtil.getString(element, childName);
        if (StringUtil.isValidId(s)) {
            return s;
        }
        return null;
    }

    public static String getIdAttribute(XmlElement element, String attributeName) {
        String s = element.getAttribute(attributeName);
        if (StringUtil.isValidId(s)) {
            return s;
        }
        return null;
    }

    public static Integer getInteger(XmlElement element, String childName) {
        String string = XmlUtil.getString(element, childName);
        if (string != null) {
            try {
                return Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getInt(XmlElement element, String childName, int defaultValue) {
        String string = XmlUtil.getString(element, childName);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntAttribute(XmlElement element, String attributeName, int defaultValue) {
        String string = element.getAttribute(attributeName);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLong(XmlElement element, String childName, long defaultValue) {
        String string = XmlUtil.getString(element, childName);
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloat(XmlElement element, String childName, float defaultValue) {
        String string = XmlUtil.getString(element, childName);
        if (string != null) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloatAttribute(XmlElement element, String attributeName, float defaultValue) {
        String string = element.getAttribute(attributeName);
        if (string != null) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBoolean(XmlElement element, String childName, boolean defaultValue) {
        String string = XmlUtil.getString(element, childName);
        if (string != null) {
            try {
                return Boolean.parseBoolean(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanAttribute(XmlElement element, String attributeName, boolean defaultValue) {
        String string = element.getAttribute(attributeName);
        if (string != null) {
            try {
                return Boolean.parseBoolean(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

