/*
 * Decompiled with CFR 0.152.
 */
package timon.common.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import timon.common.Log;
import timon.common.xml.XmlElement;
import timon.common.xml.XmlNode;
import timon.common.xml.XmlTextNode;

public class XmlReader {
    protected DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Log.warning(e);
            return null;
        }
    }

    public XmlElement read(File file) throws SAXException, IOException {
        DocumentBuilder db = this.createDocumentBuilder();
        return (XmlElement)XmlReader.convert(db.parse(file));
    }

    public XmlElement read(InputStream in) throws SAXException, IOException {
        DocumentBuilder db = this.createDocumentBuilder();
        return (XmlElement)XmlReader.convert(db.parse(in));
    }

    public static XmlNode convert(Node node) {
        if (node instanceof Element || node instanceof Document) {
            XmlElement object;
            String prefix = node.getPrefix();
            if (prefix == null) {
                object = new XmlElement(node.getNodeName());
            } else {
                String name = node.getNodeName();
                name = name.substring(name.indexOf(58) + 1);
                object = new XmlElement(String.valueOf(prefix) + ":" + name);
            }
            XmlReader.parseAttributes(object, node);
            NodeList list = null;
            if (node instanceof Element) {
                list = ((Element)node).getChildNodes();
            } else if (node instanceof Document) {
                list = ((Document)node).getChildNodes();
            }
            int n = 0;
            while (n < list.getLength()) {
                object.addChild(XmlReader.convert(list.item(n)));
                ++n;
            }
            return object;
        }
        return new XmlTextNode(node.getNodeValue());
    }

    private static XmlElement parseAttributes(XmlElement object, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                Node a = attributes.item(n);
                object.addAttribute(a.getNodeName(), a.getNodeValue());
                ++n;
            }
        }
        return object;
    }
}

